/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.common;

import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifyingWeakReference<Type> {
    private static final PollingService SERVICE = new PollingService();
    protected final WeakReference<Type> mf_oReference;
    protected final IFinalizedListener mf_oListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotifyingWeakReference(Type p_oReferrent, IFinalizedListener p_oListener) {
        this.mf_oReference = new WeakReference<Type>(p_oReferrent);
        this.mf_oListener = p_oListener;
        LinkedList<NotifyingWeakReference<?>> linkedList = NotifyingWeakReference.SERVICE.mf_oListenerList;
        synchronized (linkedList) {
            NotifyingWeakReference.SERVICE.mf_oListenerList.add(this);
        }
    }

    public final Type getReferrent() {
        return (Type)this.mf_oReference.get();
    }

    public final void clear() {
        this.mf_oReference.clear();
    }

    static {
        SERVICE.start();
    }

    private static class PollingService
    extends Thread {
        private static final long TIMEOUT = 1000L;
        public final LinkedList<NotifyingWeakReference<?>> mf_oListenerList = new LinkedList();

        public PollingService() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LinkedList<NotifyingWeakReference<?>> linkedList = this.mf_oListenerList;
                synchronized (linkedList) {
                    ListIterator oIterator = this.mf_oListenerList.listIterator();
                    while (oIterator.hasNext()) {
                        NotifyingWeakReference oRef = (NotifyingWeakReference)oIterator.next();
                        if (oRef.mf_oReference.get() != null) continue;
                        oIterator.remove();
                        oRef.mf_oListener.notify(oRef);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IFinalizedListener {
        public void notify(NotifyingWeakReference<?> var1);
    }
}

