/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client;

import com.mayastudios.fred.client.Main;
import com.mayastudios.launcher.IBootstrap;
import com.mayastudios.systeminfo.MacOSInfo;
import com.mayastudios.systeminfo.SystemInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class Bootstrapper
implements IBootstrap {
    public void prepareStart() {
    }

    public String getMainClass() {
        return Main.class.getCanonicalName();
    }

    public List<String> getClassPath() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("fred/fred.jar");
        arrayList.add("lib/fred-replication-api.jar");
        arrayList.add("lib/fred-server-model.jar");
        arrayList.add("lib/mscl4j.jar");
        arrayList.add("lib/ixml-commons.jar");
        arrayList.add("lib/ixml-labels.jar");
        arrayList.add("lib/ixml.jar");
        arrayList.add("lib/systeminfo.jar");
        arrayList.add("lib/jibx-run.jar");
        arrayList.add("lib/launcher.jar");
        arrayList.add("lib/jna.jar");
        arrayList.add("lib/commons-logging.jar");
        arrayList.add("lib/slf4j-api.jar");
        arrayList.add("lib/slf4j-simple.jar");
        arrayList.add("lib/xercesImpl.jar");
        arrayList.add("lib/castor.jar");
        switch (SystemInfo.OSTYPE) {
            case Windows: {
                arrayList.add("lib/tray_win.jar");
                break;
            }
            default: {
                arrayList.add("lib/tray_mock.jar");
            }
        }
        arrayList.add("lib/BrowserLauncher.jar");
        return arrayList;
    }

    public Properties getAdditionalProperties(Properties properties) {
        String string = System.getProperty("UserMode");
        if (string != null) {
            properties.setProperty("UserMode", string);
        }
        if (SystemInfo.OSTYPE == SystemInfo.OperatationSystemType.Linux && SystemInfo.INFO.getJavaArch() == SystemInfo.JavaArch.x64) {
            properties.setProperty("IsX64", "1");
        } else if (SystemInfo.OSTYPE == SystemInfo.OperatationSystemType.MacOS && ((MacOSInfo)SystemInfo.INFO).isMacOSX()) {
            properties.setProperty("com.apple.mrj.application.apple.menu.about.name", "Fred 2009");
        }
        return properties;
    }

    public List<String> getNonStadardOptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList("-Xms32m", "-Xmx256m"));
        String string = System.getProperty("java.runtime.version");
        if (string != null && string.startsWith("1.6.0")) {
            arrayList.add("-Dsun.java2d.d3d=false");
        }
        return arrayList;
    }
}

