/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.controller;

import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.servertuning.CReplicationServiceEx;
import com.mayastudios.fred.client.view.dialogs.CDlgServerCommunication;
import com.mayastudios.fred.client.view.dialogs.FredMessageBox;
import com.mayastudios.mscl.JavaHelper;
import com.mayastudios.mscl.mwt.MessageBox;
import de.sopra06.replication.exceptions.ReplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CServerController {
    public static final int STATUS_REPLICATION_EXCEPTION = 10000;
    public static final int STATUS_USER_HAS_ABORTED = 11000;
    private static final Logger LOGGER = LoggerFactory.getLogger(CServerController.class);
    private CDlgServerCommunication m_oProgressDlg = new CDlgServerCommunication();
    private CReplicationThread m_oReplicationThread;
    private int m_iStatus = 100;
    private Exception m_oServerException = null;

    public CServerController(CReplicationServiceEx cReplicationServiceEx, EReplicationJob eReplicationJob) {
        this.m_oReplicationThread = new CReplicationThread(cReplicationServiceEx, eReplicationJob);
    }

    public void start() {
        this.m_oReplicationThread.start();
        this.m_oProgressDlg.showDialog();
        if (this.getStatus() == 100) {
            this.setStatus(11000);
        }
        this.m_oReplicationThread.stop();
        if (this.getStatus() != 200) {
            this._showServerErrorDialog();
        }
    }

    synchronized void setStatus(int n) {
        this.m_iStatus = n;
    }

    public synchronized int getStatus() {
        return this.m_iStatus;
    }

    private void _showServerErrorDialog() {
        String string;
        Exception exception = this.m_oServerException;
        MessageBox.EIcon eIcon = MessageBox.EIcon.ERROR;
        switch (this.getStatus()) {
            case 500: {
                string = Labels.get("INFORMATION_SERVER_ERROR", new Object[0]);
                break;
            }
            case 300: {
                string = Labels.get("INFORMATION_SERVER_PROJECT_CLOSED", new Object[0]) + "\n";
                break;
            }
            case 10000: {
                if (this.m_oServerException instanceof ReplicationException && exception.getMessage().startsWith("An IOException occured!\njava.io.FileNotFoundException:")) {
                    string = Labels.get("INFORMATION_SERVER_URLNOTFOUND", new Object[0]) + this.m_oReplicationThread.mf_oReplicationService.getURL();
                    exception = null;
                    break;
                }
                string = Labels.get("INFORMATION_SERVER_EXCEPTION", new Object[0]);
                break;
            }
            case 11000: {
                string = Labels.get("INFORMATION_SERVER_USER_HAS_ABORTED", new Object[0]);
                eIcon = MessageBox.EIcon.INFORMATION;
                break;
            }
            default: {
                string = Labels.get("INFORMATION_SERVER_UNKOWN_ERROR", new Object[0]);
            }
        }
        String string2 = Labels.get("INFORMATION_SERVER_ABORTED", new Object[0]) + string;
        if (exception != null) {
            string2 = string2 + Labels.get("INFORMATION_SERVER_ABORTED_MOREINFO", new Object[0]) + exception.getLocalizedMessage();
        }
        FredMessageBox.showInfoDlg(string2, Labels.get("TITLE_SERVER", new Object[0]), eIcon, exception);
    }

    void replicationFinished(Exception exception) {
        this.m_oServerException = exception;
        this.m_oProgressDlg.closeDialog();
    }

    private class CReplicationThread
    extends Thread {
        final CReplicationServiceEx mf_oReplicationService;
        final EReplicationJob mf_eType;

        CReplicationThread(CReplicationServiceEx cReplicationServiceEx, EReplicationJob eReplicationJob) {
            this.mf_oReplicationService = cReplicationServiceEx;
            this.mf_eType = eReplicationJob;
        }

        @Override
        public void run() {
            Throwable throwable;
            block14: {
                throwable = null;
                JavaHelper.sleep((long)1000L);
                try {
                    switch (this.mf_eType) {
                        case receiveProjects: {
                            this.mf_oReplicationService.receiveProjects();
                            break;
                        }
                        case sendNewProject: {
                            this.mf_oReplicationService.sendNewProject();
                            break;
                        }
                        case closeProject: {
                            this.mf_oReplicationService.closeProject();
                            break;
                        }
                        case receiveTasks: {
                            this.mf_oReplicationService.receiveTasks();
                            break;
                        }
                        case sendNewTasks: {
                            this.mf_oReplicationService.sendNewTasks();
                            break;
                        }
                        case receiveEfforts: {
                            this.mf_oReplicationService.receiveEfforts();
                            break;
                        }
                        case sendNewEfforts: {
                            this.mf_oReplicationService.sendNewEfforts();
                        }
                    }
                    if (CServerController.this.getStatus() == 100) {
                        CServerController.this.setStatus(this.mf_oReplicationService.getStatus());
                    }
                }
                catch (ReplicationException replicationException) {
                    LOGGER.error("Replication error", (Throwable)replicationException);
                    if (CServerController.this.getStatus() == 100) {
                        CServerController.this.setStatus(10000);
                        throwable = replicationException;
                    }
                }
                catch (RuntimeException runtimeException) {
                    LOGGER.error("Replication error", (Throwable)runtimeException);
                    if (CServerController.this.getStatus() != 100) break block14;
                    CServerController.this.setStatus(10000);
                    throwable = runtimeException;
                }
            }
            CServerController.this.replicationFinished((Exception)throwable);
        }
    }

    public static enum EReplicationJob {
        sendNewProject,
        receiveProjects,
        closeProject,
        sendNewTasks,
        receiveTasks,
        sendNewEfforts,
        receiveEfforts;

    }
}

