/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.controller;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.controller.TrayIconController;
import com.mayastudios.fred.client.resources.DataMask;
import com.mayastudios.fred.client.view.CContextMenu;
import com.mayastudios.fred.client.view.CMenuBar;
import com.mayastudios.fred.client.view.QuickBar;
import com.mayastudios.ixml.commands.BaseCommandController;
import com.mayastudios.ixml.commands.BaseLayoutController;
import com.mayastudios.ixml.commands.base.Command;
import com.mayastudios.ixml.commands.menu.IXMLContextMenu;
import com.mayastudios.ixml.commands.menu.MenuCompFactory;
import com.mayastudios.ixml.common.SystemInfo;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandController {
    private static final String INVOKE_PREFIX = "invoke";
    private static final String TOGGLE_STATE_PREFIX = "getState";
    private static final String COMMANDS_FILE = "cfg/Commands.xml";
    private static final String LAYOUT_FILE;
    private static final Logger LOGGER;
    private static final String MAINMENU_LAYOUT_ID = "mainmenu";
    private static final String MAINTOOLBAR_LAYOUT_ID = "MainToolbar";

    public static List<BaseLayoutController.BaseMenuNode<DataMask>> getToolbarItems() {
        return InnerLayoutController.INSTANCE.getToolbarItems();
    }

    public static CContextMenu createContextMenu(String string) {
        return InnerLayoutController.INSTANCE.createContextMenu(string);
    }

    public static CMenuBar createMenuBar() {
        return InnerLayoutController.INSTANCE.createMenuBar();
    }

    static {
        LOGGER = LoggerFactory.getLogger(CommandController.class);
        LAYOUT_FILE = SystemInfo.OSTYPE == SystemInfo.EOSType.MacOS ? "cfg/LayoutMacOS.xml" : "cfg/Layout.xml";
    }

    public static class InnerLayoutController
    extends BaseLayoutController<DataMask> {
        private static final InnerLayoutController INSTANCE = new InnerLayoutController();
        final Map<String, List<BaseLayoutController.BaseMenuNode<DataMask>>> mf_oLayouts;

        private InnerLayoutController() {
            super(DataMask.class);
            try {
                this.mf_oLayouts = this.loadLayouts(MainController.getResLoader().getResourceStreamExcpt(LAYOUT_FILE), InnerCommandController.INSTANCE.mf_oCommandList);
            }
            catch (Exception exception) {
                throw new ExceptionInInitializerError(exception);
            }
        }

        public void error(String string) {
            LOGGER.error(string);
        }

        public void error(Exception exception) {
            LOGGER.error("Exception", (Throwable)exception);
        }

        public CMenuBar createMenuBar() {
            List<BaseLayoutController.BaseMenuNode<DataMask>> list = this.mf_oLayouts.get(CommandController.MAINMENU_LAYOUT_ID);
            if (list == null) {
                throw new ExceptionInInitializerError("Konnte das Main-Men\u00fc nicht finden.");
            }
            return (CMenuBar)this.createMenuBar(list, FredMenuCompFactory.FACTORY_INSTANCE);
        }

        public CContextMenu createContextMenu(String string) {
            List<BaseLayoutController.BaseMenuNode<DataMask>> list = this.mf_oLayouts.get(string);
            if (list == null) {
                throw new ExceptionInInitializerError("The context menu \"" + string + "\" could not be loaded!");
            }
            return (CContextMenu)this.createContextMenu(list, FredMenuCompFactory.FACTORY_INSTANCE);
        }

        public List<BaseLayoutController.BaseMenuNode<DataMask>> getToolbarItems() {
            return this.mf_oLayouts.get(CommandController.MAINTOOLBAR_LAYOUT_ID);
        }

        public boolean isWorkfileOpened(DataMask dataMask) {
            return dataMask.isFileOpened;
        }

        private static class FredMenuCompFactory
        extends MenuCompFactory<DataMask> {
            public static final FredMenuCompFactory FACTORY_INSTANCE = new FredMenuCompFactory();

            private FredMenuCompFactory() {
            }

            public CMenuBar createMenuBar() {
                return new CMenuBar();
            }

            public IXMLContextMenu<DataMask> createContextMenu() {
                return new CContextMenu();
            }
        }
    }

    public static class InnerCommandController
    extends BaseCommandController<DataMask> {
        private static final InnerCommandController INSTANCE = new InnerCommandController();
        final List<Command<DataMask>> mf_oCommandList;

        private InnerCommandController() {
            super(DataMask.class, CommandController.INVOKE_PREFIX, CommandController.TOGGLE_STATE_PREFIX);
            try {
                this.mf_oCommandList = this.loadCommands(MainController.getResLoader().getResourceStreamExcpt(CommandController.COMMANDS_FILE));
            }
            catch (Exception exception) {
                throw new ExceptionInInitializerError(exception);
            }
        }

        public void handleInvokationException(Exception exception) {
            LOGGER.error("InvocationException", (Throwable)exception);
        }

        public void error(String string) {
            LOGGER.error(string);
        }

        public void error(Exception exception) {
            LOGGER.error("Exception", (Throwable)exception);
        }

        public void invokeFileCreateWorkfile() {
            MainController.incomingFileCreateWorkfile();
        }

        public void invokeFileOpenWorkfile() {
            MainController.incomingFileOpenWorkfile();
        }

        public void invokeFileClose() {
            MainController.incomingFileClose();
        }

        public void invokeFileSaveWorkfile() {
            MainController.incomingFileSaveWorkfile();
        }

        public void invokeFileSaveWorkfileAs() {
            MainController.incomingFileSaveWorkfileAs();
        }

        public void invokeFileShowProperties() {
            MainController.incomingFileShowProperties();
        }

        public void invokeFileExit() {
            TrayIconController.incomingExit();
        }

        public void invokeViewQuickbar() {
            MainController.incomingViewQuickbar();
        }

        public void invokeViewNewView() {
            MainController.incomingViewNewView();
        }

        public void invokeViewDuplicateView() {
            MainController.incomingViewDuplicateView();
        }

        public void invokeViewCloseView() {
            MainController.incomingViewCloseView();
        }

        public void invokeViewCustomizeColumns() {
            MainController.incomingViewCustomizeColumns();
        }

        public void invokeViewQuickbarLeft() {
            MainController.incomingViewQuickbarLeft();
        }

        public void invokeViewQuickbarTop() {
            MainController.incomingViewQuickbarTop();
        }

        public void invokeViewQuickbarRight() {
            MainController.incomingViewQuickbarRight();
        }

        public void invokeViewQuickbarBottom() {
            MainController.incomingViewQuickbarBottom();
        }

        public void invokeProjectCreate() {
            MainController.incomingProjectCreate();
        }

        public void invokeProjectClose() {
            MainController.incomingProjectClose();
        }

        public void invokeProjectDeleteProject() {
            MainController.incomingProjectDeleteProject();
        }

        public void invokeProjectSubscribeProject() {
            MainController.incomingProjectSubscribeProject();
        }

        public void invokeProjectBroadcastProject() {
            MainController.incomingProjectBroadcastProject();
        }

        public void invokeProjectProperties() {
            MainController.incomingProjectProperties();
        }

        public void invokeTaskCreateTask() {
            MainController.incomingTaskCreateTask();
        }

        public void invokeTaskDefaultTask() {
            MainController.incomingTaskDefaultTask();
        }

        public void invokeTaskDeleteTask() {
            MainController.incomingTaskDeleteTask();
        }

        public void invokeTaskSubscribeTask() {
            MainController.incomingTaskSubscribeTask();
        }

        public void invokeTaskBroadcastTask() {
            MainController.incomingTaskBroadcastTask();
        }

        public void invokeTaskProperties() {
            MainController.incomingTaskProperties();
        }

        public void invokeEffortCreateEffort() {
            MainController.incomingEffortCreateEffort();
        }

        public void invokeEffortEditEffort() {
            MainController.incomingEffortEditEffort();
        }

        public void invokeEffortDeleteEfforts() {
            MainController.incomingEffortDeleteEfforts();
        }

        public void invokeEffortShowCollisions() {
            MainController.incomingEffortShowCollidators();
        }

        public void invokeEffortExportEfforts() {
            MainController.incomingEffortExportEfforts();
        }

        public void invokeEffortAcceptEfforts() {
            MainController.incomingEffortAcceptEfforts();
        }

        public void invokeEffortRejectEfforts() {
            MainController.incomingEffortDiscardEfforts();
        }

        public void invokeEffortReplicateEfforts() {
            MainController.incomingEffortReplicateEfforts();
        }

        public void invokeEffortCollectEfforts() {
            MainController.incomingEffortCollectEfforts();
        }

        public void invokeEffortSetTaskForAll() {
            MainController.incomingEffortSetTaskForAll();
        }

        public void invokeEffortSetCategoryForAll() {
            MainController.incomingEffortSetCategoryForAll();
        }

        public void invokeExtrasLanguageEnglish() {
            MainController.incomingExtrasLanguageEnglish();
        }

        public void invokeExtrasLanguageGerman() {
            MainController.incomingExtrasLanguageGerman();
        }

        public void invokeExtrasLanguageFrench() {
            MainController.incomingExtrasLanguageFrench();
        }

        public void invokeExtrasOptions() {
            MainController.incomingExtrasOptions();
        }

        public void invokeExtrasGlobalSettings() {
            MainController.incomingExtrasGlobalSettings();
        }

        public void invokeHelpShowHelp() {
            MainController.incomingHelpShowHelp();
        }

        public void invokeHelpQuickstart() {
            MainController.incomingHelpQuickstart();
        }

        public void invokeHelpBugReporting() {
            MainController.incomingHelpBugReporting();
        }

        public void invokeHelpShowAbout() {
            MainController.incomingHelpShowAbout();
        }

        public void invokeToggleVisibility() {
            TrayIconController.incomingToggleVisibility();
        }

        public void invokeTrayIconCopyright() {
        }

        public boolean enableFileSaveWorkfile(DataMask dataMask) {
            return dataMask.isFileOpened && dataMask.madeChanges;
        }

        public boolean getStateViewQuickbar() {
            return QuickBar.getInstance().isVisible();
        }

        public boolean enableProjectClose(DataMask dataMask) {
            return dataMask.isProjectSelected && dataMask.isUserProjectLeader && !dataMask.isProjectClosed;
        }

        public boolean enableProjectBroadcast(DataMask dataMask) {
            return dataMask.isOpenLocalProjectAvailable;
        }

        public boolean isProjectSelected(DataMask dataMask) {
            return dataMask.isProjectSelected;
        }

        public boolean enableTaskBroadcastTask(DataMask dataMask) {
            return dataMask.isOpenTeamProjectAvailable;
        }

        public boolean isTaskSelected(DataMask dataMask) {
            return dataMask.isTaskSelected;
        }

        public boolean enableEffortEditEffort(DataMask dataMask) {
            return dataMask.isEffortSelected && !dataMask.areMultipleEffortsSelected;
        }

        public boolean enableEffortShowCollisions(DataMask dataMask) {
            return dataMask.isCollidingEffortSelected;
        }

        public boolean isEffortSelected(DataMask dataMask) {
            return dataMask.isEffortSelected;
        }

        public boolean enableEffortCollectEfforts(DataMask dataMask) {
            return dataMask.isOpenTeamTaskAvailable;
        }

        public boolean isWorkfileOpened(DataMask dataMask) {
            return dataMask.isFileOpened;
        }

        public boolean isViewOpened(DataMask dataMask) {
            return dataMask.isFileOpened && dataMask.isViewOpened;
        }
    }
}

