/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.model;

import com.mayastudios.fred.client.filehandling.objectcontainer.AXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.xml.CSimpleXMLStream;
import com.mayastudios.fred.client.filehandling.xml.IXMLizable;
import com.mayastudios.fred.client.model.CColumn;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.resources.WorkFileSettings;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.xml.sax.Attributes;

public class CColumnModel
extends DefaultTableColumnModel
implements IXMLizable,
Cloneable {
    public static final String XML_TAG_NAME = "columns";
    private static final EColumnType[] DEFAULT_COLUMNS = new EColumnType[]{EColumnType.StartDate, EColumnType.StartEndTime, EColumnType.WorkDuration, EColumnType.PauseDuration, EColumnType.Project, EColumnType.TaskShort, EColumnType.CategoryName, EColumnType.PersonShortname, EColumnType.Description, EColumnType.Collisions, EColumnType.Replicated, EColumnType.Accepted};
    private static final EColumnType[] DEFAULT_COLUMNS_SECONDROW = new EColumnType[]{EColumnType.StartDate, EColumnType.StartEndTime, EColumnType.WorkDuration, EColumnType.PauseDuration, EColumnType.Project, EColumnType.Task, EColumnType.CategoryName, EColumnType.Collisions, EColumnType.Replicated, EColumnType.Accepted};
    private static EColumnType[] s_aeColumnTypeArray = EColumnType.values();
    private EnumSet<EColumnType> m_oVisibleColumns = EnumSet.noneOf(EColumnType.class);

    public void addColumn(CColumn cColumn) {
        super.addColumn(cColumn);
        this.m_oVisibleColumns.add(cColumn.getColumnType());
    }

    public void addColumn(EColumnType eColumnType) {
        this.addColumnAtIndex(eColumnType, super.getColumnCount());
    }

    public void addColumnAtIndex(EColumnType eColumnType, int n) {
        if (!this.m_oVisibleColumns.contains((Object)eColumnType)) {
            CColumn cColumn = new CColumn(eColumnType);
            super.addColumn(cColumn);
            super.moveColumn(super.getColumnCount() - 1, n);
            this.m_oVisibleColumns.add(eColumnType);
        } else {
            int n2 = super.getColumnIndex((Object)eColumnType);
            if (n2 != n) {
                super.moveColumn(n2, n);
            }
        }
    }

    public void removeColumn(EColumnType eColumnType) {
        if (this.m_oVisibleColumns.contains((Object)eColumnType)) {
            CColumn cColumn = new CColumn(eColumnType);
            super.removeColumn(cColumn);
            this.m_oVisibleColumns.remove((Object)eColumnType);
        }
    }

    public Vector<EColumnType> getVisibleColumTypes() {
        int n = super.getColumnCount();
        Vector<EColumnType> vector = new Vector<EColumnType>(n);
        for (int i = 0; i < n; ++i) {
            CColumn cColumn = (CColumn)super.getColumn(i);
            vector.add(cColumn.getColumnType());
        }
        return vector;
    }

    public Vector<CColumn> getColums() {
        int n = super.getColumnCount();
        Vector<CColumn> vector = new Vector<CColumn>(n);
        for (int i = 0; i < n; ++i) {
            vector.add((CColumn)super.getColumn(i));
        }
        return vector;
    }

    public Vector<CColumn> getUnusedColumnTypes() {
        EnumSet<EColumnType> enumSet = EnumSet.complementOf(this.m_oVisibleColumns);
        int n = enumSet.size();
        Vector<CColumn> vector = new Vector<CColumn>(n);
        Iterator iterator = enumSet.iterator();
        while (iterator.hasNext()) {
            vector.add(new CColumn((EColumnType)((Object)iterator.next())));
        }
        return vector;
    }

    public void setColums(Vector<EColumnType> vector) {
        Vector<EColumnType> vector2 = this.getVisibleColumTypes();
        vector2.removeAll(vector);
        Iterator<EColumnType> iterator = vector2.iterator();
        while (iterator.hasNext()) {
            this.removeColumn(iterator.next());
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.addColumnAtIndex(vector.get(i), i);
        }
    }

    public CColumnModel clone() {
        CColumnModel cColumnModel = new CColumnModel();
        Enumeration<TableColumn> enumeration = super.getColumns();
        while (enumeration.hasMoreElements()) {
            CColumn cColumn = (CColumn)enumeration.nextElement();
            cColumnModel.addColumn(cColumn.clone());
        }
        return cColumnModel;
    }

    @Override
    public void xmlize(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
        cSimpleXMLStream.startElement(XML_TAG_NAME);
        Enumeration<TableColumn> enumeration = super.getColumns();
        while (enumeration.hasMoreElements()) {
            CColumn cColumn = (CColumn)enumeration.nextElement();
            cColumn.xmlize(cSimpleXMLStream);
        }
        cSimpleXMLStream.endElement(XML_TAG_NAME);
    }

    public static CColumnModel createDefaultColumns() {
        EColumnType[] eColumnTypeArray;
        CColumnModel cColumnModel = new CColumnModel();
        for (EColumnType eColumnType : eColumnTypeArray = !WorkFileSettings.getAsBoolean(WorkFileSettings.EConf.ShowSecondRowPerDefault) ? DEFAULT_COLUMNS : DEFAULT_COLUMNS_SECONDROW) {
            cColumnModel.addColumn(eColumnType);
        }
        return cColumnModel;
    }

    public static EColumnType getColumnTypeByIndex(int n) {
        return s_aeColumnTypeArray[n];
    }

    public static class CColumnModelStoreContainer
    extends AXMLObjectContainer<CColumnModel> {
        private static final CColumn.CColumnContainer COLUMN_CONTAINER = new CColumn.CColumnContainer();

        @Override
        protected CColumnModel createContainedObject(Attributes attributes, int n) {
            return new CColumnModel();
        }

        @Override
        protected AXMLObjectContainer<?> newChildContainer(String string, int n) {
            if (string.equals("column")) {
                return COLUMN_CONTAINER;
            }
            return null;
        }

        @Override
        protected void childContainerCompleted(String string, Object object, int n) {
            if (string.equals("column")) {
                ((CColumnModel)this.m_oObject).addColumn((CColumn)object);
            }
        }
    }

    public static enum EColumnType {
        StartDate(60),
        StartTime(65),
        EndDate(65),
        EndTime(60),
        StartEndTime(80),
        StartDayOfWeek(30),
        OverallDuration(67),
        WorkDuration(60),
        PauseDuration(60),
        Project(130),
        Task(100),
        TaskShort(50),
        CategoryName(80),
        CategoryID(33),
        PersonFullName(150),
        PersonShortname(35),
        PersonID(180),
        Description(200),
        Approved(60),
        Collisions(65),
        IgnoreCollisions(100),
        Replicated(60),
        Accepted(100);

        private final String mf_strName;
        private final String mf_strTooltip;
        private final int m_iDefaultColumnWidth;

        private EColumnType(int n2) {
            this.m_iDefaultColumnWidth = n2;
            this.mf_strName = Labels.get(String.format("ECOLUMNS_%s", this.name()), new Object[0]);
            String string2 = Labels.get(String.format("ECOLUMNS_%s_Tooltip", this.name()), new Object[0]);
            this.mf_strTooltip = string2.length() == 0 ? this.mf_strName : String.format("[%s] %s", this.mf_strName, string2);
        }

        public int getDefaultColumnWidth() {
            return this.m_iDefaultColumnWidth;
        }

        public String getDescription() {
            return this.mf_strName;
        }

        public String getTooltipText() {
            return this.mf_strTooltip;
        }

        public String toString() {
            return this.getDescription();
        }
    }
}

