/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.model;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.exceptions.CDuplicateTaskNameException;
import com.mayastudios.fred.client.exceptions.CDuplicateTaskShortNameException;
import com.mayastudios.fred.client.exceptions.CFredRuntimeException;
import com.mayastudios.fred.client.filehandling.objectcontainer.AXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.xml.CSimpleXMLStream;
import com.mayastudios.fred.client.filehandling.xml.IXMLizable;
import com.mayastudios.fred.client.model.AReplicateableObjectImpl;
import com.mayastudios.fred.client.model.CEffortImpl;
import com.mayastudios.fred.client.model.CPersonImpl;
import com.mayastudios.fred.client.model.CStatistic;
import com.mayastudios.fred.client.model.CTaskImpl;
import com.mayastudios.fred.client.model.DefaultTask;
import com.mayastudios.fred.client.model.ObjectFactoryImpl;
import com.mayastudios.fred.client.model.ProjectList;
import com.mayastudios.fred.client.resources.DateTime;
import com.mayastudios.fred.client.resources.ID;
import com.mayastudios.fred.client.resources.StringFunctions;
import de.sopra06.domainmodel.Project;
import de.sopra06.domainmodel.Task;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class CProjectImpl
extends AReplicateableObjectImpl
implements IXMLizable,
Project,
Comparable<CProjectImpl>,
Iterable<CTaskImpl> {
    public static final char ID_PREFIX = 'P';
    public static final String XML_TAG_NAME = "project";
    private static final String XML_ATT_ID = "id";
    private static final String XML_ATT_NAME = "name";
    private static final String XML_ATT_DESCRIPTION = "description";
    private static final String XML_ATT_IS_CLOSED = "isclosed";
    private static final String XML_ATT_IS_TEAMPROJECT = "isteamproject";
    private static final String XML_ATT_URL = "urlexternal";
    private static final String XML_ATT_CREATED_AT = "createdat";
    private static final String XML_ATT_COLLECTED_LAST_AT = "collectedlastat";
    private static final String XML_ATT_SUBSCRIBED_AT = "subscribedat";
    private static final String XML_ATT_CLOSED_AT = "closedat";
    private static final String XML_ATT_SECURITYID = "securityid";
    private static final Logger LOGGER = LoggerFactory.getLogger(CProjectImpl.class);
    private String m_strName = null;
    private String m_strDescription = null;
    private boolean m_bClosed = false;
    private boolean m_bTeamProject = false;
    private URL m_oServerURL = null;
    private String m_strSecurityID = null;
    private Calendar m_oCreatedAt = null;
    private Calendar m_oCollectedLastAt = null;
    private Calendar m_oSubscribedAt = null;
    private Calendar m_oClosedAt = null;
    private CStatistic m_oStatistic = null;
    private Vector<CTaskImpl> m_oTaskVector = null;
    private boolean m_bCheckForNameChanges;

    CProjectImpl(String string) {
        super.setID(string);
        this.m_oTaskVector = new Vector(10, 10);
        this.m_oStatistic = new CStatistic(null);
    }

    public static CProjectImpl create() {
        CProjectImpl cProjectImpl = ObjectFactoryImpl.createProjectImpl(ID.createNewID('P'));
        cProjectImpl.setCreatedNow();
        CPersonImpl cPersonImpl = MainController.getInstance().getUser();
        cProjectImpl.setSecurityID(cPersonImpl.getSecurityID());
        return cProjectImpl;
    }

    public String getName() {
        return StringFunctions.readNullString(this.m_strName);
    }

    public void setName(String string) {
        if (!this.m_bCheckForNameChanges || ProjectList.getInstance().isProjectNameValid(this, string)) {
            String string2 = StringFunctions.isNameValid(string);
            if (string2 == null) {
                this.m_strName = StringFunctions.storeNullString(string);
            } else {
                LOGGER.error("{}#setName: \"" + string + "\" not okay: {}", (Object)this.getClass().getName(), (Object)string2);
            }
        } else if (this.m_bCheckForNameChanges) {
            LOGGER.error("{}#setName: Project \"{}\" already exists", (Object)this.getClass().getName(), (Object)string);
        }
    }

    public String getDescription() {
        return StringFunctions.readNullString(this.m_strDescription);
    }

    public void setDescription(String string) {
        this.m_strDescription = StringFunctions.storeNullString(string);
    }

    public boolean isClosed() {
        return this.m_bClosed;
    }

    public void close() {
        this.m_bClosed = true;
        this.m_oClosedAt = Calendar.getInstance();
    }

    public void setClosed(boolean bl) {
        this.m_bClosed = bl;
    }

    public boolean isTeamProject() {
        return this.m_bTeamProject;
    }

    public void setTeamproject(boolean bl) {
        this.m_bTeamProject = bl;
    }

    public URL getServerURL() {
        return this.m_oServerURL;
    }

    public void setServerURL(URL uRL) {
        this.m_oServerURL = uRL;
        MainController.getInstance().getURLList().add(uRL);
    }

    public String getSecurityID() {
        return StringFunctions.readNullString(this.m_strSecurityID);
    }

    public void setSecurityID(String string) {
        this.m_strSecurityID = StringFunctions.storeNullString(string);
    }

    public Calendar getCreatedAt() {
        return this.m_oCreatedAt;
    }

    public void setCreatedNow() {
        this.m_oCreatedAt = Calendar.getInstance();
    }

    public Calendar getCollectedLastAt() {
        return this.m_oCollectedLastAt;
    }

    public void resetCollectedLastAt() {
        this.m_oCollectedLastAt = Calendar.getInstance();
    }

    public Calendar getSubscribedAt() {
        return this.m_oSubscribedAt;
    }

    public void setSubscribedNow() {
        this.m_oSubscribedAt = Calendar.getInstance();
    }

    public Calendar getClosedAt() {
        return this.m_oClosedAt;
    }

    public boolean isUserProjectLeader() {
        CPersonImpl cPersonImpl = MainController.getInstance().getUser();
        return this.getSecurityID().length() > 0 && cPersonImpl.getSecurityID().equals(this.getSecurityID());
    }

    public boolean isSubscibed() {
        return this.isTeamProject() && !this.isUserProjectLeader();
    }

    public boolean isBroadcasted() {
        return this.isTeamProject() && this.isUserProjectLeader();
    }

    public int getTaskCount() {
        return this.m_oTaskVector.size();
    }

    public Iterator<CTaskImpl> getTaskIterator() {
        ArrayList<CTaskImpl> arrayList = new ArrayList<CTaskImpl>(this.m_oTaskVector.size());
        arrayList.addAll(this.m_oTaskVector);
        Collections.sort(arrayList);
        return arrayList.iterator();
    }

    @Override
    public Iterator<CTaskImpl> iterator() {
        return this.getTaskIterator();
    }

    public boolean containsTask(CTaskImpl cTaskImpl) {
        return this.m_oTaskVector.contains(cTaskImpl);
    }

    public boolean containsDefaultTask() {
        return DefaultTask.getProject() == this;
    }

    public void deleteContained(Vector<CTaskImpl> vector) {
        vector.removeAll(this.m_oTaskVector);
    }

    public void setCheckForNameChanges(boolean bl) {
        this.m_bCheckForNameChanges = bl;
    }

    public void addTask(Task task) {
        try {
            this.addTask((CTaskImpl)task, false);
        }
        catch (CDuplicateTaskNameException cDuplicateTaskNameException) {
            throw new CFredRuntimeException(cDuplicateTaskNameException.getMessage());
        }
    }

    public void addTask(CTaskImpl cTaskImpl, boolean bl) throws CDuplicateTaskNameException, CDuplicateTaskShortNameException {
        if (this.isTaskNameValid(cTaskImpl, cTaskImpl.getName()) && this.isTaskShortNameValid(cTaskImpl, cTaskImpl.getShortName()) && this.m_oTaskVector.indexOf(cTaskImpl) == -1) {
            this.m_oTaskVector.add(cTaskImpl);
            cTaskImpl.setProject(this);
            cTaskImpl.getStatistic().setParentStatistic(this.m_oStatistic);
            cTaskImpl.setCheckForNameChanges(true);
            if (bl) {
                this.m_oStatistic.addStatistic(cTaskImpl.getStatistic());
            }
        } else {
            if (!this.isTaskNameValid(cTaskImpl, cTaskImpl.getName())) {
                throw new CDuplicateTaskNameException("TaskName \"" + cTaskImpl.getName() + "\" already used in this Projekt");
            }
            if (!this.isTaskShortNameValid(cTaskImpl, cTaskImpl.getShortName())) {
                throw new CDuplicateTaskShortNameException("TaskShortName \"" + cTaskImpl.getShortName() + "\" already used in this Projekt");
            }
        }
    }

    public void removeTask(Task task) {
        CTaskImpl cTaskImpl = (CTaskImpl)task;
        this.m_oTaskVector.remove(cTaskImpl);
        this.m_oStatistic.subtractStatistic(cTaskImpl.getStatistic());
        cTaskImpl.getStatistic().setParentStatistic(null);
        cTaskImpl.setCheckForNameChanges(false);
    }

    public Vector<CProjectImpl> toVector() {
        Vector<CProjectImpl> vector = new Vector<CProjectImpl>(1);
        vector.add(this);
        return vector;
    }

    public boolean isTaskNameValid(CTaskImpl cTaskImpl, String string) {
        for (CTaskImpl cTaskImpl2 : this.m_oTaskVector) {
            if (!cTaskImpl2.getName().equals(string)) continue;
            return cTaskImpl2 == cTaskImpl;
        }
        return true;
    }

    public boolean isTaskShortNameValid(CTaskImpl cTaskImpl, String string) {
        for (CTaskImpl cTaskImpl2 : this.m_oTaskVector) {
            if (!cTaskImpl2.getShortName().equals(string)) continue;
            return cTaskImpl2 == cTaskImpl;
        }
        return true;
    }

    public CStatistic getStatistic() {
        return this.m_oStatistic;
    }

    public DefaultComboBoxModel getTaskComboBoxModel() {
        DefaultComboBoxModel<CTaskImpl> defaultComboBoxModel = new DefaultComboBoxModel<CTaskImpl>();
        Iterator<CTaskImpl> iterator = this.getTaskIterator();
        while (iterator.hasNext()) {
            defaultComboBoxModel.addElement(iterator.next());
        }
        return defaultComboBoxModel;
    }

    public void discoverSemanticConflicts(CEffortImpl cEffortImpl) {
        Iterator<CTaskImpl> iterator = this.getTaskIterator();
        while (iterator.hasNext()) {
            iterator.next().discoverSemanticConflicts(cEffortImpl);
        }
    }

    public String toString() {
        if (this.containsDefaultTask()) {
            return this.getName() + " *";
        }
        return this.getName();
    }

    @Override
    public int compareTo(CProjectImpl cProjectImpl) {
        int n = this.getName().compareTo(cProjectImpl.getName());
        if (n == 0) {
            if (this.equals(cProjectImpl)) {
                return 0;
            }
            n = this.getID().compareTo(cProjectImpl.getID());
            if (n == 0) {
                LOGGER.error("{}#compareTo: getID() == p_oOtherProject.getID() && !equals(p_oOther)", (Object)this.getClass().getName());
            }
            return n;
        }
        return n;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public void xmlize(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
        cSimpleXMLStream.startElement(XML_TAG_NAME);
        cSimpleXMLStream.addAttribute(XML_ATT_ID, String.valueOf(this.getID()));
        cSimpleXMLStream.addAttribute(XML_ATT_NAME, this.getName());
        cSimpleXMLStream.addAttribute(XML_ATT_DESCRIPTION, this.getDescription());
        cSimpleXMLStream.addAttribute(XML_ATT_IS_CLOSED, String.valueOf(this.isClosed()));
        cSimpleXMLStream.addAttribute(XML_ATT_IS_TEAMPROJECT, String.valueOf(this.isTeamProject()));
        if (this.getServerURL() != null) {
            cSimpleXMLStream.addAttribute(XML_ATT_URL, this.getServerURL().toExternalForm());
        }
        if (this.getCreatedAt() != null) {
            cSimpleXMLStream.addAttribute(XML_ATT_CREATED_AT, DateTime.getXMLDateTime(this.getCreatedAt()));
        }
        if (this.getCollectedLastAt() != null) {
            cSimpleXMLStream.addAttribute(XML_ATT_COLLECTED_LAST_AT, DateTime.getXMLDateTime(this.getCollectedLastAt()));
        }
        if (this.getSubscribedAt() != null) {
            cSimpleXMLStream.addAttribute(XML_ATT_SUBSCRIBED_AT, DateTime.getXMLDateTime(this.getSubscribedAt()));
        }
        if (this.getClosedAt() != null) {
            cSimpleXMLStream.addAttribute(XML_ATT_CLOSED_AT, DateTime.getXMLDateTime(this.getClosedAt()));
        }
        cSimpleXMLStream.addAttribute(XML_ATT_SECURITYID, this.getSecurityID());
        this.m_oStatistic.xmlize(cSimpleXMLStream);
        Iterator<CTaskImpl> iterator = this.getTaskIterator();
        while (iterator.hasNext()) {
            iterator.next().xmlize(cSimpleXMLStream);
        }
        cSimpleXMLStream.endElement(XML_TAG_NAME);
    }

    public static class CProjectStoreContainer
    extends AXMLObjectContainer<CProjectImpl> {
        private static final CTaskImpl.CTaskStoreContainer TASK_CONTAINER = new CTaskImpl.CTaskStoreContainer();
        private static final CStatistic.CStatisticStoreContainer STATISTIC_CONTAINER = new CStatistic.CStatisticStoreContainer();

        @Override
        protected CProjectImpl createContainedObject(Attributes attributes, int n) {
            String string;
            String string2;
            String string3;
            String string4 = attributes.getValue(CProjectImpl.XML_ATT_ID);
            CProjectImpl cProjectImpl = ObjectFactoryImpl.createProjectImpl(string4);
            cProjectImpl.setName(attributes.getValue(CProjectImpl.XML_ATT_NAME));
            cProjectImpl.setDescription(attributes.getValue(CProjectImpl.XML_ATT_DESCRIPTION));
            cProjectImpl.setClosed(Boolean.parseBoolean(attributes.getValue(CProjectImpl.XML_ATT_IS_CLOSED)));
            cProjectImpl.setTeamproject(Boolean.parseBoolean(attributes.getValue(CProjectImpl.XML_ATT_IS_TEAMPROJECT)));
            String string5 = attributes.getValue(CProjectImpl.XML_ATT_URL);
            if (string5 != null) {
                try {
                    cProjectImpl.setServerURL(new URL(string5));
                }
                catch (MalformedURLException malformedURLException) {
                    throw new CFredRuntimeException("MalformedURLException: " + malformedURLException.getMessage());
                }
            }
            cProjectImpl.setSecurityID(attributes.getValue(CProjectImpl.XML_ATT_SECURITYID));
            String string6 = attributes.getValue(CProjectImpl.XML_ATT_CREATED_AT);
            if (string6 != null) {
                cProjectImpl.m_oCreatedAt = DateTime.parseXMLDateTime(string6);
            }
            if ((string3 = attributes.getValue(CProjectImpl.XML_ATT_COLLECTED_LAST_AT)) != null) {
                cProjectImpl.m_oCollectedLastAt = DateTime.parseXMLDateTime(string3);
            }
            if ((string2 = attributes.getValue(CProjectImpl.XML_ATT_SUBSCRIBED_AT)) != null) {
                cProjectImpl.m_oSubscribedAt = DateTime.parseXMLDateTime(string2);
            }
            if ((string = attributes.getValue(CProjectImpl.XML_ATT_CLOSED_AT)) != null) {
                cProjectImpl.m_oClosedAt = DateTime.parseXMLDateTime(string);
            }
            return cProjectImpl;
        }

        @Override
        protected AXMLObjectContainer<?> newChildContainer(String string, int n) {
            if (string.equals("statistic")) {
                return STATISTIC_CONTAINER;
            }
            if (string.equals("task")) {
                return TASK_CONTAINER;
            }
            return null;
        }

        @Override
        protected void childContainerCompleted(String string, Object object, int n) {
            if (string.equals("statistic")) {
                ((CProjectImpl)this.getContainedObject()).m_oStatistic = (CStatistic)object;
            } else if (string.equals("task")) {
                ((CProjectImpl)this.getContainedObject()).addTask((CTaskImpl)object, false);
            }
        }

        @Override
        protected void completeContainedObject(int n) {
            CProjectImpl cProjectImpl = (CProjectImpl)this.getContainedObject();
            int n2 = 0;
            for (Object object : cProjectImpl.m_oTaskVector) {
                n2 += ((CTaskImpl)object).getStatistic().getFieldValue(0);
            }
            if (cProjectImpl.getStatistic().getFieldValue(0) != n2) {
                CStatistic cStatistic = new CStatistic(null);
                for (CTaskImpl cTaskImpl : cProjectImpl.m_oTaskVector) {
                    cStatistic.addStatistic(cTaskImpl.getStatistic());
                    cTaskImpl.getStatistic().setParentStatistic(cStatistic);
                }
                cProjectImpl.m_oStatistic = cStatistic;
            }
        }
    }
}

