/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.util.avltree;

import com.mayastudios.fred.client.util.avltree.AVLNode;
import com.mayastudios.fred.client.util.avltree.AVLTree;
import java.util.Iterator;

class NodeIteratorUp<E extends Comparable<? super E>>
implements Iterator<E> {
    private AVLTree<E> m_AVLTree = null;
    private AVLNode<E> m_NodeLastVisited = null;
    private AVLNode<E> m_NodeNext = null;
    private E m_ElementRightBoundary = null;

    public NodeIteratorUp(AVLTree<E> aVLTree, AVLNode<E> aVLNode, E e) {
        this.m_AVLTree = aVLTree;
        this.m_ElementRightBoundary = e;
        if (aVLNode != null && aVLNode.compareTo(this.m_ElementRightBoundary) <= 0) {
            this.m_NodeNext = aVLNode;
        }
    }

    @Override
    public boolean hasNext() {
        return this.m_NodeNext != null;
    }

    @Override
    public E next() {
        this.m_NodeLastVisited = this.m_NodeNext;
        this.m_NodeNext = this.m_AVLTree.getSuccessor(this.m_NodeNext);
        if (this.m_NodeNext != null && this.m_NodeNext.compareTo(this.m_ElementRightBoundary) > 0) {
            this.m_NodeNext = null;
        }
        return this.m_NodeLastVisited.m_Element;
    }

    @Override
    public void remove() {
        if (this.m_NodeLastVisited != null) {
            this.m_AVLTree.remove(this.m_NodeLastVisited);
            this.m_NodeLastVisited = null;
        }
    }
}

