/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view;

import com.mayastudios.fred.client.resources.DateTime;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CCalendarChooser
extends JDialog {
    private static final int MONTH_SELECTOR_HEIGHT = 20;
    private static final int BUTTON_OFFSET = 4;
    private static final int PANEL_BORDER_WEST = 2;
    private static final int PANEL_BORDER_NORTH = 3;
    private static final int PANEL_BORDER_EAST = 8;
    private static final int PANEL_BORDER_SOUTH = 28;
    private static final int LABEL_INSETS = 5;
    Calendar m_oSelectedDate = null;
    private CCalendarChooserPanel m_oCPanel;
    private JLabel m_oMonthName;
    private Calendar m_oStartDate;
    private Calendar m_oMonthStartDate;

    public static Calendar chooseDate(JDialog jDialog, int n, int n2) {
        CCalendarChooser cCalendarChooser = new CCalendarChooser(jDialog, n, n2, Calendar.getInstance());
        cCalendarChooser.dispose();
        return cCalendarChooser.getSelectedDate();
    }

    public static Calendar chooseDate(JDialog jDialog, int n, int n2, Calendar calendar) {
        CCalendarChooser cCalendarChooser = new CCalendarChooser(jDialog, n, n2, calendar);
        cCalendarChooser.dispose();
        return cCalendarChooser.getSelectedDate();
    }

    private CCalendarChooser(JDialog jDialog, int n, int n2, Calendar calendar) {
        super(jDialog, "Kalender", true);
        super.setResizable(false);
        this.m_oStartDate = calendar;
        this.m_oMonthStartDate = (Calendar)calendar.clone();
        this.m_oMonthStartDate.set(5, 1);
        Container container = super.getContentPane();
        container.setLayout(null);
        this.m_oCPanel = new CCalendarChooserPanel(this.m_oStartDate, this.m_oMonthStartDate);
        int n3 = this.m_oCPanel.getPreferredSize().width;
        int n4 = this.m_oCPanel.getPreferredSize().height;
        this.m_oCPanel.setBounds(2, 23, n3, n4);
        container.add(this.m_oCPanel);
        CTriangleButton cTriangleButton = new CTriangleButton(false);
        CTriangleButton cTriangleButton2 = new CTriangleButton(true);
        int n5 = cTriangleButton.getPreferredSize().width;
        int n6 = cTriangleButton.getPreferredSize().height;
        cTriangleButton.setBounds(2, (20 - n6) / 2, n5, n6);
        container.add(cTriangleButton);
        cTriangleButton2.setBounds(2 + n3 - n5 - 4, (20 - n6) / 2, n5, n6);
        container.add(cTriangleButton2);
        this.m_oMonthName = new JLabel();
        this.m_oMonthName.setHorizontalAlignment(0);
        this.m_oMonthName.setText(DateTime.getMonthYearString(this.m_oMonthStartDate));
        int n7 = cTriangleButton2.getX() - cTriangleButton.getX() - 10;
        int n8 = this.m_oMonthName.getPreferredSize().height;
        this.m_oMonthName.setBounds(cTriangleButton.getX() + 5, (20 - n8) / 2, n7, n8);
        container.add(this.m_oMonthName);
        super.setBounds(n, n2, 2 + n3 + 8, 23 + n4 + 28);
        super.setVisible(true);
    }

    private Calendar getSelectedDate() {
        return this.m_oSelectedDate;
    }

    void newMonth(boolean bl) {
        if (bl) {
            this.m_oMonthStartDate.add(2, 1);
        } else {
            this.m_oMonthStartDate.add(2, -1);
        }
        Container container = super.getContentPane();
        container.remove(this.m_oCPanel);
        this.m_oCPanel = new CCalendarChooserPanel(this.m_oStartDate, (Calendar)this.m_oMonthStartDate.clone());
        int n = this.m_oCPanel.getPreferredSize().width;
        int n2 = this.m_oCPanel.getPreferredSize().height;
        this.m_oCPanel.setBounds(2, 23, n, n2);
        container.add(this.m_oCPanel);
        this.m_oMonthName.setText(DateTime.getMonthYearString(this.m_oMonthStartDate));
        super.setBounds(super.getX(), super.getY(), 2 + n + 8, 23 + n2 + 28);
        this.repaint();
    }

    private class CTriangleButton
    extends JPanel {
        boolean bTrianglePointsRight;
        private static final int DEFAULT_WIDTH = 13;
        private static final int DEFAULT_HEIGHT = 13;
        private final Color colorTriangle = Color.DARK_GRAY;

        public CTriangleButton(boolean bl) {
            this.bTrianglePointsRight = bl;
            this.addMouseListener(new CMouseAdapter());
            super.setPreferredSize(new Dimension(13, 13));
        }

        @Override
        public void paint(Graphics graphics) {
            int n = 6;
            int n2 = 6;
            if (this.bTrianglePointsRight) {
                graphics.setColor(this.colorTriangle);
                int[] nArray = new int[3];
                int[] nArray2 = new int[3];
                nArray[0] = 1;
                nArray2[0] = n2 - n;
                nArray[1] = 1;
                nArray2[1] = n2 + n;
                nArray[2] = 12;
                nArray2[2] = n2;
                graphics.fillPolygon(nArray, nArray2, 3);
            } else {
                graphics.setColor(this.colorTriangle);
                int[] nArray = new int[3];
                int[] nArray3 = new int[3];
                nArray[0] = 1;
                nArray3[0] = n2;
                nArray[1] = 12;
                nArray3[1] = n2 - n;
                nArray[2] = 12;
                nArray3[2] = n2 + n;
                graphics.fillPolygon(nArray, nArray3, 3);
            }
        }

        class CMouseAdapter
        extends MouseAdapter {
            CMouseAdapter() {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                CCalendarChooser.this.newMonth(CTriangleButton.this.bTrianglePointsRight);
            }
        }
    }

    private class CDateField
    extends JPanel {
        Calendar m_oThisDate;
        private String m_strContent;
        private double m_dElementWidth;
        private double m_dElementHeight;
        private int m_iRadius;
        boolean m_bIsHovered = false;
        private boolean m_bIsToday;
        private boolean m_bInThisMonth;
        private final double[] m_adColorsCenterHovered = new double[]{100.0, 100.0, 255.0};
        private final double[] m_adColorsEdgeHovered = new double[]{80.0, 80.0, 150.0};
        private final double[] m_adColorsCenterStart = new double[]{100.0, 255.0, 100.0};
        private final double[] m_adColorsEdgeStart = new double[]{80.0, 150.0, 80.0};
        private final double[] m_adColorsCenterToday = new double[]{255.0, 100.0, 100.0};
        private final double[] m_adColorsEdgeToday = new double[]{150.0, 80.0, 80.0};
        private final Color m_oColorInThisMonth = new Color(180, 180, 255);
        private final Color m_oColorNotThisMonth = new Color(200, 200, 200);
        private Color m_oColorText = Color.BLACK;
        private boolean m_bHighlightDay;

        public CDateField(Calendar calendar, Calendar calendar2, Calendar calendar3, int n, int n2) {
            this.m_oThisDate = calendar3;
            this.m_strContent = Integer.toString(this.m_oThisDate.get(5));
            this.m_dElementWidth = n;
            this.m_dElementHeight = n2;
            this.m_iRadius = (int)Math.max(this.m_dElementWidth, this.m_dElementHeight);
            super.setPreferredSize(new Dimension(n, n2));
            Calendar calendar4 = Calendar.getInstance();
            this.m_bHighlightDay = false;
            this.m_bIsToday = false;
            this.m_bInThisMonth = false;
            if (calendar.get(2) == calendar3.get(2) && calendar.get(1) == calendar3.get(1) && calendar.get(5) == calendar3.get(5)) {
                this.m_bHighlightDay = true;
            } else if (calendar4.get(2) == calendar3.get(2) && calendar4.get(1) == calendar3.get(1) && calendar4.get(5) == calendar3.get(5)) {
                this.m_bIsToday = true;
            } else if (calendar2.get(2) == calendar3.get(2) && calendar2.get(1) == calendar3.get(1)) {
                this.m_bInThisMonth = true;
            }
            this.addMouseListener(new CMouseAdapter());
            this.repaint();
        }

        @Override
        public void paint(Graphics graphics) {
            int n;
            int n2;
            int n3;
            int n4;
            if (this.m_bIsHovered) {
                for (n4 = this.m_iRadius; n4 > 0; --n4) {
                    n3 = (int)((this.m_adColorsEdgeHovered[0] - this.m_adColorsCenterHovered[0]) / (double)this.m_iRadius * (double)n4 + this.m_adColorsCenterHovered[0]);
                    n2 = (int)((this.m_adColorsEdgeHovered[1] - this.m_adColorsCenterHovered[1]) / (double)this.m_iRadius * (double)n4 + this.m_adColorsCenterHovered[1]);
                    n = (int)((this.m_adColorsEdgeHovered[2] - this.m_adColorsCenterHovered[2]) / (double)this.m_iRadius * (double)n4 + this.m_adColorsCenterHovered[2]);
                    Color color = new Color(n3, n2, n);
                    graphics.setColor(color);
                    int n5 = (int)(this.m_dElementHeight / (double)this.m_iRadius * (double)n4);
                    int n6 = (int)(this.m_dElementWidth / (double)this.m_iRadius * (double)n4);
                    int n7 = (int)((this.m_dElementWidth - (double)n6) / 2.0);
                    int n8 = (int)((this.m_dElementHeight - (double)n5) / 2.0);
                    graphics.fillRect(n7, n8, n6, n5);
                }
            } else if (this.m_bHighlightDay) {
                for (n4 = this.m_iRadius; n4 > 0; --n4) {
                    n3 = (int)((this.m_adColorsEdgeStart[0] - this.m_adColorsCenterStart[0]) / (double)this.m_iRadius * (double)n4 + this.m_adColorsCenterStart[0]);
                    n2 = (int)((this.m_adColorsEdgeStart[1] - this.m_adColorsCenterStart[1]) / (double)this.m_iRadius * (double)n4 + this.m_adColorsCenterStart[1]);
                    n = (int)((this.m_adColorsEdgeStart[2] - this.m_adColorsCenterStart[2]) / (double)this.m_iRadius * (double)n4 + this.m_adColorsCenterStart[2]);
                    Color color = new Color(n3, n2, n);
                    graphics.setColor(color);
                    int n9 = (int)(this.m_dElementHeight / (double)this.m_iRadius * (double)n4);
                    int n10 = (int)(this.m_dElementWidth / (double)this.m_iRadius * (double)n4);
                    int n11 = (int)((this.m_dElementWidth - (double)n10) / 2.0);
                    int n12 = (int)((this.m_dElementHeight - (double)n9) / 2.0);
                    graphics.fillRect(n11, n12, n10, n9);
                }
            } else if (this.m_bIsToday) {
                for (n4 = this.m_iRadius; n4 > 0; --n4) {
                    n3 = (int)((this.m_adColorsEdgeToday[0] - this.m_adColorsCenterToday[0]) / (double)this.m_iRadius * (double)n4 + this.m_adColorsCenterToday[0]);
                    n2 = (int)((this.m_adColorsEdgeToday[1] - this.m_adColorsCenterToday[1]) / (double)this.m_iRadius * (double)n4 + this.m_adColorsCenterToday[1]);
                    n = (int)((this.m_adColorsEdgeToday[2] - this.m_adColorsCenterToday[2]) / (double)this.m_iRadius * (double)n4 + this.m_adColorsCenterToday[2]);
                    Color color = new Color(n3, n2, n);
                    graphics.setColor(color);
                    int n13 = (int)(this.m_dElementHeight / (double)this.m_iRadius * (double)n4);
                    int n14 = (int)(this.m_dElementWidth / (double)this.m_iRadius * (double)n4);
                    int n15 = (int)((this.m_dElementWidth - (double)n14) / 2.0);
                    int n16 = (int)((this.m_dElementHeight - (double)n13) / 2.0);
                    graphics.fillRect(n15, n16, n14, n13);
                }
            } else if (this.m_bInThisMonth) {
                graphics.setColor(this.m_oColorInThisMonth);
                graphics.fillRect(0, 0, (int)this.m_dElementWidth, (int)this.m_dElementHeight);
            } else {
                graphics.setColor(this.m_oColorNotThisMonth);
                graphics.fillRect(0, 0, (int)this.m_dElementWidth, (int)this.m_dElementHeight);
            }
            n4 = graphics.getFontMetrics().stringWidth(this.m_strContent);
            n3 = (int)((this.m_dElementWidth - (double)n4) / 2.0);
            n2 = graphics.getFontMetrics().getHeight();
            n = (int)(this.m_dElementHeight - (this.m_dElementHeight - (double)n2) / 2.0) - 3;
            graphics.setColor(this.m_oColorText);
            graphics.drawString(this.m_strContent, n3, n);
        }

        class CMouseAdapter
        extends MouseAdapter {
            CMouseAdapter() {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                CDateField.this.m_bIsHovered = true;
                CDateField.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                CDateField.this.m_bIsHovered = false;
                CDateField.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                CCalendarChooser.this.m_oSelectedDate = CDateField.this.m_oThisDate;
                CCalendarChooser.this.setVisible(false);
            }
        }
    }

    private class CCalendarChooserPanel
    extends JPanel {
        private static final int DAY_OF_WEEK_INSET = 2;
        private static final int DATE_FIELD_WIDTH = 22;
        private static final int DATE_FIELD_HEIGHT = 20;
        private static final int DATE_FIELD_INSET = 1;
        private static final int PANEL_FIELDS_TOTAL_WIDTH = 24;
        private static final int PANEL_FIELDS_TOTAL_HEIGHT = 22;
        private Calendar m_oStartDateChild;
        private Calendar m_oMonthStartDateChild;
        private int m_iDayOfWeekHeight = 0;

        CCalendarChooserPanel(Calendar calendar, Calendar calendar2) {
            super.setLayout(null);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE");
            Calendar calendar3 = Calendar.getInstance();
            calendar3.set(7, calendar3.getFirstDayOfWeek());
            for (int i = 1; i <= 7; ++i) {
                JLabel jLabel = new JLabel();
                jLabel.setHorizontalAlignment(0);
                jLabel.setText(simpleDateFormat.format(calendar3.getTime()));
                this.m_iDayOfWeekHeight = Math.max(this.m_iDayOfWeekHeight, jLabel.getPreferredSize().height);
                jLabel.setBounds((i - 1) * 24 - 1, 0, 22, this.m_iDayOfWeekHeight);
                super.add(jLabel);
                calendar3.add(5, 1);
            }
            this.m_iDayOfWeekHeight += 2;
            this.m_oStartDateChild = calendar;
            this.m_oMonthStartDateChild = calendar2;
            this.m_oMonthStartDateChild.set(5, 1);
            Calendar calendar4 = (Calendar)this.m_oMonthStartDateChild.clone();
            calendar4.add(2, 1);
            calendar4.add(5, -1);
            calendar4.set(7, calendar4.getFirstDayOfWeek());
            calendar4.add(3, -5);
            int n = 0;
            for (int i = 1; i <= 6; ++i) {
                for (int j = 1; j <= 7; ++j) {
                    Calendar calendar5 = (Calendar)calendar4.clone();
                    CDateField cDateField = new CDateField(this.m_oStartDateChild, this.m_oMonthStartDateChild, calendar5, 22, 20);
                    cDateField.setBounds((j - 1) * 24 - 1, this.m_iDayOfWeekHeight + n * 22 - 1, 22, 20);
                    super.add(cDateField);
                    calendar4.add(5, 1);
                }
                ++n;
            }
            super.setPreferredSize(new Dimension(168, this.m_iDayOfWeekHeight + n * 22));
        }
    }
}

