/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view;

import com.mayastudios.fred.client.controller.CViewController;
import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.model.AFilter;
import com.mayastudios.fred.client.model.CProjectImpl;
import com.mayastudios.fred.client.model.CTaskImpl;
import com.mayastudios.fred.client.resources.CategoryList;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.ixml.labels.LString;
import com.mayastudios.mscl.ResourceLoader;
import com.mayastudios.mscl.mwt.tablelayout.CCellProps;
import com.mayastudios.mscl.mwt.tablelayout.CTableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CProjectTree
extends JPanel
implements ItemListener {
    public static final LString ROOT_NODE_NAME = Labels.getLS("TREE_ROOT_NAME");
    private static final LString[] TYPE_BOX_CONTENT = new LString[]{Labels.getLS("TASKS"), Labels.getLS("CATEGORIES")};
    private final CViewController m_oViewController;
    private final JComboBox m_oTypeComboBox;
    private final JTree m_oProjectTree;
    private ETreeType m_eTreeType;
    private final CProjectTreeRenderer m_oTreeRenderer;
    private final TreeModel m_oModel;

    public CProjectTree(CViewController cViewController, TreeModel treeModel, AFilter aFilter) {
        this.m_oViewController = cViewController;
        this.m_oModel = treeModel;
        this.m_oProjectTree = new JTree(treeModel);
        this.setFilter(aFilter);
        ToolTipManager.sharedInstance().registerComponent(this.m_oProjectTree);
        this.m_oTreeRenderer = new CProjectTreeRenderer();
        this.m_oProjectTree.setCellRenderer(this.m_oTreeRenderer);
        CRootCollapseListener cRootCollapseListener = new CRootCollapseListener();
        this.m_oProjectTree.addTreeWillExpandListener(cRootCollapseListener);
        treeModel.addTreeModelListener(cRootCollapseListener);
        this.m_oTypeComboBox = new JComboBox<LString>(TYPE_BOX_CONTENT);
        CTypeBoxRenderer cTypeBoxRenderer = new CTypeBoxRenderer();
        this.m_oTypeComboBox.setRenderer(cTypeBoxRenderer);
        if (this.m_eTreeType == ETreeType.ShowTasks) {
            this.m_oTypeComboBox.setSelectedIndex(0);
        } else {
            this.m_oTypeComboBox.setSelectedIndex(1);
        }
        this.m_oTypeComboBox.addItemListener(this);
        CTableLayout cTableLayout = CTableLayout.initLayout((Container)this);
        cTableLayout.addRow.AutoHeightRow();
        cTableLayout.mf_oProps.setAlignment(CCellProps.AX.maximized, CCellProps.AY.maximized);
        cTableLayout.mf_oProps.setMargin(0, 0, 0, 5);
        cTableLayout.addCell.AutoGlueCell((Component)this.m_oTypeComboBox);
        cTableLayout.addRow.AutoGlueRow();
        cTableLayout.mf_oProps.setMargin(0, 0, 0, 0);
        cTableLayout.addCell.AutoGlueCell((Component)new JScrollPane(this.m_oProjectTree));
    }

    public final JTree getProjectTree() {
        return this.m_oProjectTree;
    }

    public ETreeType getTreeType() {
        return this.m_eTreeType;
    }

    public void setFilter(AFilter aFilter) {
        this.m_oProjectTree.removeTreeSelectionListener(this.m_oViewController);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.m_oModel.getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        if (aFilter instanceof AFilter.CTasksInTreeFilter) {
            this.m_eTreeType = ETreeType.ShowTasks;
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                Enumeration<TreeNode> enumeration2 = defaultMutableTreeNode2.children();
                while (enumeration2.hasMoreElements()) {
                    DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration2.nextElement();
                    CTaskImpl cTaskImpl = (CTaskImpl)defaultMutableTreeNode3.getUserObject();
                    if (!aFilter.containsTask(cTaskImpl)) continue;
                    TreePath treePath = new TreePath(defaultMutableTreeNode3.getPath());
                    this.m_oProjectTree.addSelectionPath(treePath);
                }
            }
        } else {
            this.m_eTreeType = ETreeType.ShowCategories;
            AFilter.CCategoriesInTreeFilter cCategoriesInTreeFilter = (AFilter.CCategoriesInTreeFilter)aFilter;
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)enumeration.nextElement();
                CProjectImpl cProjectImpl = (CProjectImpl)defaultMutableTreeNode4.getUserObject();
                Enumeration<TreeNode> enumeration3 = defaultMutableTreeNode4.children();
                while (enumeration3.hasMoreElements()) {
                    DefaultMutableTreeNode defaultMutableTreeNode5 = (DefaultMutableTreeNode)enumeration3.nextElement();
                    CategoryList.CCategory cCategory = (CategoryList.CCategory)defaultMutableTreeNode5.getUserObject();
                    if (!cCategoriesInTreeFilter.containsMappedCategory(cCategory, cProjectImpl)) continue;
                    TreePath treePath = new TreePath(defaultMutableTreeNode5.getPath());
                    this.m_oProjectTree.addSelectionPath(treePath);
                }
            }
        }
        this.m_oProjectTree.addTreeSelectionListener(this.m_oViewController);
    }

    public static ETreeType getTreeTypeByIndex(int n) {
        return ETreeType.values()[n];
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        ETreeType eTreeType = this.getTreeType();
        ETreeType eTreeType2 = CProjectTree.getTreeTypeByIndex(this.m_oTypeComboBox.getSelectedIndex());
        if (eTreeType2 != eTreeType) {
            this.m_oViewController.incomingProjectTreeTypeChanged(eTreeType2);
        }
    }

    private class CRootCollapseListener
    implements TreeWillExpandListener,
    TreeModelListener {
        @Override
        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            if (treeExpansionEvent.getPath().getPathCount() <= 1) {
                throw new ExpandVetoException(treeExpansionEvent);
            }
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            if (treeModelEvent.getTreePath().getPathCount() <= 1) {
                CProjectTree.this.m_oProjectTree.expandRow(0);
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }

    private static class CTypeBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final ImageIcon TASK_ICON = CProjectTreeRenderer.TASK_ICON;
        private static final ImageIcon CATEGORY_ICON = CProjectTreeRenderer.CATEGORY_ICON;

        public CTypeBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            LString lString = (LString)object;
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (lString == TYPE_BOX_CONTENT[0]) {
                this.setIcon(TASK_ICON);
            } else {
                this.setIcon(CATEGORY_ICON);
            }
            this.setText(lString.toString());
            this.setFont(jList.getFont());
            return this;
        }
    }

    private static class CProjectTreeRenderer
    extends DefaultTreeCellRenderer {
        static final ImageIcon ROOT_ICON;
        static final ImageIcon PROJECT_CLOSED_ICON;
        static final ImageIcon PROJECT_ICON;
        static final ImageIcon DEFAULT_TASK_PROJECT_ICON;
        static final ImageIcon TASK_ICON;
        static final ImageIcon DEFAULT_TASK_ICON;
        static final ImageIcon TEAM_OVERLAY_ICON;
        static final ImageIcon TEAM_UPLOADED_OVERLAY_ICON;
        static final ImageIcon LEADER_OVERLAY_ICON;
        static final ImageIcon CATEGORY_ICON;
        static final LString TOOLTIP_ROOT;
        static final LString TOOLTIP_PROJECT;
        static final LString TOOLTIP_PROJECT_TEAM;
        static final LString TOOLTIP_PROJECT_NOTEAM;
        static final LString TOOLTIP_PROJECT_CLOSED;
        static final LString TOOLTIP_PROJECT_LEADER;
        static final LString TOOLTIP_PROJECT_NOLEADER;
        static final LString TOOLTIP_PROJECT_DESC;
        static final LString TOOLTIP_PROJECT_NODESC;
        static final LString TOOLTIP_TASK;
        static final LString TOOLTIP_TASK_TEAM_SERVER;
        static final LString TOOLTIP_TASK_TEAM_LOCAL;
        static final LString TOOLTIP_TASK_DESC;
        static final LString TOOLTIP_CATEGORY;
        private final OverlayedIcon mf_oOverlayIcon = new OverlayedIcon(ROOT_ICON.getIconWidth(), ROOT_ICON.getIconHeight());

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            String string = null;
            String string2 = object2.toString();
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (defaultMutableTreeNode.isRoot()) {
                this.setIcon(ROOT_ICON);
                string2 = String.format("<html><b>%s", string2);
                string = TOOLTIP_ROOT.format(new Object[]{MainController.getInstance().getUser().getFullName()});
            } else if (object2 instanceof CProjectImpl) {
                CProjectImpl cProjectImpl = (CProjectImpl)object2;
                this.mf_oOverlayIcon.reset();
                if (cProjectImpl.isClosed()) {
                    this.mf_oOverlayIcon.addOverlayIcon(PROJECT_CLOSED_ICON);
                } else {
                    this.mf_oOverlayIcon.addOverlayIcon(cProjectImpl.containsDefaultTask() ? DEFAULT_TASK_PROJECT_ICON : PROJECT_ICON);
                }
                if (cProjectImpl.isTeamProject()) {
                    this.mf_oOverlayIcon.addOverlayIcon(TEAM_UPLOADED_OVERLAY_ICON);
                    if (cProjectImpl.isUserProjectLeader()) {
                        this.mf_oOverlayIcon.addOverlayIcon(LEADER_OVERLAY_ICON);
                    }
                }
                this.setIcon(this.mf_oOverlayIcon.getIcon());
                string = TOOLTIP_PROJECT.format(new Object[]{cProjectImpl.getName()});
                if (cProjectImpl.isTeamProject()) {
                    string = string + TOOLTIP_PROJECT_TEAM;
                    if (cProjectImpl.isClosed()) {
                        string = string + TOOLTIP_PROJECT_CLOSED;
                    }
                    string = cProjectImpl.isUserProjectLeader() ? string + TOOLTIP_PROJECT_LEADER : string + TOOLTIP_PROJECT_NOLEADER;
                } else {
                    string = string + TOOLTIP_PROJECT_NOTEAM;
                    if (cProjectImpl.isClosed()) {
                        string = string + TOOLTIP_PROJECT_CLOSED;
                    }
                }
                String string3 = cProjectImpl.getDescription();
                string = string3 != null && string3.length() > 0 ? string + TOOLTIP_PROJECT_DESC.format(new Object[]{string3}) : string + TOOLTIP_PROJECT_NODESC;
            } else if (object2 instanceof CTaskImpl) {
                CTaskImpl cTaskImpl = (CTaskImpl)object2;
                this.mf_oOverlayIcon.reset();
                this.mf_oOverlayIcon.addOverlayIcon(cTaskImpl.isDefaultTask() ? DEFAULT_TASK_ICON : TASK_ICON);
                if (cTaskImpl.isTeamTask()) {
                    this.mf_oOverlayIcon.addOverlayIcon(TEAM_UPLOADED_OVERLAY_ICON);
                } else if (cTaskImpl.getProject().isTeamProject()) {
                    this.mf_oOverlayIcon.addOverlayIcon(TEAM_OVERLAY_ICON);
                }
                this.setIcon(this.mf_oOverlayIcon.getIcon());
                string = TOOLTIP_TASK.format(new Object[]{cTaskImpl.getName()});
                if (cTaskImpl.isTeamTask()) {
                    string = string + TOOLTIP_TASK_TEAM_SERVER;
                } else if (cTaskImpl.getProject().isTeamProject()) {
                    string = string + TOOLTIP_TASK_TEAM_LOCAL;
                }
                String string4 = cTaskImpl.getDescription();
                if (string4 != null && string4.length() > 0) {
                    string = string + TOOLTIP_TASK_DESC.format(new Object[]{string4});
                }
            } else if (object2 instanceof CategoryList.CCategory) {
                CategoryList.CCategory cCategory = (CategoryList.CCategory)object2;
                this.setIcon(CATEGORY_ICON);
                string = TOOLTIP_CATEGORY.format(new Object[]{cCategory.getName(), new Integer(cCategory.getID()), cCategory.getDescription()});
            }
            this.setText(string2);
            this.setToolTipText(string);
            return this;
        }

        static {
            TOOLTIP_ROOT = Labels.getLS("TREE_TOOLTIP_ROOT");
            TOOLTIP_PROJECT = Labels.getLS("TREE_TOOLTIP_PROJECT");
            TOOLTIP_PROJECT_TEAM = Labels.getLS("TREE_TOOLTIP_PROJECT_TEAM");
            TOOLTIP_PROJECT_NOTEAM = Labels.getLS("TREE_TOOLTIP_PROJECT_NOTEAM");
            TOOLTIP_PROJECT_CLOSED = Labels.getLS("TREE_TOOLTIP_PROJECT_CLOSED");
            TOOLTIP_PROJECT_LEADER = Labels.getLS("TREE_TOOLTIP_PROJECT_LEADER");
            TOOLTIP_PROJECT_NOLEADER = Labels.getLS("TREE_TOOLTIP_PROJECT_NOLEADER");
            TOOLTIP_PROJECT_DESC = Labels.getLS("TREE_TOOLTIP_PROJECT_DESC");
            TOOLTIP_PROJECT_NODESC = Labels.getLS("TREE_TOOLTIP_PROJECT_NODESC");
            TOOLTIP_TASK = Labels.getLS("TREE_TOOLTIP_TASK");
            TOOLTIP_TASK_TEAM_SERVER = Labels.getLS("TREE_TOOLTIP_TASK_TEAM_SERVER");
            TOOLTIP_TASK_TEAM_LOCAL = Labels.getLS("TREE_TOOLTIP_TASK_TEAM_LOCAL");
            TOOLTIP_TASK_DESC = Labels.getLS("TREE_TOOLTIP_TASK_DESC");
            TOOLTIP_CATEGORY = Labels.getLS("TREE_TOOLTIP_CATEGORY");
            try {
                ROOT_ICON = MainController.getResLoader().getIconExcpt("images/tree-root.png");
                PROJECT_CLOSED_ICON = MainController.getResLoader().getIconExcpt("images/tree-project-closed.png");
                PROJECT_ICON = MainController.getResLoader().getIconExcpt("images/tree-project-open.png");
                DEFAULT_TASK_PROJECT_ICON = MainController.getResLoader().getIconExcpt("images/tree-defaulttask-project.png");
                TASK_ICON = MainController.getResLoader().getIconExcpt("images/tree-task.png");
                DEFAULT_TASK_ICON = MainController.getResLoader().getIconExcpt("images/tree-default-task.png");
                TEAM_OVERLAY_ICON = MainController.getResLoader().getIconExcpt("images/tree-overlay-team.png");
                TEAM_UPLOADED_OVERLAY_ICON = MainController.getResLoader().getIconExcpt("images/tree-overlay-team-uploaded.png");
                LEADER_OVERLAY_ICON = MainController.getResLoader().getIconExcpt("images/tree-overlay-leader.png");
                CATEGORY_ICON = MainController.getResLoader().getIconExcpt("images/tree-category.png");
            }
            catch (ResourceLoader.ResourceLoadException resourceLoadException) {
                throw new ExceptionInInitializerError(resourceLoadException);
            }
        }

        private static class OverlayedIcon {
            private final LinkedList<ImageIcon> mf_oIconList = new LinkedList();
            private final int mf_iWidth;
            private final int mf_iHeight;

            public OverlayedIcon(int n, int n2) {
                this.mf_iWidth = n;
                this.mf_iHeight = n2;
            }

            public void reset() {
                this.mf_oIconList.clear();
            }

            public void addOverlayIcon(ImageIcon imageIcon) {
                this.mf_oIconList.add(imageIcon);
            }

            public ImageIcon getIcon() {
                BufferedImage bufferedImage = new BufferedImage(this.mf_iWidth, this.mf_iHeight, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                for (ImageIcon imageIcon : this.mf_oIconList) {
                    graphics2D.drawImage(imageIcon.getImage(), 0, 0, null);
                }
                return new ImageIcon(bufferedImage);
            }
        }
    }

    public static enum ETreeType {
        ShowTasks,
        ShowCategories;

    }
}

