/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.ixml.common.BaseEventManager;
import com.mayastudios.ixml.labels.LString;
import com.mayastudios.ixml.labels.LabelsCore;
import com.mayastudios.mscl.ResourceLoader;
import com.mayastudios.mscl.grafics.CColorEx;
import com.mayastudios.mscl.mwt.widgets.ABoundsHelperPanel;
import com.mayastudios.mscl.mwt.widgets.CSmoothLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageObserver;
import javax.swing.ImageIcon;

public class CStartScreen
extends ABoundsHelperPanel
implements MouseListener {
    private static final ImageIcon WATERMARK_IMAGE;
    private static final ImageIcon NEW_IMAGE;
    private static final ImageIcon LOAD_IMAGE;
    private static final ImageIcon QUICKSTART_IMAGE;
    private static final ImageIcon NEW_IMAGE_OVER;
    private static final ImageIcon LOAD_IMAGE_OVER;
    private static final ImageIcon QUICKSTART_IMAGE_OVER;
    private static final int BUTTON_GAP = 30;
    private static final Color BACKGROUND_COLOR_ONE;
    private static final Color BACKGROUND_COLOR_TWO;
    private static final Color TEXT_COLOR_OVER;
    private static final Color TEXT_COLOR;
    private static final int DEFAULT_FONT_SIZE = 20;
    private static final int HEADER_FONT_SIZE = 35;
    private static final Font DEFAULT_FONT;
    private GradientPaint m_oBackground = CStartScreen._createGradient(0, 0);
    private final StartScreenLabel mf_oIntroLabel = new StartScreenLabel("STARTSCREEN_WELCOME");
    private final StartScreenLabel mf_oButtonNew;
    private final StartScreenLabel mf_oButtonOpen;
    private final StartScreenLabel mf_oButtonQuickstart;

    public CStartScreen() {
        super(true);
        this.mf_oIntroLabel.setForeground(TEXT_COLOR_OVER);
        this.mf_oIntroLabel.setFont(DEFAULT_FONT.deriveFont(35.0f));
        this.add((Component)((Object)this.mf_oIntroLabel));
        this.mf_oButtonNew = this._setupLabel(NEW_IMAGE, "STARTSCREEN_CREATE");
        this.add((Component)((Object)this.mf_oButtonNew));
        this.mf_oButtonOpen = this._setupLabel(LOAD_IMAGE, "STARTSCREEN_OPEN");
        this.add((Component)((Object)this.mf_oButtonOpen));
        this.mf_oButtonQuickstart = this._setupLabel(QUICKSTART_IMAGE, "STARTSCREEN_QUICKHELP");
        this.add((Component)((Object)this.mf_oButtonQuickstart));
    }

    private StartScreenLabel _setupLabel(ImageIcon imageIcon, String string) {
        StartScreenLabel startScreenLabel = new StartScreenLabel(string);
        startScreenLabel.setIcon(imageIcon);
        startScreenLabel.setForeground(TEXT_COLOR);
        startScreenLabel.setFont(DEFAULT_FONT);
        startScreenLabel.setIconTextGap(15);
        startScreenLabel.setHorizontalTextPosition(0);
        startScreenLabel.setVerticalTextPosition(3);
        startScreenLabel.addMouseListener(this);
        return startScreenLabel;
    }

    protected void paintComponent(Graphics2D graphics2D) {
        Dimension dimension = this.getSize();
        graphics2D.setPaint(this.m_oBackground);
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        graphics2D.drawImage(WATERMARK_IMAGE.getImage(), dimension.width - WATERMARK_IMAGE.getIconWidth() - 50, dimension.height - WATERMARK_IMAGE.getIconHeight() - 50, (ImageObserver)((Object)this));
    }

    protected void boundsChanged(int n, int n2, ABoundsHelperPanel.EChangeType eChangeType) {
        Dimension dimension = this.mf_oIntroLabel.getPreferredSize();
        Dimension dimension2 = this.mf_oButtonNew.getPreferredSize();
        Dimension dimension3 = this.mf_oButtonOpen.getPreferredSize();
        Dimension dimension4 = this.mf_oButtonQuickstart.getPreferredSize();
        this.m_oBackground = CStartScreen._createGradient(n, n2);
        this.mf_oIntroLabel.setBounds((n - dimension.width) / 2, (n2 - dimension2.height) / 2 - 60 - dimension.height, dimension.width, dimension.height);
        this.mf_oButtonNew.setBounds((n - dimension3.width) / 2 - 30 - dimension2.width, (n2 - dimension2.height) / 2, dimension2.width, dimension2.height);
        this.mf_oButtonOpen.setBounds((n - dimension3.width) / 2, (n2 - dimension3.height) / 2, dimension3.width, dimension3.height);
        this.mf_oButtonQuickstart.setBounds((n - dimension3.width) / 2 + dimension3.width + 30, (n2 - dimension4.height) / 2, dimension4.width, dimension4.height);
    }

    private static GradientPaint _createGradient(int n, int n2) {
        return new GradientPaint(0.0f, 0.0f, BACKGROUND_COLOR_ONE, (float)n * 0.75f, n2, BACKGROUND_COLOR_TWO);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this.mf_oButtonNew) {
            MainController.incomingFileCreateWorkfile();
        } else if (mouseEvent.getComponent() == this.mf_oButtonOpen) {
            MainController.incomingFileOpenWorkfile();
        } else if (mouseEvent.getComponent() == this.mf_oButtonQuickstart) {
            MainController.incomingHelpQuickstart();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this.mf_oButtonNew) {
            this.mf_oButtonNew.setIcon(NEW_IMAGE_OVER);
            this.mf_oButtonNew.setForeground(TEXT_COLOR_OVER);
        } else if (mouseEvent.getComponent() == this.mf_oButtonOpen) {
            this.mf_oButtonOpen.setIcon(LOAD_IMAGE_OVER);
            this.mf_oButtonOpen.setForeground(TEXT_COLOR_OVER);
        } else if (mouseEvent.getComponent() == this.mf_oButtonQuickstart) {
            this.mf_oButtonQuickstart.setIcon(QUICKSTART_IMAGE_OVER);
            this.mf_oButtonQuickstart.setForeground(TEXT_COLOR_OVER);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this.mf_oButtonNew) {
            this.mf_oButtonNew.setIcon(NEW_IMAGE);
            this.mf_oButtonNew.setForeground(TEXT_COLOR);
        } else if (mouseEvent.getComponent() == this.mf_oButtonOpen) {
            this.mf_oButtonOpen.setIcon(LOAD_IMAGE);
            this.mf_oButtonOpen.setForeground(TEXT_COLOR);
        } else if (mouseEvent.getComponent() == this.mf_oButtonQuickstart) {
            this.mf_oButtonQuickstart.setIcon(QUICKSTART_IMAGE);
            this.mf_oButtonQuickstart.setForeground(TEXT_COLOR);
        }
    }

    static {
        try {
            WATERMARK_IMAGE = MainController.getResLoader().getIconExcpt("images/startscreen-watermark.png");
            NEW_IMAGE = MainController.getResLoader().getIconExcpt("images/startscreen-new.png");
            LOAD_IMAGE = MainController.getResLoader().getIconExcpt("images/startscreen-load.png");
            QUICKSTART_IMAGE = MainController.getResLoader().getIconExcpt("images/startscreen-quickstart.png");
            NEW_IMAGE_OVER = MainController.getResLoader().getIconExcpt("images/startscreen-new-over.png");
            LOAD_IMAGE_OVER = MainController.getResLoader().getIconExcpt("images/startscreen-load-over.png");
            QUICKSTART_IMAGE_OVER = MainController.getResLoader().getIconExcpt("images/startscreen-quickstart-over.png");
        }
        catch (ResourceLoader.ResourceLoadException resourceLoadException) {
            throw new ExceptionInInitializerError(resourceLoadException);
        }
        BACKGROUND_COLOR_ONE = new Color(64, 96, 199);
        BACKGROUND_COLOR_TWO = new Color(27, 44, 114);
        TEXT_COLOR_OVER = Color.WHITE;
        TEXT_COLOR = new CColorEx(TEXT_COLOR_OVER, 180);
        DEFAULT_FONT = new Font("Sans Serif", 1, 20);
    }

    private class StartScreenLabel
    extends CSmoothLabel
    implements LabelsCore.ILabelsChangeListener {
        private final LString mf_oLabel;

        public StartScreenLabel(String string) {
            this.mf_oLabel = Labels.getLS(string);
            LabelsCore.addLabelsChangeListener((LabelsCore.ILabelsChangeListener)this, (BaseEventManager.ERefType)BaseEventManager.ERefType.WEAK);
            this.setText(this.mf_oLabel.toString());
        }

        @Deprecated
        public void setText(String string) {
            super.setText(string);
        }

        public void labelsChanged(boolean bl) {
            this.setText(this.mf_oLabel.toString());
            CStartScreen.this.boundsChanged(CStartScreen.this.getWidth(), CStartScreen.this.getHeight(), ABoundsHelperPanel.EChangeType.RESIZED);
        }
    }
}

