/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view;

import com.mayastudios.fred.client.controller.CViewController;
import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.view.CEffortTable;
import com.mayastudios.fred.client.view.CFilterPanel;
import com.mayastudios.fred.client.view.CProjectTree;
import com.mayastudios.ixml.common.BaseEventManager;
import com.mayastudios.mscl.ResourceLoader;
import com.mayastudios.mscl.mwt.dockpane.ATabPanel;
import com.mayastudios.mscl.mwt.dockpane.toolbar.CToolbar;
import com.mayastudios.mscl.mwt.tablelayout.CTableLayout;
import com.mayastudios.mscl.mwt.widgets.CTableScrollPane;
import com.mayastudios.mscl.mwt.widgets.button.CButtonEvent;
import com.mayastudios.mscl.mwt.widgets.button.CFlatButton;
import com.mayastudios.mscl.mwt.widgets.button.IButtonListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;

public class CView
extends ATabPanel
implements IButtonListener {
    private static final ImageIcon FILTER_ENABLE_ICON;
    private static final ImageIcon FILTER_DIALOG_ICON;
    private static final ImageIcon CUSTOMIZE_COLUMNS_ICON;
    private static final ImageIcon SHOW_SECOND_ROW_ICON;
    private final CToolbar mf_oToolbar;
    private CFlatButton m_oFilterEnableButton;
    private CFlatButton m_oFilterDialogButton;
    private CFlatButton m_oShowSecondRowButton;
    private CFilterPanel m_oFilterDialog;
    private JScrollPane m_oFilterScrollPane;
    private CProjectTree m_oTree;
    private CEffortTable m_oTable;
    private CViewController m_oViewController;

    public CView(CFilterPanel cFilterPanel, CProjectTree cProjectTree, CEffortTable cEffortTable, CViewController cViewController) {
        super(false);
        this.m_oFilterDialog = cFilterPanel;
        this.m_oTree = cProjectTree;
        this.m_oTable = cEffortTable;
        this.m_oTable.setAutoResizeMode(0);
        this.m_oViewController = cViewController;
        JPanel jPanel = new JPanel();
        CTableLayout cTableLayout = CTableLayout.initLayout((Container)jPanel);
        cTableLayout.mf_oProps.maximizeBothAlignments();
        this.m_oFilterScrollPane = new JScrollPane(this.m_oFilterDialog);
        this.m_oFilterScrollPane.setHorizontalScrollBarPolicy(30);
        this.m_oFilterScrollPane.setVerticalScrollBarPolicy(21);
        this.m_oFilterScrollPane.setVisible(false);
        cTableLayout.addRow.AutoHeightRow();
        cTableLayout.mf_oProps.setMargin(0, 0, 0, 5);
        cTableLayout.addCell.AutoGlueCell((Component)this.m_oFilterScrollPane);
        CTableScrollPane cTableScrollPane = new CTableScrollPane((JTable)((Object)this.m_oTable));
        cTableScrollPane.setHorizontalScrollBarPolicy(30);
        cTableScrollPane.setVerticalScrollBarPolicy(20);
        cTableLayout.addRow.AutoGlueRow();
        cTableLayout.mf_oProps.setMargin(0, 0, 0, 0);
        cTableLayout.addCell.AutoGlueCell((Component)cTableScrollPane);
        JSplitPane jSplitPane = new JSplitPane(1, this.m_oTree, jPanel);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setDividerLocation(220);
        jSplitPane.setBorder(null);
        this.setLayout(new BorderLayout());
        this.add(jSplitPane, "Center");
        this.mf_oToolbar = this._createTabToolbar();
    }

    private CToolbar _createTabToolbar() {
        CToolbar cToolbar = new CToolbar();
        this.m_oFilterEnableButton = new CFlatButton((Icon)FILTER_ENABLE_ICON);
        this.m_oFilterEnableButton.addButtonListener((IButtonListener)this, BaseEventManager.ERefType.REGULAR);
        this.m_oFilterEnableButton.setToggleButton(true);
        this.m_oFilterEnableButton.activateToggleButton(this.m_oFilterDialog.getFilter().useThisFilter(), false);
        cToolbar.addButton(this.m_oFilterEnableButton, Labels.get("TABTOOLBAR_USE_FILTER", new Object[0]));
        this.m_oFilterDialogButton = new CFlatButton((Icon)FILTER_DIALOG_ICON);
        this.m_oFilterDialogButton.setToggleButton(true);
        this.m_oFilterDialogButton.addButtonListener((IButtonListener)this, BaseEventManager.ERefType.REGULAR);
        cToolbar.addButton(this.m_oFilterDialogButton, Labels.get("TABTOOLBAR_SHOW_FILTERDIALOG", new Object[0]));
        if (this.m_oFilterDialog.getFilter().useThisFilter()) {
            this.m_oFilterDialogButton.activateToggleButton(true, true);
        }
        cToolbar.addSeparator();
        this.m_oShowSecondRowButton = new CFlatButton((Icon)SHOW_SECOND_ROW_ICON);
        this.m_oShowSecondRowButton.setToggleButton(true);
        this.m_oShowSecondRowButton.addButtonListener((IButtonListener)this, BaseEventManager.ERefType.REGULAR);
        cToolbar.addButton(this.m_oShowSecondRowButton, Labels.get("TABTOOLBAR_SECONDROW", new Object[0]));
        cToolbar.addSeparator();
        CFlatButton cFlatButton = new CFlatButton((Icon)CUSTOMIZE_COLUMNS_ICON);
        cFlatButton.addButtonListener((IButtonListener)this, BaseEventManager.ERefType.REGULAR);
        cToolbar.addButton(cFlatButton, Labels.get("TABTOOLBAR_CUSTOMIZE", new Object[0]));
        return cToolbar;
    }

    CToolbar getToolbar() {
        return this.mf_oToolbar;
    }

    public void activateFilterButton(boolean bl) {
        this.m_oFilterEnableButton.activateToggleButton(bl, false);
    }

    public void activateSecondRowButton() {
        this.m_oShowSecondRowButton.activateToggleButton(true, false);
    }

    public CFilterPanel getFilterDialog() {
        return this.m_oFilterDialog;
    }

    public CProjectTree getTree() {
        return this.m_oTree;
    }

    public JTable getTable() {
        return this.m_oTable;
    }

    public CViewController getViewController() {
        return this.m_oViewController;
    }

    protected Component getDefaultComponent() {
        return this.m_oTable;
    }

    public boolean acceptClick(MouseEvent mouseEvent) {
        return true;
    }

    public void buttonActionPerformed(CButtonEvent cButtonEvent) {
        if (cButtonEvent.getAction() == FILTER_ENABLE_ICON) {
            this.m_oFilterDialog.enableFilter(this.m_oFilterEnableButton.isToggleButtonActivated());
        } else if (cButtonEvent.getAction() == FILTER_DIALOG_ICON) {
            this.m_oFilterScrollPane.setVisible(this.m_oFilterDialogButton.isToggleButtonActivated());
            this.validate();
        } else if (cButtonEvent.getAction() == CUSTOMIZE_COLUMNS_ICON) {
            this.m_oViewController.incomingViewCustomizeColumns();
        } else if (cButtonEvent.getAction() == SHOW_SECOND_ROW_ICON) {
            this.m_oTable.setEnableSecondRow(this.m_oShowSecondRowButton.isToggleButtonActivated());
        }
    }

    static {
        try {
            FILTER_ENABLE_ICON = MainController.getResLoader().getIconExcpt("images/viewtoolbar-filter-enable.png");
            FILTER_DIALOG_ICON = MainController.getResLoader().getIconExcpt("images/viewtoolbar-showfilterpanel.png");
            CUSTOMIZE_COLUMNS_ICON = MainController.getResLoader().getIconExcpt("images/menu/view-customize.png");
            SHOW_SECOND_ROW_ICON = MainController.getResLoader().getIconExcpt("images/viewtoolbar-secondrow.png");
        }
        catch (ResourceLoader.ResourceLoadException resourceLoadException) {
            throw new ExceptionInInitializerError(resourceLoadException);
        }
    }
}

