/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view.dialogs;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.view.CMainWindow;
import com.mayastudios.fred.client.view.dialogs.ADialog;
import com.mayastudios.fred.client.view.dialogs.CTitledPanel;
import com.mayastudios.ixml.labels.LString;
import com.mayastudios.mscl.mwt.GUIConstants;
import com.mayastudios.mscl.mwt.GUIHelper;
import com.mayastudios.mscl.mwt.widgets.ModalFrame;
import com.mayastudios.mscl.mwt.windowcloser.CWindowCloser;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public abstract class ADialogEx
extends ADialog {
    protected static final LString OK_BUTTON_TEXT = Labels.getLS("BUTTON_SUBMIT");
    protected static final LString CLOSE_BUTTON_TEXT = Labels.getLS("BUTTON_CLOSE");
    protected static final LString CANCEL_BUTTON_TEXT = Labels.getLS("BUTTON_CANCEL");
    protected static final LString DISCARD_BUTTON_TEXT = Labels.getLS("BUTTON_DISCARD");
    protected static final int NO_BUTTON_FLAG = 0;
    protected static final int OK_BUTTON_FLAG = 1;
    protected static final int CANCEL_BUTTON_FLAG = 2;
    protected static final int DISCARD_BUTTON_FLAG = 4;
    protected static final int OKCANCEL_BUTTON_FLAG = 3;
    protected static final int OKCANCELDISCARD_BUTTON_FLAG = 7;
    protected static final int DIALOG_PADDING = 8;
    protected static final int BUTTON_PADDING = 3;
    protected static final int CONTENT_BUTTON_GAP = 30;
    private static final KeyStroke OK_ENTER_STROKE = KeyStroke.getKeyStroke(10, 0, true);
    private static final KeyStroke CANCEL_ESCAPE_STROKE = KeyStroke.getKeyStroke(27, 0, true);
    private static final String OK_BUTTON_ACTION_NAME = "OK_BUTTON_ENTER_PRESSED";
    private static final String CANCEL_BUTTON_ACTION_NAME = "CANCEL_BUTTON_ESC_PRESSED";
    private static final Set<AWTKeyStroke> FORWARD_FOCUS_KEY;
    private static final Set<AWTKeyStroke> BACKWARD_FOCUS_KEY;
    private boolean m_bSuccessful = false;
    private boolean m_bDialogContainsValidInput = false;
    EReturnValue m_eRetValue = null;
    private CTitledPanel m_oSuperContentPanel;
    private JPanel m_oContentPanel = new JPanel();
    private JPanel m_oButtonPanel = new JPanel();
    JButton m_oOkButton = new JButton();
    JButton m_oCancelButton = new JButton();
    JButton m_oDiscardButton = new JButton();
    private Dimension m_oRequestedSize;

    public ADialogEx(JFrame jFrame, String string, int n, Dimension dimension) {
        this(jFrame, string, null, true, OK_BUTTON_TEXT.toString(), n, dimension);
    }

    public ADialogEx(JFrame jFrame, String string, String string2, boolean bl, int n, Dimension dimension) {
        this(jFrame, string, string2, bl, OK_BUTTON_TEXT.toString(), n, dimension);
    }

    public ADialogEx(JFrame jFrame, String string, String string2, boolean bl, String string3, int n, Dimension dimension) {
        this(jFrame, string, null, string2, bl, string3, n, dimension);
    }

    public ADialogEx(JFrame jFrame, String string, String string2, String string3, boolean bl, String string4, int n, Dimension dimension) {
        this(jFrame, true, string, string2, string3, bl, string4, n, dimension);
    }

    public ADialogEx(JFrame jFrame, boolean bl, String string, String string2, String string3, boolean bl2, String string4, int n, Dimension dimension) {
        super(jFrame != null || !bl ? jFrame : new ModalFrame.ModalFrameFaker(string, CMainWindow.MAIN_ICON.getImage()), string, "", string4, "", ADialog.EShowButtons.NONE, false, new Dimension(), bl);
        if (this.getOwner() instanceof ModalFrame.ModalFrameFaker) {
            ((ModalFrame.ModalFrameFaker)this.getOwner()).completeInitialization((JDialog)this);
        }
        JPanel jPanel = super.getContentPanel();
        jPanel.removeAll();
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel.setLayout(new BorderLayout());
        this.m_oSuperContentPanel = new CTitledPanel(string, string2, MainController.getResLoader().getIcon(string3), bl2, 8);
        jPanel.add((Component)((Object)this.m_oSuperContentPanel), "Center");
        jPanel = this.m_oSuperContentPanel.getContentPanel();
        jPanel.setLayout(new BorderLayout());
        CButtonListener cButtonListener = new CButtonListener();
        this.m_oButtonPanel.setBorder(BorderFactory.createEmptyBorder(30, 0, 0, -3));
        this.m_oButtonPanel.setLayout(new FlowLayout(2, 3, 0));
        this.setOkButtonText(string4);
        this.m_oOkButton.addActionListener(cButtonListener);
        this.m_oButtonPanel.add(this.m_oOkButton);
        this.setCancelButtonText(null);
        this.m_oCancelButton.addActionListener(cButtonListener);
        this.m_oButtonPanel.add(this.m_oCancelButton);
        this.setDiscardButtonText(null);
        this.m_oDiscardButton.addActionListener(cButtonListener);
        this.m_oButtonPanel.add(this.m_oDiscardButton);
        this.setButtons(n);
        this.updateButtonArea();
        this.m_oContentPanel.setLayout(null);
        jPanel.add((Component)this.m_oContentPanel, "Center");
        jPanel.add((Component)this.m_oButtonPanel, "South");
        this.m_oRequestedSize = new Dimension(dimension);
        this.addWindowListener(new CWindowListener());
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(OK_ENTER_STROKE, OK_BUTTON_ACTION_NAME);
        inputMap.put(CANCEL_ESCAPE_STROKE, CANCEL_BUTTON_ACTION_NAME);
        this.getRootPane().getActionMap().put(OK_BUTTON_ACTION_NAME, new CSpecialKeyHandler(true));
        this.getRootPane().getActionMap().put(CANCEL_BUTTON_ACTION_NAME, new CSpecialKeyHandler(false));
    }

    public EReturnValue showDialog() {
        Dimension dimension = new Dimension(this.m_oRequestedSize);
        Dimension dimension2 = this.m_oContentPanel.getPreferredSize();
        Dimension dimension3 = this.m_oButtonPanel.getPreferredSize();
        if (dimension.width < 0) {
            dimension.width = dimension2.width;
        }
        if (dimension.height < 0) {
            dimension.height = dimension2.height;
        }
        dimension.height += this.m_oSuperContentPanel.getTitleBarHeight() + 16 + dimension3.height;
        dimension.width = Math.max(dimension.width, dimension3.width) + 16;
        super.getContentPanel().setPreferredSize(dimension);
        if (this.isModal()) {
            ModalFrame.ModalFrameFaker modalFrameFaker = null;
            if (this.getOwner() instanceof ModalFrame.ModalFrameFaker) {
                modalFrameFaker = (ModalFrame.ModalFrameFaker)this.getOwner();
            }
            if (modalFrameFaker == null) {
                MainController.bringMainWindowToFront();
            }
            do {
                try {
                    super.setVisible(true);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    StackTraceElement[] stackTraceElementArray = arrayIndexOutOfBoundsException.getStackTrace();
                    if (stackTraceElementArray.length != 0 && "sun.font.FontDesignMetrics".equals(stackTraceElementArray[0].getMethodName()) && "charsWidth".equals(stackTraceElementArray[0].getMethodName())) continue;
                    throw arrayIndexOutOfBoundsException;
                }
            } while (this.m_eRetValue == null);
            if (modalFrameFaker != null) {
                modalFrameFaker.onHiding();
            }
        } else {
            super.setVisible(true);
        }
        return this.m_eRetValue;
    }

    public EReturnValue getReturnValue() {
        return this.m_eRetValue;
    }

    protected Component getDefaultComponent() {
        return null;
    }

    @Override
    @Deprecated
    public Component add(Component component) {
        return super.add(component);
    }

    @Override
    @Deprecated
    public void add(Component component, Object object) {
        super.add(component, object);
    }

    @Override
    @Deprecated
    public boolean wasSuccessful() {
        return this.m_bSuccessful;
    }

    @Override
    public final void setErrorText(String string) {
        this.m_oSuperContentPanel.setErrorText(string);
    }

    private void _closeDialog(EReturnValue eReturnValue) {
        this.m_eRetValue = eReturnValue;
        switch (eReturnValue) {
            case OK: 
            case DISCARDED: {
                this.m_bSuccessful = true;
                break;
            }
            default: {
                this.m_bSuccessful = false;
            }
        }
        if (this.m_oOkButton.isFocusOwner() || this.m_oCancelButton.isFocusOwner() || this.m_oDiscardButton.isFocusOwner()) {
            CWindowCloser.closeWindow((Window)this);
        } else if (this.m_oOkButton.isVisible()) {
            this.m_oOkButton.addFocusListener(new CDialogCloseListener(this.m_oOkButton));
            GUIHelper.focusComponent((Component)this.m_oOkButton);
        } else if (this.m_oCancelButton.isVisible()) {
            this.m_oCancelButton.addFocusListener(new CDialogCloseListener(this.m_oCancelButton));
            GUIHelper.focusComponent((Component)this.m_oCancelButton);
        } else if (this.m_oDiscardButton.isVisible()) {
            this.m_oDiscardButton.addFocusListener(new CDialogCloseListener(this.m_oDiscardButton));
            GUIHelper.focusComponent((Component)this.m_oDiscardButton);
        } else {
            CWindowCloser.closeWindow((Window)this);
        }
    }

    protected abstract boolean onOK();

    @Override
    protected final void incomingSubmit() {
        if (!this.onOK()) {
            return;
        }
        this._closeDialog(EReturnValue.OK);
    }

    protected boolean onCancel() {
        return true;
    }

    @Override
    protected final void incomingAbort() {
        if (!this.onCancel()) {
            return;
        }
        this._closeDialog(EReturnValue.CANCEL);
    }

    protected boolean onDiscard() {
        return true;
    }

    @Override
    protected final void incomingDiscard() {
        if (!this.onDiscard()) {
            return;
        }
        this._closeDialog(EReturnValue.DISCARDED);
    }

    @Override
    @Deprecated
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    @Override
    @Deprecated
    public void dispose() {
        super.dispose();
    }

    @Override
    protected void setContentPanel(JPanel jPanel) {
        this.m_oContentPanel = jPanel;
    }

    @Override
    protected final JPanel getContentPanel() {
        return this.m_oContentPanel;
    }

    @Override
    @Deprecated
    public void setContentPane(Container container) {
        super.setContentPane(container);
    }

    @Override
    @Deprecated
    public Container getContentPane() {
        return super.getContentPane();
    }

    protected final void updateButtonArea() {
        Dimension dimension = new Dimension();
        if (this.m_oOkButton.isVisible()) {
            this._getMaximumButtonSize(dimension, this.m_oOkButton.getPreferredSize());
        }
        if (this.m_oCancelButton.isVisible()) {
            this._getMaximumButtonSize(dimension, this.m_oCancelButton.getPreferredSize());
        }
        if (this.m_oDiscardButton.isVisible()) {
            this._getMaximumButtonSize(dimension, this.m_oDiscardButton.getPreferredSize());
        }
        this.m_oOkButton.setPreferredSize(dimension);
        this.m_oCancelButton.setPreferredSize(dimension);
        this.m_oDiscardButton.setPreferredSize(dimension);
        this.m_oButtonPanel.validate();
    }

    protected void setButtons(int n) {
        this.m_oOkButton.setVisible((n & 1) != 0);
        this.m_oCancelButton.setVisible((n & 2) != 0);
        this.m_oDiscardButton.setVisible((n & 4) != 0);
    }

    protected final JButton getOkButton() {
        return this.m_oOkButton;
    }

    protected final JButton getCancelButton() {
        return this.m_oCancelButton;
    }

    protected final JButton getDiscardButton() {
        return this.m_oDiscardButton;
    }

    protected void setOkButtonText(String string) {
        this._setButtonText(this.m_oOkButton, string, OK_BUTTON_TEXT.toString());
    }

    protected void setCancelButtonText(String string) {
        this._setButtonText(this.m_oCancelButton, string, CANCEL_BUTTON_TEXT.toString());
    }

    protected void setDiscardButtonText(String string) {
        this._setButtonText(this.m_oDiscardButton, string, DISCARD_BUTTON_TEXT.toString());
    }

    private void _setButtonText(JButton jButton, String string, String string2) {
        jButton.setPreferredSize(null);
        if (string == null) {
            jButton.setText(string2);
        } else {
            jButton.setText(string);
        }
    }

    private void _getMaximumButtonSize(Dimension dimension, Dimension dimension2) {
        if (dimension2.width > dimension.width) {
            dimension.width = dimension2.width;
        }
        if (dimension2.height > dimension.height) {
            dimension.height = dimension2.height;
        }
    }

    @Override
    @Deprecated
    protected final void setButtons(ADialog.EShowButtons eShowButtons) {
    }

    protected JTextArea addTextarea(JPanel jPanel, boolean bl, int n, int n2, int n3, int n4) {
        return this.addTextarea(jPanel, bl, true, n, n2, n3, n4);
    }

    protected JTextArea addTextarea(JPanel jPanel, boolean bl, boolean bl2, int n, int n2, int n3, int n4) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setFont(GUIConstants.DEFAULT_LABEL_FONT);
        ADialogEx.disableDialogEnterKeyForComponent(jTextArea);
        if (bl2) {
            jTextArea.setFocusTraversalKeys(0, FORWARD_FOCUS_KEY);
            jTextArea.setFocusTraversalKeys(1, BACKWARD_FOCUS_KEY);
        }
        if (bl) {
            this.addScrollPane(jPanel, jTextArea, n, n2, n3, n4);
        } else {
            jTextArea.setBounds(n, n2, n3, n4);
            jPanel.add(jTextArea);
        }
        return jTextArea;
    }

    protected static void disableDialogEnterKeyForComponent(JComponent jComponent) {
        jComponent.getInputMap().put(OK_ENTER_STROKE, "doNothing-Enter");
        jComponent.getActionMap().put("doNothing-Enter", new CKeyConsumer());
    }

    protected static void disableDialogEscKeyForComponent(JComponent jComponent) {
        jComponent.getInputMap().put(CANCEL_ESCAPE_STROKE, "doNothing-ESC");
        jComponent.getActionMap().put("doNothing-ESC", new CKeyConsumer());
    }

    static {
        JButton jButton = new JButton();
        FORWARD_FOCUS_KEY = jButton.getFocusTraversalKeys(0);
        BACKWARD_FOCUS_KEY = jButton.getFocusTraversalKeys(1);
    }

    private class CDialogCloseListener
    extends FocusAdapter {
        private final JButton mf_oButton;

        public CDialogCloseListener(JButton jButton) {
            this.mf_oButton = jButton;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (ADialogEx.this.m_eRetValue != null) {
                this.mf_oButton.removeFocusListener(this);
                CWindowCloser.closeWindow((Window)ADialogEx.this);
            }
        }
    }

    private class CButtonListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ADialogEx.this.m_oOkButton) {
                ADialogEx.this.incomingSubmit();
            } else if (actionEvent.getSource() == ADialogEx.this.m_oCancelButton) {
                ADialogEx.this.incomingAbort();
            }
            if (actionEvent.getSource() == ADialogEx.this.m_oDiscardButton) {
                ADialogEx.this.incomingDiscard();
            }
        }
    }

    private class CWindowListener
    extends WindowAdapter {
        @Override
        public void windowOpened(WindowEvent windowEvent) {
            ADialogEx.this.removeWindowListener(this);
            GUIHelper.focusComponent((Component)this._getFocusedComponent());
            GUIHelper.centerWindow((Window)ADialogEx.this);
        }

        private Component _getFocusedComponent() {
            Component component = ADialogEx.this.getDefaultComponent();
            if (component != null) {
                return component;
            }
            for (Component component2 : ADialogEx.this.getContentPanel().getComponents()) {
                if (!component2.isFocusable()) continue;
                return component2;
            }
            return ADialogEx.this.m_oOkButton;
        }
    }

    private class CSpecialKeyHandler
    extends AbstractAction {
        private boolean m_bIsOkAction;

        CSpecialKeyHandler(boolean bl) {
            this.m_bIsOkAction = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.m_bIsOkAction) {
                ADialogEx.this.incomingSubmit();
            } else {
                ADialogEx.this.incomingAbort();
            }
        }
    }

    private static class CKeyConsumer
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public static enum EReturnValue {
        OK,
        CANCEL,
        DISCARDED;

    }
}

