/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view.dialogs.project;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.model.CProjectImpl;
import com.mayastudios.fred.client.model.CTaskImpl;
import com.mayastudios.fred.client.model.ProjectList;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.view.dialogs.ADialogEx;
import com.mayastudios.ixml.common.SystemInfo;
import de.wb.view.CURLComboBox;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class CDlgProjectBroadcastProject
extends ADialogEx
implements ItemListener {
    private static final int LABEL_WIDTH = SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 60 : 80;
    private static final int ELEMENT_GAP = 10;
    private static final int DIALOG_WIDTH = SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 400 : 450;
    private JComboBox m_oProjectComboBox = null;
    private CURLComboBox m_oURLComboBox = null;
    private URL m_oSelectedURL = null;
    private JList m_oTaskList = null;
    private JScrollPane m_oTaskListScrollPane = null;
    private CProjectImpl m_oCurrentlySelectedProject = null;
    private Vector<CTaskImpl> m_oSelectedTaskVector = null;

    public CDlgProjectBroadcastProject(CProjectImpl cProjectImpl, CTaskImpl cTaskImpl, boolean bl) {
        super((JFrame)MainController.getInstance().getMainWindow(), Labels.get(!bl ? "CDLGPROJECTBROADCASTPROJECT" : "CDLGPROJECTBROADCASTTASK", new Object[0]), Labels.get(!bl ? "CDLGPROJECTBROADCASTPROJECT_SUBTITLE" : "CDLGPROJECTBROADCASTTASK_SUBTITLE", new Object[0]), "images/dialog-icon-project-server.png", false, Labels.get("BUTTON_BROADCAST", new Object[0]), 3, new Dimension(DIALOG_WIDTH, 260));
        this.getContentPanel().setLayout(null);
        JLabel jLabel = this.addLabel(Labels.get("PROJECT", new Object[0]), this.getContentPanel(), true, 0, 0, LABEL_WIDTH, 20);
        this.m_oProjectComboBox = !bl ? this.addComboBox(this.getContentPanel(), ProjectList.getInstance().getBroadcastableProjects(), LABEL_WIDTH + 10, 0, DIALOG_WIDTH - (LABEL_WIDTH + 10), 20) : this.addComboBox(this.getContentPanel(), ProjectList.getInstance().getBroadcastedProjects(), LABEL_WIDTH + 10, 0, DIALOG_WIDTH - (LABEL_WIDTH + 10), 20);
        if (cProjectImpl == null && this.m_oProjectComboBox.getModel().getSize() > 0) {
            this.m_oProjectComboBox.setSelectedIndex(0);
        } else {
            this.m_oProjectComboBox.setSelectedItem(cProjectImpl);
        }
        this.m_oCurrentlySelectedProject = (CProjectImpl)this.m_oProjectComboBox.getSelectedItem();
        this.m_oProjectComboBox.addItemListener(this);
        jLabel = this.addLabel(Labels.get("AVAILABLE_TASKS", new Object[0]), this.getContentPanel(), true, 0, 30, 200, 20);
        Vector<CTaskImpl> vector = new Vector<CTaskImpl>();
        if (this.m_oCurrentlySelectedProject != null) {
            Iterator<CTaskImpl> iterator = this.m_oCurrentlySelectedProject.getTaskIterator();
            while (iterator.hasNext()) {
                CTaskImpl cTaskImpl2 = iterator.next();
                if (cTaskImpl2.isTeamTask()) continue;
                vector.add(cTaskImpl2);
            }
        }
        this.m_oTaskList = this.addList(vector);
        this.m_oTaskList.setSelectionMode(2);
        if (cTaskImpl != null) {
            this.m_oTaskList.setSelectedValue(cTaskImpl, true);
        }
        this.m_oTaskListScrollPane = new JScrollPane(this.m_oTaskList);
        this.m_oTaskListScrollPane.setBounds(0, 50, DIALOG_WIDTH, 180);
        this.getContentPanel().add(this.m_oTaskListScrollPane);
        jLabel = this.addLabel(Labels.get("SERVER_URL", new Object[0]), this.getContentPanel(), true, 0, 240, LABEL_WIDTH, 20);
        this.m_oURLComboBox = this.addURLComboBox(this.getContentPanel(), MainController.getInstance().getURLList().getURLVector(), jLabel, LABEL_WIDTH + 10, 240, DIALOG_WIDTH - (LABEL_WIDTH + 10), 20);
        if (this.m_oCurrentlySelectedProject != null && this.m_oCurrentlySelectedProject.getServerURL() != null) {
            this.m_oURLComboBox.setSelectedItem(this.m_oCurrentlySelectedProject.getServerURL());
        }
    }

    @Override
    public boolean onOK() {
        this.m_oSelectedURL = null;
        if (this.evaluateValidationList(true, true) != null) {
            return false;
        }
        if (this.m_oProjectComboBox.getSelectedItem() == null) {
            this.setErrorText(Labels.get("INVALID_INPUT_NOTIFICATION_SHORT", new Object[0]));
            return false;
        }
        this.m_oSelectedURL = this.m_oURLComboBox.getCurrentSelectionAsURL();
        Object[] objectArray = null;
        objectArray = this.m_oTaskList.getSelectedValues();
        if (this.m_oSelectedTaskVector == null) {
            this.m_oSelectedTaskVector = new Vector();
        } else {
            this.m_oSelectedTaskVector.removeAllElements();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.m_oSelectedTaskVector.addElement((CTaskImpl)objectArray[i]);
        }
        return true;
    }

    public CProjectImpl getSelectedProject() {
        return this.m_oCurrentlySelectedProject;
    }

    public URL getSelectedURL() {
        return this.m_oSelectedURL;
    }

    public Vector<CTaskImpl> getSelectedTaskList() {
        return this.m_oSelectedTaskVector;
    }

    private void refreshTaskList(CProjectImpl cProjectImpl) {
        DefaultListModel defaultListModel = null;
        if (cProjectImpl == null || this.m_oTaskList == null) {
            return;
        }
        this.m_oCurrentlySelectedProject = cProjectImpl;
        defaultListModel = (DefaultListModel)this.m_oTaskList.getModel();
        defaultListModel.clear();
        Iterator<CTaskImpl> iterator = this.m_oCurrentlySelectedProject.getTaskIterator();
        while (iterator.hasNext()) {
            CTaskImpl cTaskImpl = iterator.next();
            if (cTaskImpl.isTeamTask()) continue;
            defaultListModel.addElement(cTaskImpl);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        CProjectImpl cProjectImpl = null;
        if (itemEvent.getStateChange() == 1) {
            this.m_oCurrentlySelectedProject = cProjectImpl = (CProjectImpl)((JComboBox)itemEvent.getSource()).getSelectedItem();
            this.refreshTaskList(cProjectImpl);
        }
        if (itemEvent.getStateChange() == 2) {
            // empty if block
        }
    }
}

