/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view.dialogs.project;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.model.CProjectImpl;
import com.mayastudios.fred.client.model.ProjectList;
import com.mayastudios.fred.client.resources.DateTime;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.resources.StringFunctions;
import com.mayastudios.fred.client.view.dialogs.ADialogEx;
import com.mayastudios.fred.client.view.dialogs.textfields.CNonEmptyTextfield;
import com.mayastudios.mscl.mwt.widgets.button.CFlatButtonBorder;
import de.wb.view.CURLComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class CDlgProjectProperties
extends ADialogEx {
    private CNonEmptyTextfield m_oNameTextfield = null;
    private JTextArea m_oCommentTextArea = null;
    private JCheckBox m_oClosedCheckBox = null;
    private CURLComboBox m_oURLComboBox = null;
    private CProjectImpl m_oProject;

    public CDlgProjectProperties(CProjectImpl cProjectImpl) {
        super((JFrame)MainController.getInstance().getMainWindow(), Labels.get("CDLGPROJECTPROPERTIES", new Object[0]), Labels.get(cProjectImpl.isClosed() ? "CDLGPROJECTPROPERTIES_SUBTITLE" : "CDLGPROJECTPROPERTIES_SUBTITLE_EDIT", new Object[0]), "images/dialog-icon-project.png", true, !cProjectImpl.isClosed() ? ADialogEx.OK_BUTTON_TEXT.toString() : ADialogEx.CLOSE_BUTTON_TEXT.toString(), !cProjectImpl.isClosed() ? 3 : 1, new Dimension(485, 270));
        this.m_oProject = cProjectImpl;
        this.getContentPanel().setLayout(null);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        JLabel jLabel = this.addLabel(Labels.get("NAME", new Object[0]), jPanel, true, 10, 20, 100, 20);
        this.m_oNameTextfield = this.addNonEmptyTextfield(jPanel, jLabel, 140, 20, 330, 20);
        this.m_oNameTextfield.setText(cProjectImpl.getName());
        if (!cProjectImpl.isClosed() && !cProjectImpl.isTeamProject()) {
            this.m_oNameTextfield.setEditable(true);
        } else {
            this.m_oNameTextfield.setEditable(false);
        }
        jLabel = this.addLabel(Labels.get("DESCRIPTION", new Object[0]), jPanel, true, 10, 50, 100, 20);
        this.m_oCommentTextArea = super.addTextarea(jPanel, true, 140, 50, 330, 80);
        this.m_oCommentTextArea.setLineWrap(true);
        this.m_oCommentTextArea.setWrapStyleWord(true);
        this.m_oCommentTextArea.setText(cProjectImpl.getDescription());
        this.m_oCommentTextArea.setEditable(!cProjectImpl.isClosed());
        jLabel = this.addLabel(Labels.get("PROJECT_CLOSED", new Object[0]), jPanel, true, 10, 140, 130, 20);
        this.m_oClosedCheckBox = this.addCheckBox(null, jPanel, jLabel, 140, 143);
        this.m_oClosedCheckBox.setSelected(cProjectImpl.isClosed());
        this.m_oClosedCheckBox.setEnabled(false);
        if (!cProjectImpl.isClosed()) {
            if (!cProjectImpl.isTeamProject()) {
                this.m_oClosedCheckBox.setEnabled(true);
            } else if (cProjectImpl.isUserProjectLeader()) {
                this.m_oClosedCheckBox.setEnabled(true);
            }
        }
        jLabel = this.addLabel(Labels.get("PROJECT_TYPE", new Object[0]), jPanel, true, 10, 170, 100, 20);
        if (cProjectImpl.isSubscibed()) {
            this.addLabel(Labels.get("PROJECT_TYPE_TEAM_SUBSCRIBED", new Object[0]), jPanel, false, 140, 170, 150, 20);
        } else if (cProjectImpl.isBroadcasted()) {
            this.addLabel(Labels.get("PROJECT_TYPE_TEAM_BROADCASTED", new Object[0]), jPanel, false, 140, 170, 150, 20);
        } else {
            this.addLabel(Labels.get("PROJECT_TYPE_SINGLE", new Object[0]), jPanel, false, 140, 170, 150, 20);
        }
        jLabel = this.addLabel(Labels.get("SERVER_URL", new Object[0]), jPanel, true, 10, 200, 100, 20);
        this.m_oURLComboBox = this.addURLComboBox(jPanel, MainController.getInstance().getURLList().getURLVector(), jLabel, 140, 200, 330, 20, true);
        if (!cProjectImpl.isTeamProject()) {
            this.m_oURLComboBox.setEnabled(false);
            this.m_oURLComboBox.setSelectedItem("");
            this.m_oURLComboBox.setToolTipText(Labels.get("NO_URL_DUE_SINGLEPROJECT", new Object[0]));
            jLabel.setToolTipText(Labels.get("NO_URL_DUE_SINGLEPROJECT", new Object[0]));
        } else {
            this.m_oURLComboBox.setEnabled(true);
            this.m_oURLComboBox.setAllowEmptyContent(false);
            if (cProjectImpl.getServerURL() != null) {
                this.m_oURLComboBox.setSelectedItem(cProjectImpl.getServerURL());
            } else {
                this.m_oURLComboBox.setSelectedItem("");
            }
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder((Border)new CFlatButtonBorder(CFlatButtonBorder.EState.LOWERED));
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 100);
        TableColumn tableColumn2 = new TableColumn(1, 200);
        tableColumn.setHeaderValue(Labels.get("ATTRIBUTE", new Object[0]));
        tableColumn2.setHeaderValue(Labels.get("VALUE", new Object[0]));
        defaultTableColumnModel.addColumn(tableColumn);
        defaultTableColumnModel.addColumn(tableColumn2);
        CPropertiesTableModel cPropertiesTableModel = new CPropertiesTableModel();
        cPropertiesTableModel.setDataSource(cProjectImpl);
        JTable jTable = new JTable(cPropertiesTableModel, defaultTableColumnModel);
        JTableHeader jTableHeader = jTable.getTableHeader();
        jPanel2.add((Component)jTableHeader, "North");
        jPanel2.add((Component)jTable, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(null);
        jPanel2.setBounds(10, 10, 465, jPanel2.getPreferredSize().height);
        jPanel3.add(jPanel2);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.setOpaque(false);
        jTabbedPane.addTab(Labels.get("COMMON", new Object[0]), jPanel);
        jPanel3.setOpaque(false);
        jTabbedPane.addTab(Labels.get("STATISTICS", new Object[0]), jPanel3);
        jTabbedPane.setBounds(0, 0, 485, 270);
        this.getContentPanel().add(jTabbedPane);
    }

    public boolean isClosed() {
        return this.m_oClosedCheckBox.isSelected();
    }

    @Override
    public boolean onOK() {
        if (this.evaluateValidationList(true, true) != null) {
            return false;
        }
        String string = StringFunctions.isNameValid(this.m_oNameTextfield.getText());
        if (string != null) {
            this.setErrorText(string);
            return false;
        }
        if (!ProjectList.getInstance().isProjectNameValid(this.m_oProject, this.m_oNameTextfield.getText())) {
            this.setErrorText(Labels.get("MSG_DUPLICATE_PROJECT_NAME", new Object[0]));
            return false;
        }
        this.m_oProject.setName(this.m_oNameTextfield.getText());
        this.m_oProject.setDescription(this.m_oCommentTextArea.getText());
        if (this.m_oProject.isTeamProject()) {
            URL uRL = this.m_oURLComboBox.getCurrentSelectionAsURL();
            this.m_oProject.setServerURL(uRL);
        }
        return true;
    }

    class CPropertiesTableModel
    extends AbstractTableModel {
        private static final int PROP_CREATED_AT = 0;
        private static final int PROP_LAST_COLLECT_AT = 1;
        private static final int PROP_CLOSED_AT = 2;
        private static final int PROP_SUBSCRIBED_AT = 3;
        private static final int PROP_TASK_COUNT = 4;
        private static final int PROP_EFFORT_COUNT = 5;
        private static final int PROP_REPLICATEDEFFORT_COUNT = 6;
        private static final int PROP_NOTREPLICATEDEFFORT_COUNT = 7;
        private static final int PROP_ACCEPTED_EFFORT_COUNT = 8;
        private static final int PROP_NOTYETACCEPTED_EFFORT_COUNT = 9;
        private static final int PROP_NOTACCEPTED_EFFORT_COUNT = 10;
        private static final int PROP_ACCUMULATED_DURATION = 11;
        String[][] m_aData = new String[][]{{Labels.get("PROP_CREATED_AT", new Object[0]), null}, {Labels.get("PROP_LAST_COLLECT_AT", new Object[0]), null}, {Labels.get("PROP_CLOSED_AT", new Object[0]), null}, {Labels.get("PROP_SUBSCRIBED_AT", new Object[0]), null}, {Labels.get("PROP_TASK_COUNT", new Object[0]), null}, {Labels.get("PROP_EFFORT_COUNT", new Object[0]), null}, {Labels.get("PROP_REPLICATEDEFFORT_COUNT", new Object[0]), null}, {Labels.get("PROP_NOTREPLICATEDEFFORT_COUNT", new Object[0]), null}, {Labels.get("PROP_ACCEPTED_EFFORT_COUNT", new Object[0]), null}, {Labels.get("PROP_NOTYETACCEPTED_EFFORT_COUNT", new Object[0]), null}, {Labels.get("PROP_NOTACCEPTED_EFFORT_COUNT", new Object[0]), null}, {Labels.get("PROP_ACCUMULATED_DURATION", new Object[0]), null}};

        CPropertiesTableModel() {
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.m_aData[n][n2];
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.m_aData.length;
        }

        public void setDataSource(CProjectImpl cProjectImpl) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            if (cProjectImpl.getCreatedAt() != null) {
                this.m_aData[0][1] = DateTime.getDateTimeString(cProjectImpl.getCreatedAt());
            }
            if (cProjectImpl.getCollectedLastAt() != null) {
                this.m_aData[1][1] = DateTime.getDateTimeString(cProjectImpl.getCollectedLastAt());
            }
            if (cProjectImpl.getClosedAt() != null) {
                this.m_aData[2][1] = DateTime.getDateTimeString(cProjectImpl.getClosedAt());
            }
            if (cProjectImpl.getSubscribedAt() != null) {
                this.m_aData[3][1] = DateTime.getDateTimeString(cProjectImpl.getSubscribedAt());
            }
            this.m_aData[4][1] = Integer.toString(cProjectImpl.getTaskCount());
            n = cProjectImpl.getStatistic().getFieldValue(0);
            this.m_aData[5][1] = Integer.toString(n);
            n5 = cProjectImpl.getStatistic().getFieldValue(2);
            this.m_aData[6][1] = Integer.toString(n5);
            n6 = n - n5;
            this.m_aData[7][1] = Integer.toString(n6);
            n2 = cProjectImpl.getStatistic().getFieldValue(3);
            this.m_aData[8][1] = Integer.toString(n2);
            n3 = cProjectImpl.getStatistic().getFieldValue(4);
            this.m_aData[10][1] = Integer.toString(n3);
            n4 = n - n2 - n3;
            this.m_aData[9][1] = Integer.toString(n4);
            this.m_aData[11][1] = DateTime.getDurationString(cProjectImpl.getStatistic().getFieldValue(1), false);
        }
    }
}

