/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view.dialogs.quickbar;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.view.QuickBar;
import com.mayastudios.fred.client.view.dialogs.ADialogEx;
import com.mayastudios.mscl.mwt.CClockTimer;
import com.mayastudios.mscl.mwt.widgets.APaintHelperPanel;
import com.mayastudios.mscl.mwt.widgets.inputcontols.CTimeDurationEditField;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.GeneralPath;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CDlgQuickbarReallocate
extends ADialogEx {
    private JButton m_oLeftButton;
    private JButton m_oRightButton;
    private CTimeDurationEditField m_oWorkDuration;
    private CTimeDurationEditField m_oPauseDuration;
    private CTimeDurationEditField m_oTransferDuration;
    private final boolean m_bIsWorkRecording;
    private Calendar m_oLastTimerTimestamp;
    private final Calendar m_oStartTime;
    private int m_iPauseDuration;
    private int m_iPauseDurationTransfered;
    private int m_iWorkDuration;
    private int m_iWorkDurationTransfered;
    private int m_iTransferDuration;
    private final CClockTimer m_oTimer;
    private boolean m_bCurrentlyinRefreshFields;

    public CDlgQuickbarReallocate(boolean bl, Calendar calendar, int n) {
        super(CDlgQuickbarReallocate.determineParentFrame(), Labels.get("CDLGQUICKBARRESPLITTIME", new Object[0]), Labels.get("CDLGQUICKBARRESPLITTIME_SUBTITLE", new Object[0]), "images/dialog-icon-resplit.png", true, ADialogEx.OK_BUTTON_TEXT.toString(), 3, new Dimension(460, 160));
        this.m_bIsWorkRecording = bl;
        this.m_oLastTimerTimestamp = Calendar.getInstance();
        this.m_oStartTime = calendar;
        this.m_iPauseDurationTransfered = this.m_iPauseDuration = n;
        this.m_iWorkDurationTransfered = this.m_iWorkDuration = QuickBar.calcWorkDuration(this.m_oStartTime, this.m_iPauseDuration);
        this.m_iTransferDuration = 0;
        this.m_bCurrentlyinRefreshFields = false;
        this.createControls();
        this.refreshFields();
        CUpdateTransferListener cUpdateTransferListener = new CUpdateTransferListener();
        this.m_oTransferDuration.addChangeListener((ChangeListener)cUpdateTransferListener);
        this.m_oTransferDuration.addFocusListener((FocusListener)cUpdateTransferListener);
        CUpdateDurationListener cUpdateDurationListener = new CUpdateDurationListener();
        this.m_oWorkDuration.addChangeListener((ChangeListener)cUpdateDurationListener);
        this.m_oWorkDuration.addFocusListener((FocusListener)cUpdateDurationListener);
        this.m_oPauseDuration.addChangeListener((ChangeListener)cUpdateDurationListener);
        this.m_oPauseDuration.addFocusListener((FocusListener)cUpdateDurationListener);
        this.m_oTimer = new CClockTimer((ActionListener)new CUpdateTimerListener());
        this.m_oTimer.start();
    }

    private static JFrame determineParentFrame() {
        if (!MainController.getInstance().getMainWindow().isVisible() || MainController.getInstance().getMainWindow().getExtendedState() == 1) {
            return null;
        }
        return MainController.getInstance().getMainWindow();
    }

    public int getPauseDuration() {
        return this.m_iPauseDurationTransfered;
    }

    public Calendar getStartTime() {
        return this.m_oStartTime;
    }

    @Override
    protected boolean onOK() {
        return true;
    }

    void createControls() {
        JPanel jPanel = super.getContentPanel();
        JPanel jPanel2 = super.addBorderedPanel(Labels.get("Text.WorkTime", new Object[0]), jPanel, 0, 0, 190, 50);
        this.m_oWorkDuration = super.addTimeDurationTextfield(jPanel2, true, 10, 20, 80);
        super.addLabel("hh:mm:ss", jPanel2, false, 100, 19, 80, 20);
        jPanel2 = super.addBorderedPanel(Labels.get("Text.BreakTime", new Object[0]), jPanel, 270, 0, 190, 50);
        this.m_oPauseDuration = super.addTimeDurationTextfield(jPanel2, true, 10, 20, 80);
        super.addLabel("hh:mm:ss", jPanel2, false, 100, 19, 90, 20);
        jPanel2 = super.addBorderedPanel(Labels.get("CDLGQUICKBARRESPLITTIME.Reallocate", new Object[0]), jPanel, 135, 80, 190, 80);
        this.m_oLeftButton = super.addButtonWithIcon("images/arrow-left.png", "Links", new CButtonListener(), jPanel2, 10, 20, 170);
        this.m_oRightButton = super.addButtonWithIcon("images/arrow-right.png", "Rechts", new CButtonListener(), jPanel2, 10, 20, 170);
        this.m_oTransferDuration = super.addTimeDurationTextfield(jPanel2, true, 10, 50, 80);
        super.addLabel("hh:mm:ss", jPanel2, false, 100, 49, 80, 20);
        this.setDirection(true);
        CConnector cConnector = new CConnector(true);
        cConnector.setBounds(60, 50, 90, 75);
        jPanel.add((Component)((Object)cConnector));
        cConnector = new CConnector(false);
        cConnector.setBounds(310, 50, 90, 75);
        jPanel.add((Component)((Object)cConnector));
    }

    void refreshFields() {
        this.m_bCurrentlyinRefreshFields = true;
        if (this.m_iPauseDurationTransfered != this.m_oPauseDuration.getSecondsCount()) {
            this.m_oPauseDuration.setSecondsCount(this.m_iPauseDurationTransfered);
        }
        if (this.m_iWorkDurationTransfered != this.m_oWorkDuration.getSecondsCount()) {
            this.m_oWorkDuration.setSecondsCount(this.m_iWorkDurationTransfered);
        }
        if (this.m_iTransferDuration != this.m_oTransferDuration.getSecondsCount()) {
            this.m_oTransferDuration.setSecondsCount(this.m_iTransferDuration);
        }
        this.m_bCurrentlyinRefreshFields = false;
    }

    synchronized void updateAfertTimerSignal() {
        this.m_oLastTimerTimestamp = Calendar.getInstance();
        if (this.m_bIsWorkRecording) {
            this.m_iWorkDuration = QuickBar.calcWorkDuration(this.m_oStartTime, this.m_iPauseDuration);
        } else {
            this.m_iPauseDuration = QuickBar.calcWorkDuration(this.m_oStartTime, this.m_iWorkDuration);
        }
        this.updateAfterTransferChange();
    }

    synchronized void updateAfterDurationChange() {
        if (this.m_bCurrentlyinRefreshFields) {
            return;
        }
        this.m_iWorkDuration += this.m_oWorkDuration.getSecondsCount() - this.m_iWorkDurationTransfered;
        this.m_iPauseDuration += this.m_oPauseDuration.getSecondsCount() - this.m_iPauseDurationTransfered;
        this.m_oStartTime.setTimeInMillis(this.m_oLastTimerTimestamp.getTimeInMillis() - (long)((this.m_iWorkDuration + this.m_iPauseDuration) * 1000));
        this.updateAfterTransferChange();
    }

    synchronized void updateAfterTransferChange() {
        if (this.m_bCurrentlyinRefreshFields) {
            return;
        }
        this.m_iTransferDuration = this.m_oTransferDuration.getSecondsCount();
        if (this.isDirectionToWorkDuration()) {
            if (this.m_iPauseDuration < this.m_iTransferDuration) {
                this.m_iTransferDuration = this.m_iPauseDuration;
            }
            this.m_iWorkDurationTransfered = this.m_iWorkDuration + this.m_iTransferDuration;
            this.m_iPauseDurationTransfered = this.m_iPauseDuration - this.m_iTransferDuration;
        } else {
            if (this.m_iWorkDuration < this.m_iTransferDuration) {
                this.m_iTransferDuration = this.m_iWorkDuration;
            }
            this.m_iWorkDurationTransfered = this.m_iWorkDuration - this.m_iTransferDuration;
            this.m_iPauseDurationTransfered = this.m_iPauseDuration + this.m_iTransferDuration;
        }
        this.refreshFields();
    }

    void setDirection(boolean bl) {
        this.m_oLeftButton.setVisible(bl);
        this.m_oRightButton.setVisible(!bl);
        this.updateAfterTransferChange();
    }

    boolean isDirectionToWorkDuration() {
        return this.m_oLeftButton.isVisible();
    }

    class CConnector
    extends APaintHelperPanel {
        private static final int LINE_WIDTH = 3;
        private final BasicStroke m_oStroke = new BasicStroke(3.0f, 0, 1);
        private final boolean m_bLeftConnector;

        CConnector(boolean bl) {
            this.m_bLeftConnector = bl;
        }

        protected void paintComponent(Graphics2D graphics2D) {
            Dimension dimension = this.getSize();
            GeneralPath generalPath = new GeneralPath();
            super.paintComponent(graphics2D);
            if (this.m_bLeftConnector) {
                generalPath.moveTo(3.0f, 3.0f);
                generalPath.lineTo(3.0f, dimension.height - 3 - 1);
                generalPath.lineTo(dimension.width - 3 - 1, dimension.height - 3 - 1);
            } else {
                generalPath.moveTo(dimension.width - 3 - 1, 3.0f);
                generalPath.lineTo(dimension.width - 3 - 1, dimension.height - 3 - 1);
                generalPath.lineTo(3.0f, dimension.height - 3 - 1);
            }
            graphics2D.setColor(Color.BLACK);
            graphics2D.setStroke(this.m_oStroke);
            graphics2D.draw(generalPath);
        }
    }

    class CUpdateDurationListener
    extends FocusAdapter
    implements ChangeListener {
        CUpdateDurationListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            CDlgQuickbarReallocate.this.updateAfterDurationChange();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            CDlgQuickbarReallocate.this.updateAfterDurationChange();
        }
    }

    class CUpdateTransferListener
    extends FocusAdapter
    implements ChangeListener {
        CUpdateTransferListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            CDlgQuickbarReallocate.this.updateAfterTransferChange();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            CDlgQuickbarReallocate.this.updateAfterTransferChange();
        }
    }

    class CUpdateTimerListener
    implements ActionListener {
        CUpdateTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CDlgQuickbarReallocate.this.updateAfertTimerSignal();
        }
    }

    class CButtonListener
    implements ActionListener {
        CButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CDlgQuickbarReallocate.this.setDirection(!CDlgQuickbarReallocate.this.isDirectionToWorkDuration());
        }
    }
}

