/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.commands;

import com.mayastudios.ixml.commands.base.Command;
import com.mayastudios.ixml.common.IXMLError;
import com.mayastudios.ixml.common.LabelCaption;
import com.mayastudios.ixml.common.SimplifiedSAXParser;
import com.mayastudios.ixml.document.comp.AttributeParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCommandController<EnableType>
implements Command.ICommandController<EnableType> {
    private static final String SCHEMA_SOURCE_NAME = "commandlist.xsd";
    private static final SimplifiedSAXParser SAX_PARSER;
    private final Class<EnableType> mf_oEnableTypeClass;
    private final String mf_strInvokePrefix;
    private final String mf_strToggleStatePrefix;

    public BaseCommandController(Class<EnableType> p_oEnableTypeClass, String p_strInvokePrefix, String p_strToggleStatePrefix) {
        this.mf_oEnableTypeClass = p_oEnableTypeClass;
        this.mf_strInvokePrefix = p_strInvokePrefix;
        this.mf_strToggleStatePrefix = p_strToggleStatePrefix;
    }

    @Override
    public final String getInvokePrefix() {
        return this.mf_strInvokePrefix;
    }

    @Override
    public final String getToggleStatePrefix() {
        return this.mf_strToggleStatePrefix;
    }

    @Override
    public final Class<EnableType> getEnableTypeClass() {
        return this.mf_oEnableTypeClass;
    }

    protected List<Command<EnableType>> loadCommands(InputStream p_oXIMLDataStream) throws SAXException, IOException {
        CommandsHandler oHandler = new CommandsHandler();
        SAX_PARSER.parse(p_oXIMLDataStream, (DefaultHandler)((Object)oHandler));
        return oHandler.mf_oCommandList;
    }

    static {
        URL oSchemaURL = BaseCommandController.class.getResource(SCHEMA_SOURCE_NAME);
        if (oSchemaURL == null) {
            throw new ExceptionInInitializerError("Could not find labels schema file.");
        }
        SAX_PARSER = new SimplifiedSAXParser(oSchemaURL);
    }

    private class CommandsHandler
    extends SimplifiedSAXParser.SimplifiedDefaultHandler {
        private static final String COMMAND_TAG = "command";
        private static final String ID_ATTRIB = "id";
        private static final String CAPTION_ATTRIB = "caption";
        private static final String ACCELERATOR_ATTRIB = "accelerator";
        private static final String ENABLED_ATTRIB = "enabled";
        private static final String ICON_ATTRIB = "icon";
        private static final String TOGGLE_ATTRIB = "toggleCommand";
        public final LinkedList<Command<EnableType>> mf_oCommandList = new LinkedList();

        private CommandsHandler() {
        }

        public void startElement(String p_strTagName, Attributes p_oAttributes) throws SAXException {
            if (!COMMAND_TAG.equals(p_strTagName)) {
                return;
            }
            LabelCaption oCaption = new LabelCaption(p_oAttributes.getValue(CAPTION_ATTRIB));
            URL oIconURL = null;
            try {
                oIconURL = AttributeParser.parseResourceURL(p_oAttributes.getValue(ICON_ATTRIB));
            }
            catch (IXMLError oException) {
                throw new SAXException((Exception)((Object)oException));
            }
            ImageIcon oIcon = null;
            if (oIconURL != null) {
                oIcon = new ImageIcon(oIconURL);
            }
            KeyStroke oAccelerator = null;
            try {
                oAccelerator = AttributeParser.parseAccelerator(p_oAttributes.getValue(ACCELERATOR_ATTRIB));
            }
            catch (AttributeParser.InvalidAcceleratorException oException) {
                BaseCommandController.this.error(oException.getMessage());
            }
            Command oCommand = new Command(BaseCommandController.this, p_oAttributes.getValue(ID_ATTRIB), oCaption, oIcon, p_oAttributes.getValue(ENABLED_ATTRIB), oAccelerator, Boolean.parseBoolean(p_oAttributes.getValue(TOGGLE_ATTRIB)));
            this.mf_oCommandList.add(oCommand);
        }
    }
}

