/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.common;

import com.mayastudios.ixml.labels.LString;
import com.mayastudios.ixml.labels.LabelsCore;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LabelCaption {
    private static final Pattern SEARCH_PATTERN = Pattern.compile("(\\^[^\\^]*\\^)|(\\^[^\\^]*)$");
    private final String mf_strFormatString;
    private final Object[] mf_aoUsedLabels;

    public LabelCaption(String p_strLabel) {
        if (p_strLabel == null) {
            this.mf_strFormatString = "";
            this.mf_aoUsedLabels = null;
            return;
        }
        if (p_strLabel.length() <= 1 || p_strLabel.charAt(0) != '^') {
            this.mf_strFormatString = p_strLabel;
            this.mf_aoUsedLabels = null;
            return;
        }
        LinkedList<LString> oLabelList = new LinkedList<LString>();
        StringBuilder oFormatString = new StringBuilder(128);
        int iOrigIndex = 0;
        Matcher oMatcher = SEARCH_PATTERN.matcher(p_strLabel);
        while (oMatcher.find()) {
            int iStart = oMatcher.start();
            int iEnd = oMatcher.end();
            oFormatString.append(p_strLabel, iOrigIndex, iStart);
            if (iStart + 2 == iEnd) {
                oFormatString.append('^');
            } else {
                LString oLabel = p_strLabel.charAt(iEnd - 1) == '^' ? LabelsCore.getLS((String)p_strLabel.substring(iStart + 1, iEnd - 1)) : LabelsCore.getLS((String)p_strLabel.substring(iStart + 1, iEnd));
                oFormatString.append("%s");
                oLabelList.add(oLabel);
            }
            iOrigIndex = iEnd;
        }
        oFormatString.append(p_strLabel.substring(iOrigIndex));
        this.mf_strFormatString = oFormatString.toString();
        this.mf_aoUsedLabels = oLabelList.size() == 0 ? null : oLabelList.toArray();
    }

    public String toString() {
        if (this.mf_aoUsedLabels == null) {
            return this.mf_strFormatString;
        }
        return String.format(this.mf_strFormatString, this.mf_aoUsedLabels);
    }
}

