/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.document;

import com.mayastudios.ixml.common.IXMLError;
import com.mayastudios.ixml.common.IXMLException;
import com.mayastudios.ixml.document.DocumentCompFactory;
import com.mayastudios.ixml.document.IXMLDialog;
import com.mayastudios.ixml.document.IXMLDocument;
import com.mayastudios.ixml.document.comp.base.IDContainer;
import com.mayastudios.ixml.document.parser.IXMLParser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JFrame;

public abstract class IXMLModalDialog
extends IXMLDialog
implements IDContainer.IIDContainer {
    public static final String IDOK = "IDOK";
    public static final String IDCANCEL = "IDCANCEL";
    private EReturnValue m_eReturnValue = null;

    public IXMLModalDialog(InputStream p_oIXMLStream, DocumentCompFactory p_oComponentFactory, JFrame p_oOwner) throws IXMLError, IXMLException {
        this(IXMLParser.parseIXML(p_oIXMLStream), p_oComponentFactory, p_oOwner);
    }

    public IXMLModalDialog(IXMLDocument p_oIXMLDocument, DocumentCompFactory p_oComponentFactory, JFrame p_oOwner) throws IXMLError, IXMLException {
        super(p_oIXMLDocument, p_oComponentFactory, p_oOwner, true);
        Component oButton = this.getComponentByID(IDOK);
        if (oButton instanceof JButton) {
            ((JButton)oButton).addActionListener(new ButtonListener(EReturnValue.OK));
        }
        if ((oButton = this.getComponentByID(IDCANCEL)) instanceof JButton) {
            ((JButton)oButton).addActionListener(new ButtonListener(EReturnValue.CANCEL));
        }
        this.addWindowListener(new CloseListener());
    }

    protected abstract boolean onOK();

    protected boolean onCancel() {
        return true;
    }

    public void closeDialog(EReturnValue p_eReturnValue) {
        switch (p_eReturnValue) {
            case OK: {
                if (this.onOK()) break;
                return;
            }
            case CANCEL: {
                if (this.onCancel()) break;
                return;
            }
            default: {
                throw new IllegalStateException("Invalid return value");
            }
        }
        this.m_eReturnValue = p_eReturnValue;
        super.setVisible(false);
        this.dispose();
    }

    @Deprecated
    public void setVisible(boolean p_bVisible) {
        super.setVisible(p_bVisible);
    }

    @Deprecated
    public void setModal(boolean p_bModal) {
        super.setModal(p_bModal);
    }

    public EReturnValue showDialog() {
        if (this.isVisible()) {
            throw new IllegalStateException("Dialog is already visible.");
        }
        if (!this.isModal()) {
            throw new IllegalStateException("The dialog must be modal.");
        }
        this.pack();
        Dimension oSize = this.getPreferredSize();
        Dimension oScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((oScreenSize.width - oSize.width) / 2, (oScreenSize.height - oSize.height) / 2);
        do {
            super.setVisible(true);
        } while (this.m_eReturnValue == null);
        return this.m_eReturnValue;
    }

    public EReturnValue getReturnValue() {
        return this.m_eReturnValue;
    }

    private class CloseListener
    extends WindowAdapter {
        private CloseListener() {
        }

        public void windowClosing(WindowEvent p_oEvent) {
            IXMLModalDialog.this.closeDialog(EReturnValue.CANCEL);
        }
    }

    private class ButtonListener
    implements ActionListener {
        private final EReturnValue mf_eReturnValue;

        public ButtonListener(EReturnValue p_eReturnValue) {
            this.mf_eReturnValue = p_eReturnValue;
        }

        public void actionPerformed(ActionEvent p_oEvent) {
            IXMLModalDialog.this.closeDialog(this.mf_eReturnValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EReturnValue {
        OK,
        CANCEL;

    }
}

