/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.document.comp.base;

import com.mayastudios.ixml.document.comp.base.IXMLComponentContainer;
import com.mayastudios.ixml.document.comp.base.IXMLComponentGridContainer;
import java.awt.Component;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class IDContainer {
    private final HashMap<String, Component> mf_oComponentIDs = new HashMap();
    private final LinkedList<IIDContainer> mf_oContainers = new LinkedList();

    public void addID(Component p_oComponent, String p_strID) {
        if (p_oComponent == null) {
            throw new IllegalArgumentException("The added component must not be null.");
        }
        if (p_strID != null) {
            this.mf_oComponentIDs.put(p_strID, p_oComponent);
        }
    }

    public void addSubContainer(Component p_oContainer) {
        if (p_oContainer == null) {
            throw new IllegalArgumentException("The added component must not be null.");
        }
        if (p_oContainer instanceof IIDContainer) {
            this.mf_oContainers.add((IIDContainer)((Object)p_oContainer));
        }
    }

    public void removeID(Component p_oComponent) {
        Set<Map.Entry<String, Component>> oEntries = this.mf_oComponentIDs.entrySet();
        for (Map.Entry<String, Component> oEntry : oEntries) {
            if (oEntry.getValue() != p_oComponent) continue;
            String strID = oEntry.getKey();
            if (strID == null) break;
            this.mf_oComponentIDs.remove(oEntry.getKey());
            break;
        }
    }

    public Component getComponentByID(String p_strID, boolean p_bCanReturnComponentContainer) {
        Component oComponent = this.mf_oComponentIDs.get(p_strID);
        if (oComponent != null) {
            if (oComponent instanceof IXMLComponentContainer) {
                return ((IXMLComponentContainer)oComponent).getComponent();
            }
            return oComponent;
        }
        for (IIDContainer oContainer : this.mf_oContainers) {
            oComponent = oContainer.getComponentByID(p_strID, p_bCanReturnComponentContainer);
            if (oComponent == null) continue;
            if (oComponent instanceof IXMLComponentGridContainer) {
                return ((IXMLComponentGridContainer)oComponent).getComponent();
            }
            if (!p_bCanReturnComponentContainer && oComponent instanceof IXMLComponentContainer) {
                return ((IXMLComponentContainer)oComponent).getComponent();
            }
            return oComponent;
        }
        return oComponent;
    }

    public void removeSubContainer(Component p_oContainer) {
        if (p_oContainer instanceof IIDContainer) {
            this.mf_oContainers.remove(p_oContainer);
        }
    }

    public static interface IIDContainer {
        public Component getComponentByID(String var1);

        public Component getComponentByID(String var1, boolean var2);
    }
}

