/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.document.comp.base;

import com.mayastudios.ixml.common.IXMLError;
import com.mayastudios.ixml.common.IXMLException;
import com.mayastudios.ixml.document.comp.IXMLSeparatorNode;
import com.mayastudios.ixml.document.comp.IXMLSpacerNode;
import com.mayastudios.ixml.document.comp.base.EIXMLAttrib;
import com.mayastudios.ixml.document.comp.base.EIXMLType;
import com.mayastudios.ixml.document.comp.base.IXMLBaseElement;
import com.mayastudios.ixml.document.comp.base.IXMLComponentContainer;
import com.mayastudios.ixml.document.comp.flexlayout.FlexLayout;
import com.mayastudios.ixml.document.comp.impl.FlexPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IXMLBaseContainer
extends IXMLBaseElement {
    public IXMLBaseContainer(EIXMLType p_eType, String p_strID) {
        super(p_eType, p_strID, true);
    }

    public FlexPanel createContainer(IXMLBaseElement.InfoStack p_oInfoStack, IXMLBaseElement.CreateInfo p_oCreateInfo) throws IXMLError, IXMLException {
        boolean bIsVerticalBox = this.getAttributeAsOption(EIXMLAttrib.ORIENT) != EIXMLAttrib.ORIENT_VALUE_HORIZONTAL;
        FlexPanel oPanel = new FlexPanel(bIsVerticalBox);
        this.fillBox(oPanel, bIsVerticalBox, p_oInfoStack, p_oCreateInfo);
        return oPanel;
    }

    protected void fillBox(FlexPanel p_oPanel, boolean p_bIsVerticalBox, IXMLBaseElement.InfoStack p_oInfoStack, IXMLBaseElement.CreateInfo p_oCreateInfo) throws IXMLError, IXMLException {
        LinkedList<BoxComponent> oElementList = IXMLBaseContainer.createBoxComponents(this.getChildElements(), p_bIsVerticalBox, p_oInfoStack, p_oCreateInfo);
        for (BoxComponent oComponent : oElementList) {
            Object oConstraint = oComponent.mf_iSpacing == -1 ? Integer.valueOf(oComponent.mf_iFlexValue) : new FlexLayout.FlexConstraint(oComponent.mf_iFlexValue, oComponent.mf_iSpacing);
            p_oPanel.add((Component)oComponent.mf_oComponent, oConstraint, oComponent.mf_oElement.getID());
        }
    }

    protected static LinkedList<BoxComponent> createBoxComponents(List<IXMLBaseElement> p_oChildElements, boolean p_bIsVerticalBox, IXMLBaseElement.InfoStack p_oInfoStack, IXMLBaseElement.CreateInfo p_oCreateInfo) throws IXMLError, IXMLException {
        LinkedList<BoxComponent> oElementList = new LinkedList<BoxComponent>();
        block5: for (IXMLBaseElement oElement : p_oChildElements) {
            switch (oElement.getType()) {
                case SPACER: {
                    Box.Filler oSpacer = ((IXMLSpacerNode)oElement).createSpacer(p_bIsVerticalBox);
                    IXMLBaseContainer.setComponentSize(oSpacer, oElement.getAttributeAsInt(EIXMLAttrib.WIDTH, p_bIsVerticalBox ? 0 : 7), oElement.getAttributeAsInt(EIXMLAttrib.HEIGHT, p_bIsVerticalBox ? 7 : 0));
                    oElementList.add(new BoxComponent(oSpacer, oElement.getAttributeAsInt(EIXMLAttrib.FLEX), null, oElement));
                    continue block5;
                }
                case SEPARATOR: {
                    oElementList.add(new BoxComponent(((IXMLSeparatorNode)oElement).createSeparator(p_bIsVerticalBox), 0, null, oElement));
                    continue block5;
                }
                case BOX: 
                case GRID: 
                case GROUPBOX: 
                case RADIOGROUP: 
                case TABBOX: 
                case STACK: {
                    JComponent oBox = oElement.createComponent(p_oInfoStack, p_oCreateInfo);
                    IXMLBaseContainer.setComponentOpaque(oBox, p_oInfoStack);
                    IXMLBaseContainer.setComponentSize(oBox, oElement.getAttributeAsInt(EIXMLAttrib.WIDTH), oElement.getAttributeAsInt(EIXMLAttrib.HEIGHT));
                    oElementList.add(new BoxComponent(oBox, oElement.getAttributeAsInt(EIXMLAttrib.FLEX), oElement.getAttributeAsInt(EIXMLAttrib.SPACING), oElement));
                    continue block5;
                }
            }
            IXMLComponentContainer oComponent = new IXMLComponentContainer(oElement.createComponent(p_oInfoStack, p_oCreateInfo));
            IXMLBaseContainer.setComponentOpaque(oComponent.getComponent(), p_oInfoStack);
            IXMLBaseContainer.setComponentSize(oComponent.getComponent(), oElement.getAttributeAsInt(EIXMLAttrib.WIDTH), oElement.getAttributeAsInt(EIXMLAttrib.HEIGHT));
            int iAlignment = oElement.getAttributeAsOption(EIXMLAttrib.HALIGN);
            if (iAlignment == EIXMLAttrib.HALIGN_VALUE_STRETCH) {
                oComponent.setHorzAlign(IXMLComponentContainer.EAlign.STRETCH);
            } else if (iAlignment == EIXMLAttrib.HALIGN_VALUE_CENTER) {
                oComponent.setHorzAlign(IXMLComponentContainer.EAlign.CENTER);
            } else if (iAlignment == EIXMLAttrib.HALIGN_VALUE_END) {
                oComponent.setHorzAlign(IXMLComponentContainer.EAlign.END);
            }
            iAlignment = oElement.getAttributeAsOption(EIXMLAttrib.VALIGN);
            if (iAlignment == EIXMLAttrib.VALIGN_VALUE_STRETCH) {
                oComponent.setVertAlign(IXMLComponentContainer.EAlign.STRETCH);
            } else if (iAlignment == EIXMLAttrib.VALIGN_VALUE_TOP) {
                oComponent.setVertAlign(IXMLComponentContainer.EAlign.START);
            } else if (iAlignment == EIXMLAttrib.VALIGN_VALUE_BOTTOM) {
                oComponent.setVertAlign(IXMLComponentContainer.EAlign.END);
            }
            String strTooltip = oElement.getAttributeAsString(EIXMLAttrib.TOOLTIP);
            if (strTooltip.length() > 0) {
                oComponent.getComponent().setToolTipText(strTooltip);
            }
            oComponent.getComponent().setEnabled(!oElement.getAttributeAsBoolean(EIXMLAttrib.DISABLED, false));
            oElementList.add(new BoxComponent(oComponent, oElement.getAttributeAsInt(EIXMLAttrib.FLEX), oElement.getAttributeAsInt(EIXMLAttrib.SPACING), oElement));
        }
        return oElementList;
    }

    public static void setComponentOpaque(JComponent p_oComponent, IXMLBaseElement.InfoStack p_oInfoStack) {
        if (!p_oInfoStack.mf_bCreateOpaque) {
            p_oComponent.setOpaque(p_oInfoStack.mf_bCreateOpaque);
        }
    }

    public static void setComponentSize(JComponent p_oComponent, Integer p_oWidth, Integer p_oHeight) {
        if (p_oWidth == null && p_oHeight == null) {
            return;
        }
        Dimension oSize = p_oComponent.getPreferredSize();
        if (p_oWidth != null) {
            oSize.width = p_oWidth;
        }
        if (p_oHeight != null) {
            oSize.height = p_oHeight;
        }
        p_oComponent.setPreferredSize(oSize);
        Dimension oMinMaxSize = p_oComponent.getMinimumSize();
        if (oMinMaxSize.width > oSize.width) {
            oMinMaxSize.width = oSize.width;
        }
        if (oMinMaxSize.height > oSize.height) {
            oMinMaxSize.height = oSize.height;
        }
        p_oComponent.setMinimumSize(oMinMaxSize);
        oMinMaxSize = p_oComponent.getMaximumSize();
        if (oMinMaxSize.width < oSize.width) {
            oMinMaxSize.width = oSize.width;
        }
        if (oMinMaxSize.height < oSize.height) {
            oMinMaxSize.height = oSize.height;
        }
        p_oComponent.setMaximumSize(oMinMaxSize);
    }

    public static class BoxComponent {
        public static final int DEFAULT_SPACING = -1;
        public final JComponent mf_oComponent;
        public final IXMLBaseElement mf_oElement;
        public final int mf_iFlexValue;
        public final int mf_iSpacing;

        public BoxComponent(JComponent p_oComponent, Integer p_oFlexValue, Integer p_oSpacing, IXMLBaseElement p_oElement) {
            this.mf_oComponent = p_oComponent;
            this.mf_iFlexValue = p_oFlexValue != null ? p_oFlexValue : 0;
            this.mf_iSpacing = p_oSpacing != null ? p_oSpacing : -1;
            this.mf_oElement = p_oElement;
        }
    }
}

