/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.document.parser;

import com.mayastudios.ixml.common.SimplifiedSAXParser;
import com.mayastudios.ixml.document.IXMLDocument;
import com.mayastudios.ixml.document.comp.IXMLBoxNode;
import com.mayastudios.ixml.document.comp.IXMLButtonNode;
import com.mayastudios.ixml.document.comp.IXMLCheckBoxNode;
import com.mayastudios.ixml.document.comp.IXMLComboBoxNode;
import com.mayastudios.ixml.document.comp.IXMLControlNode;
import com.mayastudios.ixml.document.comp.IXMLGridNode;
import com.mayastudios.ixml.document.comp.IXMLGroupBoxNode;
import com.mayastudios.ixml.document.comp.IXMLIconNode;
import com.mayastudios.ixml.document.comp.IXMLItemNode;
import com.mayastudios.ixml.document.comp.IXMLLabelNode;
import com.mayastudios.ixml.document.comp.IXMLMultiPageBoxNode;
import com.mayastudios.ixml.document.comp.IXMLPageNode;
import com.mayastudios.ixml.document.comp.IXMLProgressBarNode;
import com.mayastudios.ixml.document.comp.IXMLRadioGroupNode;
import com.mayastudios.ixml.document.comp.IXMLSeparatorNode;
import com.mayastudios.ixml.document.comp.IXMLSliderNode;
import com.mayastudios.ixml.document.comp.IXMLSpacerNode;
import com.mayastudios.ixml.document.comp.IXMLStackNode;
import com.mayastudios.ixml.document.comp.IXMLTabBoxNode;
import com.mayastudios.ixml.document.comp.IXMLTextBoxNode;
import com.mayastudios.ixml.document.comp.base.EIXMLAttrib;
import com.mayastudios.ixml.document.comp.base.IXMLBaseElement;
import com.mayastudios.ixml.document.parser.IXMLTagHandler;
import com.mayastudios.ixml.labels.liblabels.LibLabels;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class IXMLSaxHandler
extends SimplifiedSAXParser.SimplifiedDefaultHandler {
    private IXMLDocument m_oDocument = null;
    private Stack<StackElement> mf_oStack = new Stack();

    IXMLSaxHandler() {
    }

    void reset() {
        this.mf_oStack.clear();
        this.m_oDocument = null;
    }

    IXMLDocument getXIMLDocument() {
        return this.m_oDocument;
    }

    public void startElement(String p_strName, Attributes p_oAttributes) throws SAXException {
        IXMLBaseElement oNewElement;
        if (this.m_oDocument == null) {
            if (!"document".equals(p_strName)) {
                throw new SAXException(LibLabels.get((String)"ixmlparser.invalid-root", (Object[])new Object[]{p_strName}));
            }
            oNewElement = IXMLSaxHandler._setAttributes(new IXMLDocument(p_oAttributes.getValue("id")), p_oAttributes);
            this.m_oDocument = (IXMLDocument)oNewElement;
        } else {
            IXMLTagHandler oCallback = IXMLTagHandler.TAG_HANDLER.get(p_strName);
            if (oCallback == null) {
                throw new SAXException("Unknown element found: " + p_strName);
            }
            oNewElement = IXMLSaxHandler._setAttributes(oCallback.create(p_oAttributes), p_oAttributes);
            oCallback.finish(oNewElement, p_oAttributes);
            if (!this.mf_oStack.peek().element.appendChildElement(oNewElement)) {
                throw new SAXException(LibLabels.get((String)"ixmlparser.invalid-child", (Object[])new Object[]{p_strName, this.mf_oStack.peek().name}));
            }
        }
        this.mf_oStack.push(new StackElement(oNewElement, p_strName));
    }

    public void endElement(String p_strTagName) {
        this.mf_oStack.pop();
    }

    private static IXMLBaseElement _setAttributes(IXMLBaseElement p_oNewElement, Attributes p_oAttributes) throws SAXException {
        int iLength = p_oAttributes.getLength();
        for (int x = 0; x < iLength; ++x) {
            String strName = p_oAttributes.getQName(x);
            if ("id".equals(strName)) continue;
            EIXMLAttrib eAttrib = EIXMLAttrib.convertFromString(p_oNewElement.getType(), strName);
            if (eAttrib == null) {
                throw new SAXException(LibLabels.get((String)"ixmlparser.invalid-attribute", (Object[])new Object[]{strName, p_oNewElement}));
            }
            p_oNewElement.setAttribute(eAttrib, p_oAttributes.getValue(x));
        }
        return p_oNewElement;
    }

    static {
        IXMLBoxNode.registerTags();
        IXMLGridNode.registerTags();
        IXMLGroupBoxNode.registerTags();
        IXMLTabBoxNode.registerTags();
        IXMLMultiPageBoxNode.registerTags();
        IXMLPageNode.registerTags();
        IXMLStackNode.registerTags();
        IXMLSpacerNode.registerTags();
        IXMLSeparatorNode.registerTags();
        IXMLControlNode.registerTags();
        IXMLLabelNode.registerTags();
        IXMLIconNode.registerTags();
        IXMLButtonNode.registerTags();
        IXMLTextBoxNode.registerTags();
        IXMLComboBoxNode.registerTags();
        IXMLItemNode.registerTags();
        IXMLCheckBoxNode.registerTags();
        IXMLRadioGroupNode.registerTags();
        IXMLSliderNode.registerTags();
        IXMLProgressBarNode.registerTags();
    }

    private static class StackElement {
        public IXMLBaseElement element;
        public String name;

        public StackElement(IXMLBaseElement p_oElement, String p_strName) {
            this.element = p_oElement;
            this.name = p_strName;
        }
    }
}

