/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl;

import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MsclVersionInfo {
    public static final String REPOSITORY_URL = "https://svn.mayastudios.de/maya/repos/mscl4j";
    public static final String LIBRARY_REVISION = PackageVersionInfo._REVISION;
    public static final String LIBRARY_VERSION = PackageVersionInfo._VERSION;

    public static void main(String[] stringArray) {
        System.out.println(String.format("Version: %s r%d", LIBRARY_VERSION, LIBRARY_REVISION));
        System.out.println("Build Date: " + PackageVersionInfo._BUILD_DATE_STRING);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VersionControlSystem {
        None("none"),
        CVS("cvs"),
        Subversion("svn"),
        Mercurial("hg"),
        Git("git"),
        Bazaar("bzr"),
        UnknownVCS("");

        private final String m_propName;

        private VersionControlSystem(String string2) {
            this.m_propName = string2;
        }

        public String getPropName() {
            return this.m_propName;
        }
    }

    private static final class PackageVersionInfo {
        public static final String _VERSION;
        public static final Calendar _BUILD_DATE;
        public static final String _BUILD_DATE_STRING;
        public static final VersionControlSystem _VERSION_CONTROL_SYSTEM;
        public static final String _REVISION;
        public static final Calendar _REVISION_DATE;
        public static final String _REVISION_DATE_STRING;
        private static final String VERSION_PROPERTIES_FILENAME = "version.properties";
        private static final Pattern DATE_PATTERN;

        private PackageVersionInfo() {
        }

        private static VersionControlSystem parseVCS(String string) {
            if (string == null) {
                return VersionControlSystem.UnknownVCS;
            }
            for (VersionControlSystem versionControlSystem : VersionControlSystem.values()) {
                if (!versionControlSystem.getPropName().equals(string)) continue;
                return versionControlSystem;
            }
            return VersionControlSystem.UnknownVCS;
        }

        private static Calendar parseDate(String string) {
            if (string == null) {
                return null;
            }
            Matcher matcher = DATE_PATTERN.matcher(string);
            if (!matcher.matches()) {
                return null;
            }
            try {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)) - 1, Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)));
                gregorianCalendar.setTimeZone(TimeZone.getTimeZone("GMT" + matcher.group(7)));
                return gregorianCalendar;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        static {
            DATE_PATTERN = Pattern.compile("[ ]*(\\d{4})-(\\d{2})-(\\d{2}) (\\d{2}):(\\d{2}):(\\d{2}) ([+-]\\d{4})[ ]*");
            Properties properties = new Properties();
            URL uRL = PackageVersionInfo.class.getResource(VERSION_PROPERTIES_FILENAME);
            if (uRL != null) {
                try {
                    properties.load(uRL.openStream());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 3);
            _VERSION = properties.getProperty("version", "");
            _BUILD_DATE = PackageVersionInfo.parseDate(properties.getProperty("build-date"));
            _BUILD_DATE_STRING = _BUILD_DATE != null ? dateFormat.format(_BUILD_DATE.getTime()) : "";
            _VERSION_CONTROL_SYSTEM = PackageVersionInfo.parseVCS(properties.getProperty("vcs"));
            _REVISION = properties.getProperty("revision", "");
            _REVISION_DATE = PackageVersionInfo.parseDate(properties.getProperty("revision-date"));
            _REVISION_DATE_STRING = _REVISION_DATE != null ? dateFormat.format(_REVISION_DATE.getTime()) : "";
        }
    }
}

