/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt;

import com.mayastudios.mscl.ErrorSound;
import com.mayastudios.mscl.mwt.CAWTExceptionHandler;
import com.mayastudios.mscl.mwt.ExceptionDlg;
import com.mayastudios.mscl.mwt.GUIHelper;
import com.mayastudios.mscl.mwt.LaFManager;
import com.mayastudios.mscl.mwt.widgets.filechooser.FileChooser;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class InitHelper {
    private static final int TOOLTIP_DISMISS_DELAY = 60000;

    private InitHelper() {
    }

    public static void initApplication(Class clazz) {
        InitHelper.initApplication(clazz, "");
    }

    public static void initApplication(Class clazz, String[] stringArray) {
        InitHelper.initApplication(clazz, "", stringArray);
    }

    public static void initApplication(Class clazz, Object[] objectArray) {
        InitHelper.initApplication(clazz, "", objectArray);
    }

    public static void initApplication(Class clazz, String string) {
        InitHelper.initApplication(clazz, string, new Object[0]);
    }

    public static void initApplication(Class clazz, String string, String[] stringArray) {
        if (stringArray == null) {
            InitHelper.initApplication(clazz, string);
        } else {
            InitHelper.initApplication(clazz, string, new Object[]{stringArray});
        }
    }

    public static void initApplication(Class clazz, String string, Object[] objectArray) {
        class CEventDispatchingThread
        implements Runnable {
            Class m_oMainClass;
            String m_strMethodName;
            Object[] m_aoMethodParams;

            CEventDispatchingThread(Class clazz, String string, Object[] objectArray) {
                this.m_oMainClass = clazz;
                this.m_strMethodName = string;
                this.m_aoMethodParams = objectArray;
            }

            public void run() {
                InitHelper._doInitialization(this.m_oMainClass, this.m_strMethodName, this.m_aoMethodParams);
            }
        }
        SwingUtilities.invokeLater(new CEventDispatchingThread(clazz, string, objectArray));
    }

    private static void _doInitialization(Class clazz, String string, Object[] objectArray) {
        Constructor constructor = null;
        Method method = null;
        if (clazz == null) {
            throw new NullPointerException("No main class specified! (Must not be \"null\")");
        }
        if (string == null) {
            string = "";
        }
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        try {
            Class[] classArray = new Class[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    throw new NullPointerException("No element of the parameter list must be \"null\".");
                }
                classArray[i] = objectArray[i].getClass();
            }
            if (string.equals("")) {
                constructor = clazz.getConstructor(classArray);
            } else {
                method = clazz.getMethod(string, classArray);
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw new Error("The init method (\"" + string + "\") must be static!");
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string2 = string.equals("") ? "The constructor \"" + clazz.getCanonicalName() + "()\" does not exist. Perhabs not \"public\"?" : "The method \"" + noSuchMethodException.getMessage() + "\" does not exist. Perhabs not \"public\"?";
            throw new Error(string2);
        }
        InitHelper._enablePreInitializationFeatures();
        try {
            if (string.equals("")) {
                constructor.newInstance(objectArray);
            } else {
                method.invoke(null, objectArray);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionDlg.showDefaultUnhandledExceptionDlg(invocationTargetException.getCause());
        }
        catch (Exception exception) {
            String string3 = string.equals("") ? "Could not invoke constructor \"" + clazz.getCanonicalName() + "()\"." : "Could not invoke method \"" + string + "()\".";
            throw new Error(string3, exception);
        }
    }

    private static void _enablePreInitializationFeatures() {
        CAWTExceptionHandler.activateExceptionHandler();
        InitHelper._enableSystemLookAndFeel();
        GUIHelper.enableDynamicLayout(true);
        ErrorSound.preloadDefaultErrorSound();
        FileChooser.preloadFileChooser();
        ToolTipManager.sharedInstance().setDismissDelay(60000);
    }

    private static void _enableSystemLookAndFeel() {
        LaFManager.changeLookAndFeel(LaFManager.EStyles.System);
    }
}

