/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.dockpane;

import com.mayastudios.mscl.mwt.dockpane.ATabPanel;
import com.mayastudios.mscl.mwt.dockpane.CTab;
import com.mayastudios.mscl.mwt.dockpane.ITabStateListener;
import com.mayastudios.mscl.mwt.dockpane.toolbar.CToolbar;
import javax.swing.ImageIcon;

public abstract class ADockableTab {
    private ATabPanel m_oTabContentPanel = null;
    private ImageIcon m_oTabIcon;
    private String m_strCaption;
    private String m_strTooltip;
    private CToolbar m_oToolbar;
    private ITabStateListener m_oStateListener = null;
    private CTab m_oAssociatedTab = null;

    public ADockableTab(ATabPanel aTabPanel) {
        this.setContentPanel(aTabPanel);
    }

    public void setContentPanel(ATabPanel aTabPanel) {
        if (this.m_oTabContentPanel != null) {
            this.m_oTabContentPanel.associateTab(null);
        }
        this.m_oTabContentPanel = aTabPanel;
        this.m_oTabContentPanel.associateTab(this);
    }

    public ATabPanel getContentPanel() {
        return this.m_oTabContentPanel;
    }

    public void setCaption(String string) {
        this.m_strCaption = string;
    }

    public String getCaption() {
        return this.m_strCaption;
    }

    public void setIcon(ImageIcon imageIcon) {
        this.m_oTabIcon = imageIcon;
    }

    public ImageIcon getIcon() {
        return this.m_oTabIcon;
    }

    public void setTooltip(String string) {
        this.m_strTooltip = string;
    }

    public String getTooltip() {
        return this.m_strTooltip;
    }

    public void setToolbar(CToolbar cToolbar) {
        this.m_oToolbar = cToolbar;
    }

    public CToolbar getToolbar() {
        return this.m_oToolbar;
    }

    public void signalPropertyChange() {
        if (this.m_oAssociatedTab != null) {
            this.m_oAssociatedTab.propertiesChangedListener();
        }
    }

    public void closeTab() {
        this.m_oAssociatedTab.removeFromCurrentTabBar();
        this._fireTabClosedEvent();
    }

    void setAssociatedTab(CTab cTab) {
        this.m_oAssociatedTab = cTab;
    }

    CTab getAssociatedTab() {
        return this.m_oAssociatedTab;
    }

    public void setStateListener(ITabStateListener iTabStateListener) {
        this.m_oStateListener = iTabStateListener;
    }

    void fireStateChangeEvent(ITabStateListener.EState eState) {
        if (this.m_oStateListener != null) {
            this.m_oStateListener.stateChanged(this, eState);
        }
    }

    private void _fireTabClosedEvent() {
        if (this.m_oStateListener != null) {
            this.m_oStateListener.tabClosed(this);
        }
    }
}

