/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.mouse;

import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Timer;

public class CMouseMotionTracker
implements ActionListener {
    private MouseListener m_oListener;
    private Component m_oObservedComponent;
    private boolean m_bIsInWindow = false;
    private Timer m_oMouseOutTimer = new Timer(50, this);

    public CMouseMotionTracker(MouseListener mouseListener, Component component) {
        this.m_oListener = mouseListener;
        this.m_oObservedComponent = component;
        this.m_oMouseOutTimer.setRepeats(true);
        this.m_oMouseOutTimer.start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.m_oObservedComponent.isShowing()) {
            return;
        }
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo == null) {
            return;
        }
        Point point = pointerInfo.getLocation();
        Point point2 = this.m_oObservedComponent.getLocationOnScreen();
        if (!this.m_oObservedComponent.contains(point.x - point2.x, point.y - point2.y) && this.m_bIsInWindow) {
            MouseEvent mouseEvent = new MouseEvent(this.m_oObservedComponent, 505, 0L, 0, point.x, point.y, 0, false, 0);
            this.m_bIsInWindow = false;
            this.m_oListener.mouseExited(mouseEvent);
        } else if (this.m_oObservedComponent.contains(point.x - point2.x, point.y - point2.y) && !this.m_bIsInWindow) {
            MouseEvent mouseEvent = new MouseEvent(this.m_oObservedComponent, 504, 0L, 0, point.x, point.y, 0, false, 0);
            this.m_bIsInWindow = true;
            this.m_oListener.mouseEntered(mouseEvent);
        }
    }
}

