/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.popup;

import com.mayastudios.mscl.mwt.focus.FocusManager;
import com.mayastudios.mscl.mwt.focus.IFocusListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JWindow;

public class CPopup
implements IFocusListener {
    private JWindow m_oPopupWindow;
    private Component m_oContent;
    private long m_lShowTime;

    public CPopup(Window window, Component component) {
        this.m_oPopupWindow = new JWindow(window);
        this.m_oPopupWindow.setLayout(null);
        this.m_oPopupWindow.getContentPane().add(component);
        this.m_oPopupWindow.setFocusable(true);
        this.m_oContent = component;
        this.doAutoResize();
    }

    public Component getContentComponent() {
        return this.m_oContent;
    }

    public void setPosition(int n, int n2) {
        this.m_oPopupWindow.setLocation(n, n2);
    }

    public void setPosition(Component component, int n, int n2) {
        Point point = this._translatePosition(component, n, n2);
        this.setPosition(point.x, point.y);
    }

    private Point _translatePosition(Component component, int n, int n2) {
        if (!component.isShowing()) {
            return new Point(n, n2);
        }
        Point point = component.getLocationOnScreen();
        point.x += n;
        point.y += n2;
        return point;
    }

    public void doAutoResize() {
        Dimension dimension = this.m_oContent.getPreferredSize();
        this.m_oContent.setBounds(0, 0, dimension.width, dimension.height);
        if (this.m_oPopupWindow.isShowing()) {
            Point point = this.m_oPopupWindow.getLocationOnScreen();
            this.m_oPopupWindow.setBounds(point.x, point.y, dimension.width, dimension.height);
        } else {
            this.m_oPopupWindow.setBounds(0, 0, dimension.width, dimension.height);
        }
    }

    public void show(int n, int n2) {
        this.setPosition(n, n2);
        if (this.m_oPopupWindow.isVisible()) {
            return;
        }
        FocusManager.addContainerFocusListener(this, this.m_oPopupWindow, true);
        this.m_oPopupWindow.setVisible(true);
        FocusManager.focusComponent(this.m_oPopupWindow);
    }

    public void show(Component component, int n, int n2) {
        Point point = this._translatePosition(component, n, n2);
        this.show(point.x, point.y);
        this.m_lShowTime = System.currentTimeMillis();
    }

    public void hide() {
        this.m_oPopupWindow.setVisible(false);
        FocusManager.removeFocusListener(this);
    }

    public void focusChanged(Component component, Component component2, IFocusListener.EState eState) {
        if (eState == IFocusListener.EState.LOST) {
            if (System.currentTimeMillis() - this.m_lShowTime < 200L) {
                FocusManager.focusComponent(this.m_oPopupWindow);
                return;
            }
            this.hide();
        }
    }
}

