/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.widgets;

import com.mayastudios.mscl.mwt.widgets.APaintHelperPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public abstract class AutoFillViewContainer
extends APaintHelperPanel
implements Scrollable {
    private JViewport m_oViewport;
    private Component m_oComponent;
    private Dimension m_oLastKnownSize;

    public AutoFillViewContainer() {
        this.setLayout(null);
        this.addHierarchyListener(new ParentChangedListener());
    }

    public void setContent(Component component) {
        if (this.m_oComponent != null) {
            this.remove(this.m_oComponent);
            this.m_oComponent = null;
        }
        if (component != null) {
            this.m_oComponent = component;
            component.setLocation(0, 0);
            component.setSize(component.getPreferredSize());
            this.add(component);
            this._update();
        }
    }

    public Component getContent() {
        return this.m_oComponent;
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.getComponentCount() == 1) {
            throw new IllegalStateException("You can add only one component to this container.");
        }
        super.addImpl(component, object, n);
    }

    protected void _update() {
        if (this.m_oComponent == null) {
            return;
        }
        Container container = this.getParent();
        if (!(container instanceof JViewport)) {
            this.m_oViewport = null;
            return;
        }
        this.m_oViewport = (JViewport)container;
        this.m_oLastKnownSize = (Dimension)this.m_oComponent.getPreferredSize().clone();
        this.m_oComponent.setSize(this.m_oLastKnownSize);
        this.repaint();
    }

    public Dimension getPreferredSize() {
        if (this.m_oComponent == null) {
            return new Dimension(0, 0);
        }
        if (!this.m_oComponent.getPreferredSize().equals(this.m_oLastKnownSize)) {
            this._update();
        }
        return this.m_oLastKnownSize;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.m_oViewport == null) {
            return false;
        }
        return this.getPreferredSize().width < this.m_oViewport.getWidth();
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.m_oViewport == null) {
            return false;
        }
        return this.getPreferredSize().height < this.m_oViewport.getHeight();
    }

    private class ParentChangedListener
    implements HierarchyListener {
        private ParentChangedListener() {
        }

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 1L) != 0L) {
                AutoFillViewContainer.this._update();
            }
        }
    }
}

