/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.mscl.mwt.widgets.inputcontols;

import com.mayastudios.mscl.mwt.widgets.inputcontols.IInvalidableCtrl;
import com.mayastudios.mscl.mwt.widgets.inputcontols.IInvalidableCtrlWrapper;
import com.mayastudios.mscl.mwt.widgets.inputcontols.InvalidContentNotifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;

public class CDateTimeEditField
extends JSpinner
implements IInvalidableCtrlWrapper {
    public static final long TIME_MILLIS_CORRECTOR = 3600000L;
    private CDateEditor m_oDateEditor;

    public CDateTimeEditField(EType eType, EType eType2, boolean bl) {
        this(CDateTimeEditField._createFormatPatter(eType, eType2), bl);
    }

    public CDateTimeEditField(String string, boolean bl) {
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel();
        spinnerDateModel.setCalendarField(5);
        this.setModel(spinnerDateModel);
        this.m_oDateEditor = new CDateEditor(this, string, bl);
        this.setEditor(this.m_oDateEditor);
        this.m_oDateEditor.getTextField().addFocusListener(new CFocusListener());
    }

    public static String getDateFormatPattern(EType eType) {
        return ((SimpleDateFormat)DateFormat.getDateInstance(eType.getValue())).toPattern();
    }

    public static String getTimeFormatPattern(EType eType) {
        return ((SimpleDateFormat)DateFormat.getTimeInstance(eType.getValue())).toPattern();
    }

    public static String getDateTimeFormatPattern(EType eType, EType eType2) {
        return ((SimpleDateFormat)DateFormat.getDateTimeInstance(eType.getValue(), eType2.getValue())).toPattern();
    }

    private static String _createFormatPatter(EType eType, EType eType2) {
        if (eType != null && eType2 != null) {
            return CDateTimeEditField.getDateTimeFormatPattern(eType, eType2);
        }
        if (eType != null) {
            return CDateTimeEditField.getDateFormatPattern(eType);
        }
        return CDateTimeEditField.getTimeFormatPattern(eType2);
    }

    public void highlightControl(boolean bl) {
        this.m_oDateEditor.highlightControl(bl);
    }

    public boolean evaluateContent() {
        return this.m_oDateEditor.evaluateContent(IInvalidableCtrl.EEvalType.OTHER);
    }

    public void setFromDateTime(Date date) {
        ((SpinnerDateModel)this.getModel()).setValue(date);
    }

    public Date getAsDateTime(EReturnType eReturnType) {
        return this.getAsCalendar(eReturnType).getTime();
    }

    public void setFromCalendar(Calendar calendar) {
        this.setFromDateTime(calendar.getTime());
    }

    public Calendar getAsCalendar(EReturnType eReturnType) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(((SpinnerDateModel)this.getModel()).getDate());
        if (eReturnType == EReturnType.DATE) {
            calendar.set(10, 0);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(9, 0);
        } else {
            calendar.set(1970, 0, 1);
        }
        calendar.set(14, 0);
        return calendar;
    }

    public void setFromMilliseconds(long l) {
        this.setFromDateTime(new Date(l));
    }

    public long getAsMilliseconds(EReturnType eReturnType) {
        return this.getAsCalendar(eReturnType).getTimeInMillis();
    }

    @Deprecated
    public void setValue(Object object) {
        super.setValue(object);
    }

    @Deprecated
    public Object getValue() {
        return super.getValue();
    }

    public void addFocusListener(FocusListener focusListener) {
        super.addFocusListener(focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        super.removeFocusListener(focusListener);
    }

    private void _redispatchFocusEvent(FocusEvent focusEvent) {
        FocusEvent focusEvent2 = new FocusEvent(this, focusEvent.getID(), focusEvent.isTemporary(), focusEvent.getOppositeComponent());
        this.processFocusEvent(focusEvent2);
    }

    private static class CDateEditor
    extends JSpinner.DateEditor
    implements IInvalidableCtrl {
        private static final Font DEFAULT_FONT = new Font("Dialog", 0, 11);
        private Color m_oDefaultBGColor;

        CDateEditor(CDateTimeEditField cDateTimeEditField, String string, boolean bl) {
            super((JSpinner)cDateTimeEditField, string);
            JFormattedTextField jFormattedTextField = this.getTextField();
            this.m_oDefaultBGColor = jFormattedTextField.getBackground();
            jFormattedTextField.setFont(DEFAULT_FONT);
            jFormattedTextField.setHorizontalAlignment(4);
            jFormattedTextField.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
            InvalidContentNotifier.associateWithControl(this, this.getTextField().getText(), bl);
        }

        public Component getControl() {
            return this;
        }

        public void highlightControl(boolean bl) {
            if (bl) {
                this.getTextField().setBackground(IInvalidableCtrl.DEFAULT_HIGHLIGHT_COLOR);
            } else {
                this.getTextField().setBackground(this.m_oDefaultBGColor);
            }
        }

        public boolean evaluateContent(IInvalidableCtrl.EEvalType eEvalType) {
            return this.getTextField().isEditValid();
        }

        public Object getContent() {
            return this.getTextField().getText();
        }

        public void restoreContent(Object object) {
            this.getTextField().setText((String)object);
        }
    }

    private final class CFocusListener
    implements FocusListener {
        private CFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            CDateTimeEditField.this._redispatchFocusEvent(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
            CDateTimeEditField.this._redispatchFocusEvent(focusEvent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EReturnType {
        DATE,
        TIME,
        BOTH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EType {
        SHORT(3),
        MEDIUM(2),
        LONG(1),
        FULL(0);

        private int m_iValue;

        private EType(int n2) {
            this.m_iValue = n2;
        }

        int getValue() {
            return this.m_iValue;
        }
    }
}

