/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.systeminfo;

import com.mayastudios.systeminfo.Helpers;
import com.mayastudios.systeminfo.SystemInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinuxInfo
extends SystemInfo {
    public static final Pattern KERNEL_VERSION_PATTERN = Pattern.compile("^(\\d+).(\\d+).(\\d+).(\\d+)");
    private static final Pattern KERNEL_VERSION_PATTERN_INTERNAL = Pattern.compile("^(\\d+).(\\d+).(\\d+)(?:-(\\d+))?");
    private final LinuxDistribution m_distribution = LinuxInfo.determineDistribution();
    private final String m_version;
    private final String m_codename;
    private final String m_kernelVersion;
    private final SystemInfo.SystemArch m_systemArch;
    private final String m_processorName;
    private final long m_totalMemory;

    LinuxInfo() {
        super(LinuxInfo.determineJavaArch());
        Helpers.Pair<String, String> pair = LinuxInfo.determineDistributionVersion(this.m_distribution);
        this.m_version = pair.getFirst();
        this.m_codename = pair.getSecond();
        this.m_kernelVersion = LinuxInfo.determineKernelVersion();
        this.m_systemArch = LinuxInfo.determineSystemArch();
        this.m_processorName = LinuxInfo.determineProcessorName();
        this.m_totalMemory = LinuxInfo.determineTotalMemory();
    }

    private static SystemInfo.JavaArch determineJavaArch() {
        String string = System.getProperty("os.arch");
        if ("x86".equals(string) || string.matches("i\\d86")) {
            return SystemInfo.JavaArch.x86;
        }
        if ("x86_64".equals(string) || "amd64".equals(string)) {
            return SystemInfo.JavaArch.x64;
        }
        if ("ppc".equals(string)) {
            return SystemInfo.JavaArch.PowerPC;
        }
        if ("sparc".equals(string)) {
            return SystemInfo.JavaArch.Sparc;
        }
        return SystemInfo.JavaArch.Unknown;
    }

    private static LinuxDistribution determineDistribution() {
        if (Helpers.doesFileExist("/etc/debian_version")) {
            if (Helpers.doesFileExist("/etc/lsb-release")) {
                return LinuxDistribution.Ubuntu;
            }
            return LinuxDistribution.Debian;
        }
        if (Helpers.doesFileExist("/etc/redhat-release") || Helpers.doesFileExist("/etc/redhat_version")) {
            return LinuxDistribution.RedHat;
        }
        if (Helpers.doesFileExist("/etc/SUSE-release")) {
            return LinuxDistribution.SuSE;
        }
        if (Helpers.doesFileExist("/etc/gentoo-release")) {
            return LinuxDistribution.Gentoo;
        }
        if (Helpers.doesFileExist("/etc/fedora-release")) {
            return LinuxDistribution.Fedora;
        }
        if (Helpers.doesFileExist("/etc/slackware-release") || Helpers.doesFileExist("/etc/slackware-version")) {
            return LinuxDistribution.Slackware;
        }
        if (Helpers.doesFileExist("/etc/mandrake-release")) {
            return LinuxDistribution.Mandrake;
        }
        return LinuxDistribution.Unknown;
    }

    private static Helpers.Pair<String, String> determineDistributionVersion(LinuxDistribution linuxDistribution) {
        try {
            String string = null;
            String string2 = null;
            switch (linuxDistribution) {
                case Ubuntu: {
                    String[] stringArray;
                    Pattern pattern = Pattern.compile("DISTRIB_RELEASE=(\\d+.\\d+)");
                    Pattern pattern2 = Pattern.compile("DISTRIB_CODENAME=(\\w+)");
                    for (String string3 : stringArray = Helpers.readFile("/etc/lsb-release")) {
                        Matcher matcher = pattern.matcher(string3);
                        if (matcher.matches()) {
                            string = matcher.group(1);
                            continue;
                        }
                        matcher = pattern2.matcher(string3);
                        if (!matcher.matches()) continue;
                        string2 = matcher.group(1);
                    }
                    break;
                }
                case Debian: {
                    String[] stringArray = Helpers.readFile("/etc/debian_version");
                    string = stringArray[0].trim();
                    if ("3.0".equals(string)) {
                        string2 = "woody";
                        break;
                    }
                    if ("3.1".equals(string)) {
                        string2 = "sarge";
                        break;
                    }
                    if ("4.0".equals(string)) {
                        string2 = "etch";
                        break;
                    }
                    if ("5.0".equals(string)) {
                        string2 = "lenny";
                        break;
                    }
                    if ("6.0".equals(string)) {
                        string2 = "squeeze";
                        break;
                    }
                    if (string.endsWith("/sid")) {
                        string = null;
                        string2 = "unstable";
                        break;
                    }
                    if (string.matches("\\d+.\\d+")) break;
                    string = null;
                }
            }
            if (string2 != null) {
                string2 = string2.toLowerCase();
            }
            return new Helpers.Pair<Object, String>(string, string2);
        }
        catch (IOException iOException) {
            return new Helpers.Pair<Object, Object>(null, null);
        }
    }

    private static String determineKernelVersion() {
        try {
            Matcher matcher;
            Process process = Runtime.getRuntime().exec("uname -r");
            InputStream inputStream = process.getInputStream();
            StringWriter stringWriter = new StringWriter();
            try {
                int n;
                while ((n = inputStream.read()) != -1) {
                    stringWriter.write(n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!(matcher = KERNEL_VERSION_PATTERN_INTERNAL.matcher(stringWriter.toString())).find()) {
                return null;
            }
            String string = matcher.group(1);
            String string2 = matcher.group(2);
            String string3 = matcher.group(3);
            String string4 = matcher.groupCount() == 4 ? matcher.group(4) : "0";
            return string + "." + string2 + "." + string3 + "-" + string4;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String determineProcessorName() {
        try {
            Matcher matcher;
            Process process = Runtime.getRuntime().exec("cat /proc/cpuinfo");
            InputStream inputStream = process.getInputStream();
            StringWriter stringWriter = new StringWriter();
            try {
                int n;
                while ((n = inputStream.read()) != -1) {
                    stringWriter.write(n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!(matcher = Pattern.compile("^model name\\s+:\\s+(.+)$", 8).matcher(stringWriter.toString())).find()) {
                return null;
            }
            return matcher.group(1);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static SystemInfo.SystemArch determineSystemArch() {
        try {
            String string;
            Process process = Runtime.getRuntime().exec("uname -m");
            InputStream inputStream = process.getInputStream();
            StringWriter stringWriter = new StringWriter();
            try {
                int n;
                while ((n = inputStream.read()) != -1) {
                    stringWriter.write(n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if ("x86".equals(string = stringWriter.toString().trim()) || string.matches("i\\d86")) {
                return SystemInfo.SystemArch.x86;
            }
            if ("x86_64".equals(string) || "amd64".equals(string)) {
                return SystemInfo.SystemArch.x64;
            }
            if ("ppc".equals(string)) {
                return SystemInfo.SystemArch.PowerPC;
            }
            if ("sparc".equals(string)) {
                return SystemInfo.SystemArch.Sparc;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return SystemInfo.SystemArch.Unknown;
    }

    private static long determineTotalMemory() {
        long l = Helpers.determineTotalPhysicalMemory();
        if (l != 0L) {
            return l;
        }
        try {
            Matcher matcher;
            Process process = Runtime.getRuntime().exec("cat /proc/meminfo");
            InputStream inputStream = process.getInputStream();
            StringWriter stringWriter = new StringWriter();
            try {
                int n;
                while ((n = inputStream.read()) != -1) {
                    stringWriter.write(n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!(matcher = Pattern.compile("^MemTotal:\\s+(.+) kB$", 8).matcher(stringWriter.toString())).find()) {
                return 0L;
            }
            return Long.parseLong(matcher.group(1)) * 1024L;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    @Override
    public String getOsName() {
        return this.m_distribution.toString() + " (Linux)";
    }

    @Override
    public String getSystemCodename() {
        return this.getDistributionCodename();
    }

    @Override
    public String getSystemVersionNumber() {
        return this.getDistributionVersion();
    }

    public LinuxDistribution getDistribution() {
        return this.m_distribution;
    }

    public String getDistributionVersion() {
        return this.m_version;
    }

    public String getDistributionCodename() {
        return this.m_codename;
    }

    public String getKernelVersion() {
        return this.m_kernelVersion;
    }

    @Override
    public String getProcessorName() {
        return this.m_processorName;
    }

    @Override
    public SystemInfo.SystemArch getSystemArch() {
        return this.m_systemArch;
    }

    @Override
    public long getTotalPhysicalMemorySize() {
        return this.m_totalMemory;
    }

    @Override
    public String toString() {
        return super.toString() + "\n\n" + "Distribution Version: " + (this.getSystemVersionNumber() != null ? this.getSystemVersionNumber() : "unknown") + "\n" + "Kernel Version:       " + (this.getKernelVersion() != null ? this.getKernelVersion() : "unknown");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LinuxDistribution {
        Debian,
        Ubuntu,
        RedHat,
        SuSE,
        Gentoo,
        Fedora,
        Slackware,
        Mandrake,
        Unknown;

    }
}

