/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.text.ParseException;
import java.util.Date;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.TreeTableCellEditorImpl;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.util.DateUtils;
import org.jdesktop.jdnc.JNTreeTable;
import org.jdesktop.swing.table.TableColumnExt;
import org.jdesktop.swing.treetable.TreeTableModel;

class GPTreeTableBase
extends JNTreeTable {
    protected GPTreeTableBase(TreeTableModel model) {
        super(model);
    }

    protected TableColumnExt newTableColumnExt(int modelIndex) {
        TableColumnExt result = new TableColumnExt(modelIndex);
        TableCellEditor defaultEditor = this.getTreeTable().getDefaultEditor(this.getTreeTableModel().getColumnClass(modelIndex));
        if (defaultEditor != null) {
            result.setCellEditor((TableCellEditor)new TreeTableCellEditorImpl(defaultEditor));
        }
        return result;
    }

    protected TableCellEditor newDateCellEditor() {
        return new DateCellEditor();
    }

    private static class DateCellEditor
    extends DefaultCellEditor {
        private final Color colorNormal = null;
        private final Color colorError = new Color(255, 125, 125);
        private Date date = null;

        public DateCellEditor() {
            super(new JTextField());
        }

        public Component getTableCellEditorComponent(JTable arg0, Object arg1, boolean arg2, int arg3, int arg4) {
            JTextField result = (JTextField)super.getTableCellEditorComponent(arg0, arg1, arg2, arg3, arg4);
            result.selectAll();
            return result;
        }

        public Object getCellEditorValue() {
            return new GanttCalendar(this.date == null ? new Date() : this.date);
        }

        public boolean stopCellEditing() {
            boolean res = true;
            try {
                this.date = DateUtils.parseDate(((JTextComponent)this.getComponent()).getText(), GanttLanguage.getInstance().getLocale());
                this.getComponent().setBackground(this.colorNormal);
                super.fireEditingStopped();
            }
            catch (ParseException e) {
                Toolkit.getDefaultToolkit().beep();
                this.getComponent().setBackground(this.colorError);
                res = false;
            }
            return res;
        }
    }
}

