/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import net.sourceforge.ganttproject.GanttOptions;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.GanttTree2;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.action.GPAction;
import net.sourceforge.ganttproject.action.RolloverAction;
import net.sourceforge.ganttproject.gui.UIConfiguration;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.task.TaskNode;

public class CalculateCriticalPathAction
extends GPAction
implements RolloverAction {
    private final TaskManager taskManager;
    private final GanttTree2 tree;
    private static final String ICON_PREFIX_ON = "criticalPathOn_";
    private static final String ICON_PREFIX_OFF = "criticalPathOff_";
    private final UIConfiguration myUIConfiguration;
    private final GanttOptions myOptions;
    private final GanttProject appli;

    public CalculateCriticalPathAction(TaskManager taskManager, GanttTree2 tree, GanttOptions options, UIConfiguration uiConfiguration, GanttProject appli) {
        super(null, options.getIconSize());
        this.taskManager = taskManager;
        this.tree = tree;
        this.myUIConfiguration = uiConfiguration;
        this.myOptions = options;
        this.appli = appli;
    }

    protected String getIconFilePrefix() {
        return this.isOn() ? ICON_PREFIX_ON : ICON_PREFIX_OFF;
    }

    public void actionPerformed(ActionEvent e) {
        TaskNode root = (TaskNode)this.tree.getRoot();
        this.setOn(!this.isOn());
        this.putValue("SmallIcon", this.createIcon(this.myOptions.getIconSize()));
        if (this.isOn()) {
            this.taskManager.processCriticalPath(root);
            ArrayList projectTasks = this.tree.getProjectTasks();
            if (projectTasks.size() != 0) {
                for (int i = 0; i < projectTasks.size(); ++i) {
                    this.taskManager.processCriticalPath((TaskNode)projectTasks.get(i));
                }
            }
        }
        Mediator.getGanttProjectSingleton().repaint();
        this.appli.getUIFacade().setStatusText(GanttLanguage.getInstance().getText("criticalPath"));
    }

    private void setOn(boolean on) {
        this.myUIConfiguration.setCriticalPathOn(on);
    }

    private boolean isOn() {
        return this.myUIConfiguration == null ? false : this.myUIConfiguration.isCriticalPathOn();
    }

    public void isIconVisible(boolean isNull) {
        this.setIconVisible(isNull);
    }

    protected String getLocalizedName() {
        return GanttProject.correctLabel(GanttLanguage.getInstance().getText("criticalPath"));
    }
}

