/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.action.task;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.ganttproject.action.GPAction;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.task.TaskSelectionManager;

abstract class TaskActionBase
extends GPAction
implements TaskSelectionManager.Listener {
    private final TaskManager myTaskManager;
    private List mySelection;
    private final UIFacade myUIFacade;

    protected TaskActionBase(TaskManager taskManager, TaskSelectionManager selectionManager, UIFacade uiFacade) {
        this.myTaskManager = taskManager;
        selectionManager.addSelectionListener(this);
        this.selectionChanged(selectionManager.getSelectedTasks());
        this.myUIFacade = uiFacade;
    }

    public void actionPerformed(ActionEvent e) {
        final ArrayList selection = new ArrayList(this.mySelection);
        this.myUIFacade.getUndoManager().undoableEdit(this.getLocalizedName(), new Runnable(){

            public void run() {
                try {
                    TaskActionBase.this.run(selection);
                }
                catch (Exception e) {
                    TaskActionBase.this.getUIFacade().showErrorDialog(e);
                }
            }
        });
    }

    public void selectionChanged(List currentSelection) {
        this.setEnabled(this.isEnabled(currentSelection));
        this.mySelection = currentSelection;
    }

    protected TaskManager getTaskManager() {
        return this.myTaskManager;
    }

    protected UIFacade getUIFacade() {
        return this.myUIFacade;
    }

    protected abstract boolean isEnabled(List var1);

    protected abstract void run(List var1) throws Exception;
}

