/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.chart;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import net.sourceforge.ganttproject.chart.ChartModelBase;
import net.sourceforge.ganttproject.chart.Painter;
import net.sourceforge.ganttproject.chart.ResourceChart;
import net.sourceforge.ganttproject.chart.ResourceLoadRenderer;
import net.sourceforge.ganttproject.gui.UIConfiguration;
import net.sourceforge.ganttproject.gui.options.model.ColorOption;
import net.sourceforge.ganttproject.gui.options.model.DefaultColorOption;
import net.sourceforge.ganttproject.gui.options.model.GP1XOptionConverter;
import net.sourceforge.ganttproject.gui.options.model.GPOption;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.resource.HumanResourceManager;
import net.sourceforge.ganttproject.resource.ProjectResource;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.time.TimeUnitStack;

public class ChartModelResource
extends ChartModelBase {
    private ResourceLoadRenderer myResourceLoadRenderer;
    private HumanResourceManager myManager;
    private GPOptionGroup myColorOptions;
    private ColorOption myResourceNormalLoadOption;
    private ColorOption myResourceOverloadOption;
    private ColorOption myResourceUnderloadOption;
    private ColorOption myDayOffOption;

    public ChartModelResource(TaskManager taskManager, HumanResourceManager resourceManager, TimeUnitStack timeUnitStack, final UIConfiguration projectConfig, ResourceChart resourceChart) {
        super(taskManager, timeUnitStack, projectConfig);
        this.myResourceLoadRenderer = new ResourceLoadRenderer(this, resourceChart);
        this.myTimeUnitVisitors.add(this.myResourceLoadRenderer);
        this.myManager = resourceManager;
        this.myResourceNormalLoadOption = new ResourceLoadOption("resourceChartColors.normalLoad", "colors", "resources"){

            public void commit() {
                super.commit();
                projectConfig.setResourceColor(this.getValue());
            }
        };
        this.myResourceNormalLoadOption.lock();
        this.myResourceNormalLoadOption.setValue(new Color(140, 182, 206));
        this.myResourceNormalLoadOption.commit();
        this.myResourceOverloadOption = new ResourceLoadOption("resourceChartColors.overLoad", "colors", "resourceOverload"){

            public void commit() {
                super.commit();
                projectConfig.setResourceOverloadColor(this.getValue());
            }
        };
        this.myResourceOverloadOption.lock();
        this.myResourceOverloadOption.setValue(new Color(229, 50, 50));
        this.myResourceOverloadOption.commit();
        this.myResourceUnderloadOption = new DefaultColorOption("resourceChartColors.underLoad"){

            public void commit() {
                super.commit();
                projectConfig.setResourceUnderloadColor(this.getValue());
            }
        };
        this.myResourceUnderloadOption.lock();
        this.myResourceUnderloadOption.setValue(new Color(50, 229, 50));
        this.myResourceUnderloadOption.commit();
        this.myDayOffOption = new DefaultColorOption("resourceChartColors.dayOff"){

            public void commit() {
                super.commit();
                projectConfig.setDayOffColor(this.getValue());
            }
        };
        this.myDayOffOption.lock();
        this.myDayOffOption.setValue(new Color(0.9f, 1.0f, 0.17f));
        this.myDayOffOption.commit();
        this.myColorOptions = new GPOptionGroup("resourceChartColors", new GPOption[]{this.myResourceNormalLoadOption, this.myResourceOverloadOption, this.myResourceUnderloadOption, this.myDayOffOption});
    }

    protected void enableRenderers1() {
        super.enableRenderers1();
        this.myResourceLoadRenderer.setEnabled(true);
    }

    protected void enableRenderers2() {
        super.enableRenderers2();
        this.myResourceLoadRenderer.setEnabled(false);
    }

    protected void paintMainArea(Graphics mainArea, Painter p) {
        super.paintMainArea(mainArea, p);
        this.myResourceLoadRenderer.getPrimitiveContainer().paint(p, mainArea);
    }

    public ProjectResource[] getVisibleResources() {
        return this.myManager.getResources().toArray(new ProjectResource[0]);
    }

    public GPOptionGroup[] getChartOptionGroups() {
        ArrayList<GPOptionGroup> result = new ArrayList<GPOptionGroup>();
        GPOptionGroup[] superGroups = super.getChartOptionGroups();
        result.add(this.myColorOptions);
        return result.toArray(new GPOptionGroup[result.size()]);
    }

    private static class ResourceLoadOption
    extends DefaultColorOption
    implements GP1XOptionConverter {
        private String myTagName;
        private String myAttributeName;

        ResourceLoadOption(String id, String tagName, String attributeName) {
            super(id);
            this.myTagName = tagName;
            this.myAttributeName = attributeName;
        }

        public String getTagName() {
            return this.myTagName;
        }

        public String getAttributeName() {
            return this.myAttributeName;
        }

        public void loadValue(String legacyValue) {
            this.loadPersistentValue(legacyValue);
        }
    }
}

