/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.document;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import net.sourceforge.ganttproject.document.AbstractURLDocument;
import net.sourceforge.ganttproject.document.HttpDocumentOutputStream;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.URIException;
import org.apache.webdav.lib.WebdavResource;

public class HttpDocument
extends AbstractURLDocument {
    private String url;
    private String lastError;
    private HttpURL httpURL;
    private WebdavResource webdavResource;
    private boolean locked = false;
    private boolean malformedURL = false;
    private static int lockDAVMinutes = 240;

    public HttpDocument(String url, String user, String pass) {
        this.url = url;
        try {
            this.httpURL = new HttpURL(url);
            if (user == null || user.length() == 0) {
                user = this.httpURL.getUser();
            }
            if (pass == null || pass.length() == 0) {
                pass = this.httpURL.getPassword();
            }
            if (user != null) {
                this.httpURL.setUserinfo(user, pass);
            }
        }
        catch (URIException e) {
            this.lastError = e.getMessage();
            this.malformedURL = true;
        }
    }

    private WebdavResource getWebdavResource() {
        if (null == this.webdavResource) {
            try {
                this.webdavResource = new WebdavResource(this.httpURL, 1, 0);
                this.webdavResource.setFollowRedirects(true);
            }
            catch (HttpException e) {
                this.lastError = e.getMessage() + "(" + e.getReasonCode() + ")";
            }
            catch (IOException e) {
                this.lastError = e.getMessage();
            }
        }
        return this.webdavResource;
    }

    public String getDescription() {
        String description = this.httpURL.toString();
        return description != null ? description : this.url;
    }

    public boolean canRead() {
        WebdavResource res = this.getWebdavResource();
        return null == res ? false : res.exists() && !res.isCollection();
    }

    public boolean canWrite() {
        WebdavResource res = this.getWebdavResource();
        if (null == res) {
            return false;
        }
        try {
            res.setProperties(0);
        }
        catch (HttpException e) {
            if (404 != e.getReasonCode()) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        if (res.exists()) {
            return !res.isCollection();
        }
        try {
            String currentHierPath;
            HttpURL parentURL = new HttpURL(this.httpURL.toString());
            String user = this.httpURL.getUser();
            String pass = this.httpURL.getPassword();
            if (user != null) {
                parentURL.setUserinfo(user, pass);
            }
            if (!(currentHierPath = this.httpURL.getCurrentHierPath()).endsWith("/")) {
                currentHierPath = currentHierPath + "/";
            }
            parentURL.setPath(currentHierPath);
            WebdavResource parentRes = new WebdavResource(parentURL);
            return parentRes.isCollection();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isValidForMRU() {
        return !this.malformedURL;
    }

    public boolean acquireLock() {
        if (this.locked) {
            return true;
        }
        if (null == this.getWebdavResource()) {
            return false;
        }
        try {
            String userName = " (GanttProject)";
            try {
                userName = " (" + System.getProperty("user.name") + "@GanttProject)";
            }
            catch (AccessControlException e) {
                System.err.println(e + ": " + e.getMessage());
            }
            int lockSeconds = lockDAVMinutes > 0 ? lockDAVMinutes * 60 : 15;
            this.locked = this.getWebdavResource().lockMethod(this.httpURL.getUser() + userName, lockSeconds);
            return this.locked;
        }
        catch (HttpException e) {
            System.err.println(e.getMessage() + e.getReasonCode());
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println(e);
            e.printStackTrace();
        }
        return false;
    }

    public void releaseLock() {
        if (null == this.getWebdavResource()) {
            return;
        }
        try {
            this.locked = false;
            this.getWebdavResource().unlockMethod();
        }
        catch (HttpException e) {
            System.err.println(e.getMessage() + e.getReasonCode());
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }

    public InputStream getInputStream() throws IOException {
        if (null == this.getWebdavResource()) {
            throw new IOException(this.lastError);
        }
        try {
            return this.getWebdavResource().getMethodData();
        }
        catch (HttpException e) {
            throw new IOException(e.getMessage() + "(" + e.getReasonCode() + ")");
        }
    }

    public OutputStream getOutputStream() throws IOException {
        if (null == this.getWebdavResource()) {
            throw new IOException(this.lastError);
        }
        return new HttpDocumentOutputStream(this.getWebdavResource());
    }

    public String getPath() {
        return this.getDescription();
    }

    public String getURLPath() {
        return this.getPath();
    }

    public String getUsername() {
        try {
            return this.httpURL.getUser();
        }
        catch (URIException e) {
            return null;
        }
    }

    public String getPassword() {
        try {
            return this.httpURL.getPassword();
        }
        catch (URIException e) {
            return null;
        }
    }

    public void setUserInfo(String user, String pass) {
        try {
            this.httpURL.setUserinfo(user, pass);
            this.webdavResource = null;
        }
        catch (URIException e) {
            this.lastError = e.getMessage();
            this.malformedURL = true;
        }
    }

    public String getLastError() {
        return this.lastError;
    }

    public static void setLockDAVMinutes(int i) {
        lockDAVMinutes = i;
    }

    public void write() throws IOException {
    }

    public URI getURI() {
        try {
            return new URI(this.url);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public boolean isLocal() {
        return false;
    }
}

