/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.export;

import java.io.File;
import java.util.Arrays;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.export.ConsoleUIFacade;
import net.sourceforge.ganttproject.export.ExportFileWizardImpl;
import net.sourceforge.ganttproject.export.ExportFinalizationJob;
import net.sourceforge.ganttproject.export.Exporter;
import net.sourceforge.ganttproject.export.FileChooserPage;
import org.eclipse.core.runtime.Platform;

public class CommandLineExportApplication {
    public boolean export(String[] cmdline) {
        Exporter exporter;
        if (cmdline.length < 2) {
            return false;
        }
        if (cmdline[0].startsWith("-") && (exporter = this.findExporter(cmdline[0].toLowerCase().substring(1))) != null) {
            GanttProject project = new GanttProject(false);
            project.openStartupDocument(cmdline[1]);
            ConsoleUIFacade consoleUI = new ConsoleUIFacade(project.getUIFacade());
            Platform.getJobManager().setProgressProvider(null);
            File inputFile = new File(cmdline[1]);
            if (!inputFile.exists()) {
                consoleUI.showErrorDialog("File " + cmdline[1] + " does not exist.");
                return true;
            }
            if (!inputFile.canRead()) {
                consoleUI.showErrorDialog("File " + cmdline[1] + " is not readable.");
                return true;
            }
            File outputFile = cmdline.length > 2 ? new File(cmdline[2]) : FileChooserPage.proposeOutputFile(project, exporter);
            System.err.println("[CommandLineExportApplication] export(): exporting with " + exporter);
            exporter.setContext(project, consoleUI);
            if (exporter instanceof ExportFileWizardImpl.LegacyOptionsClient) {
                ((ExportFileWizardImpl.LegacyOptionsClient)((Object)exporter)).setOptions(project.getOptions());
            }
            try {
                ExportFinalizationJob finalizationJob = new ExportFinalizationJob(){

                    public void run(File[] exportedFiles) {
                        System.exit(0);
                    }
                };
                exporter.run(outputFile, finalizationJob);
            }
            catch (Exception e) {
                consoleUI.showErrorDialog(e);
            }
            return true;
        }
        return false;
    }

    private Exporter findExporter(String fileExtension) {
        Exporter[] exporters = Mediator.getPluginManager().getExporters();
        for (int i = 0; i < exporters.length; ++i) {
            Exporter next = exporters[i];
            if (!Arrays.asList(next.getFileExtensions()).contains(fileExtension)) continue;
            return next;
        }
        return null;
    }
}

