/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.ganttproject.gui.TextFieldAndFileChooserComponent;
import net.sourceforge.ganttproject.gui.options.OptionsPageBuilder;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.gui.projectwizard.WizardPage;
import net.sourceforge.ganttproject.language.GanttLanguage;

public abstract class FileChooserPageBase
implements WizardPage {
    private JPanel myComponent;
    private TextFieldAndFileChooserComponent myChooser;
    private OptionsPageBuilder myOptionsBuilder = new OptionsPageBuilder();
    private JPanel mySecondaryOptionsComponent = new JPanel(new BorderLayout());

    protected FileChooserPageBase() {
    }

    protected abstract String getFileChooserTitle();

    public Component getComponent() {
        this.myComponent = new JPanel(new BorderLayout());
        this.myChooser = new TextFieldAndFileChooserComponent(GanttLanguage.getInstance().getText("file") + ":", this.getFileChooserTitle()){

            protected void onFileChosen(File file) {
                FileChooserPageBase.this.onFileChosen(file);
                super.onFileChosen(file);
            }
        };
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add(this.myChooser.getComponent(), "North");
        contentPanel.add((Component)this.mySecondaryOptionsComponent, "Center");
        this.myComponent.add((Component)contentPanel, "North");
        return this.myComponent;
    }

    public void setActive(boolean b) {
        GPOptionGroup[] optionGroups = this.getOptionGroups();
        if (!b) {
            for (int i = 0; i < optionGroups.length; ++i) {
                optionGroups[i].commit();
            }
        } else {
            for (int i = 0; i < optionGroups.length; ++i) {
                optionGroups[i].lock();
            }
            if (this.mySecondaryOptionsComponent != null) {
                this.mySecondaryOptionsComponent.removeAll();
            }
            this.mySecondaryOptionsComponent.add((Component)this.myOptionsBuilder.buildPlanePage(optionGroups), "North");
            this.mySecondaryOptionsComponent.invalidate();
            this.myComponent.invalidate();
            this.myChooser.setFileFilter(this.createFileFilter());
        }
    }

    protected void setSelectedFile(File file) {
        this.myChooser.setFile(file);
    }

    protected File getSelectedFile() {
        return this.myChooser.getFile();
    }

    protected void setOptionsEnabled(boolean enabled) {
        if (this.mySecondaryOptionsComponent != null) {
            this.setEnabledTree(this.mySecondaryOptionsComponent, enabled);
        }
    }

    private void setEnabledTree(JComponent root, boolean isEnabled) {
        root.setEnabled(isEnabled);
        Component[] components = root.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JComponent)) continue;
            this.setEnabledTree((JComponent)components[i], isEnabled);
        }
    }

    protected abstract FileFilter createFileFilter();

    protected abstract GPOptionGroup[] getOptionGroups();

    protected abstract void onFileChosen(File var1);
}

