/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sourceforge.ganttproject.gui.options.OptionsPageBuilder;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;

public class GPOptionChoicePanel {
    private ButtonGroup myExporterToggles;
    private AbstractButton[] myButtons;
    private JComponent[] myOptionComponents;
    private int mySelectedIndex;
    private String mySavedSelectedText;
    private OptionsPageBuilder myOptionPageBuilder = new OptionsPageBuilder();

    public Component getComponent(Action[] choiceChangeActions, GPOptionGroup[] choiceOptions, int selectedGroupIndex) {
        JComponent[] choiceComponents = new JComponent[choiceOptions.length];
        for (int i = 0; i < choiceChangeActions.length; ++i) {
            GPOptionGroup nextOptions = choiceOptions[i];
            JPanel nextOptionComponent = nextOptions == null ? new JPanel() : this.myOptionPageBuilder.buildPlanePage(new GPOptionGroup[]{nextOptions});
            choiceComponents[i] = nextOptionComponent;
        }
        return this.getComponent(choiceChangeActions, choiceComponents, selectedGroupIndex);
    }

    public JComponent getComponent(Action[] choiceChangeActions, JComponent[] choiceComponents, int selectedGroupIndex) {
        this.myButtons = new AbstractButton[choiceChangeActions.length];
        this.myOptionComponents = new JComponent[choiceChangeActions.length];
        Box result = Box.createVerticalBox();
        this.myExporterToggles = new ButtonGroup();
        for (int i = 0; i < choiceChangeActions.length; ++i) {
            JComponent nextOptionComponent;
            final int selectedIndex = i;
            final Action nextRealAction = choiceChangeActions[i];
            AbstractAction nextWrapperAction = new AbstractAction(String.valueOf(nextRealAction.getValue("Name"))){

                public void actionPerformed(ActionEvent e) {
                    nextRealAction.actionPerformed(e);
                    GPOptionChoicePanel.this.updateSelectionUI(selectedIndex);
                }
            };
            JRadioButton nextButton = new JRadioButton(nextWrapperAction);
            nextButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            JPanel nextExporterPanel = new JPanel(new BorderLayout());
            nextExporterPanel.add((Component)nextButton, "North");
            this.myButtons[i] = nextButton;
            this.myExporterToggles.add(nextButton);
            this.myOptionComponents[i] = nextOptionComponent = choiceComponents[i];
            nextOptionComponent.setBorder(BorderFactory.createEmptyBorder(0, 30, 20, 0));
            nextExporterPanel.add((Component)nextOptionComponent, "Center");
            this.setEnabledTree(nextOptionComponent, false);
            result.add(nextExporterPanel);
        }
        this.setSelected(selectedGroupIndex);
        return result;
    }

    private void updateSelectionUI(int selectedIndex) {
        AbstractButton prevSelected = this.myButtons[this.mySelectedIndex];
        prevSelected.setText(this.mySavedSelectedText);
        this.setEnabledTree(this.myOptionComponents[this.mySelectedIndex], false);
        this.setSelected(selectedIndex);
    }

    private void setSelected(int selectedIndex) {
        AbstractButton newSelected = this.myButtons[selectedIndex];
        this.mySavedSelectedText = newSelected.getText();
        newSelected.setText("<html><body><b><u>" + this.mySavedSelectedText + "</u></b></body></html>");
        this.mySelectedIndex = selectedIndex;
        newSelected.setSelected(true);
        this.setEnabledTree(this.myOptionComponents[this.mySelectedIndex], true);
    }

    private void setEnabledTree(JComponent root, boolean isEnabled) {
        root.setEnabled(isEnabled);
        Component[] components = root.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JComponent)) continue;
            this.setEnabledTree((JComponent)components[i], isEnabled);
        }
    }
}

