/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui.options.model;

import net.sourceforge.ganttproject.gui.options.model.BooleanOption;
import net.sourceforge.ganttproject.gui.options.model.GPAbstractOption;

public class DefaultBooleanOption
extends GPAbstractOption
implements BooleanOption {
    private boolean myValue;
    private boolean myLockedValue;

    public DefaultBooleanOption(String id) {
        super(id);
    }

    public boolean isChecked() {
        return this.myValue;
    }

    public void toggle() {
        this.myLockedValue = !this.myLockedValue;
    }

    public void lock() {
        super.lock();
        this.myLockedValue = this.myValue;
    }

    public void commit() {
        super.commit();
        this.myValue = this.myLockedValue;
    }

    public String getPersistentValue() {
        return Boolean.toString(this.isChecked());
    }

    public void loadPersistentValue(String value) {
        this.myLockedValue = Boolean.valueOf(value);
    }

    public boolean isChanged() {
        if (this.isLocked()) {
            return this.myValue != this.myLockedValue;
        }
        return false;
    }
}

