/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui.taskproperties;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.gui.TestGanttRolloverButton;
import net.sourceforge.ganttproject.gui.taskproperties.CommonPanel;
import net.sourceforge.ganttproject.gui.taskproperties.DependencyTableModel;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.task.dependency.TaskDependency;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyConstraint;
import net.sourceforge.ganttproject.task.dependency.constraint.FinishFinishConstraintImpl;
import net.sourceforge.ganttproject.task.dependency.constraint.FinishStartConstraintImpl;
import net.sourceforge.ganttproject.task.dependency.constraint.StartFinishConstraintImpl;
import net.sourceforge.ganttproject.task.dependency.constraint.StartStartConstraintImpl;

public class TaskDependenciesPanel
extends CommonPanel {
    protected GanttLanguage language = GanttLanguage.getInstance();
    private GridBagConstraints gbc = new GridBagConstraints();
    private JPanel predecessorsPanel;
    private JScrollPane predecessorsScrollPane;
    private JTable predecessorsTable;
    private final TaskManager myTaskManager;
    private DependencyTableModel myTableModel;
    private static TaskDependencyConstraint[] CONSTRAINTS = new TaskDependencyConstraint[]{new FinishStartConstraintImpl(), new FinishFinishConstraintImpl(), new StartFinishConstraintImpl(), new StartStartConstraintImpl()};
    private static TaskDependency.Hardness[] HARDNESS = new TaskDependency.Hardness[]{TaskDependency.Hardness.STRONG, TaskDependency.Hardness.RUBBER};

    public TaskDependenciesPanel(Task task) {
        super(task);
        this.myTaskManager = task.getManager();
    }

    public JPanel getComponent() {
        if (this.predecessorsPanel == null) {
            this.constructPredecessorsPanel();
        }
        return this.predecessorsPanel;
    }

    public DependencyTableModel getTableModel() {
        return this.myTableModel;
    }

    protected void constructPredecessorsPanel() {
        this.predecessorsPanel = new JPanel(new GridBagLayout());
        this.myTableModel = new DependencyTableModel(this.getTask());
        this.predecessorsTable = new JTable(this.myTableModel);
        this.predecessorsTable.setPreferredScrollableViewportSize(new Dimension(500, 130));
        this.setUpPredecessorComboColumn(this.predecessorsTable.getColumnModel().getColumn(1), this.predecessorsTable);
        this.setUpTypeComboColumn(this.predecessorsTable.getColumnModel().getColumn(2));
        this.setUpHardnessColumnEditor(this.predecessorsTable.getColumnModel().getColumn(4));
        this.predecessorsTable.setRowHeight(23);
        this.predecessorsTable.getColumnModel().getColumn(0).setPreferredWidth(10);
        this.predecessorsTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.predecessorsTable.getColumnModel().getColumn(2).setPreferredWidth(60);
        this.predecessorsTable.getColumnModel().getColumn(3).setPreferredWidth(40);
        this.predecessorsScrollPane = new JScrollPane(this.predecessorsTable);
        JPanel secondPredecessorsPanel = new JPanel();
        secondPredecessorsPanel.setBorder(new TitledBorder(new EtchedBorder(), this.language.getText("predecessors")));
        secondPredecessorsPanel.add(this.predecessorsScrollPane);
        TestGanttRolloverButton bremove = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/delete_16.gif")));
        bremove.setToolTipText(GanttProject.getToolTip(this.language.getText("removeRelationShip")));
        bremove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int[] selectedRow = TaskDependenciesPanel.this.predecessorsTable.getSelectedRows();
                for (int i = 0; i < selectedRow.length; ++i) {
                    TaskDependenciesPanel.this.predecessorsTable.getModel().setValueAt(null, selectedRow[i], 1);
                }
            }
        });
        secondPredecessorsPanel.add(bremove);
        this.gbc.anchor = 17;
        this.gbc.insets.right = 15;
        this.gbc.insets.left = 10;
        this.gbc.insets.top = 10;
        this.gbc.weighty = 0.0;
        this.addUsingGBL(this.predecessorsPanel, this.setupCommonFields(true), this.gbc, 0, 0, 1, 1);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 8;
        this.gbc.gridheight = 1;
        this.gbc.weighty = 1.0;
        this.predecessorsPanel.add((Component)secondPredecessorsPanel, this.gbc);
    }

    protected void setUpPredecessorComboColumn(TableColumn predecessorColumn, final JTable predecessorTable) {
        final JComboBox<DependencyTableModel.TaskComboItem> comboBox = new JComboBox<DependencyTableModel.TaskComboItem>();
        Task[] possiblePredecessors = this.myTaskManager.getAlgorithmCollection().getFindPossibleDependeesAlgorithm().run(this.getTask());
        for (int i = 0; i < possiblePredecessors.length; ++i) {
            Task next = possiblePredecessors[i];
            comboBox.addItem(new DependencyTableModel.TaskComboItem(next));
        }
        comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DependencyTableModel.TaskComboItem selectedItem;
                if (predecessorTable.getEditingRow() != -1 && (selectedItem = (DependencyTableModel.TaskComboItem)comboBox.getSelectedItem()) != null) {
                    predecessorTable.setValueAt(selectedItem, predecessorTable.getEditingRow(), 0);
                    predecessorTable.setValueAt(CONSTRAINTS[0], predecessorTable.getEditingRow(), 2);
                }
            }
        });
        comboBox.setEditable(false);
        predecessorColumn.setCellEditor(new DefaultCellEditor(comboBox));
    }

    private void setUpTypeComboColumn(TableColumn typeColumn) {
        DefaultComboBoxModel<TaskDependencyConstraint> model = new DefaultComboBoxModel<TaskDependencyConstraint>(CONSTRAINTS);
        JComboBox<TaskDependencyConstraint> comboBox = new JComboBox<TaskDependencyConstraint>(model);
        comboBox.setSelectedIndex(0);
        comboBox.setEditable(false);
        typeColumn.setCellEditor(new DefaultCellEditor(comboBox));
    }

    private void setUpHardnessColumnEditor(TableColumn hardnessColumn) {
        DefaultComboBoxModel<TaskDependency.Hardness> model = new DefaultComboBoxModel<TaskDependency.Hardness>(HARDNESS);
        JComboBox<TaskDependency.Hardness> comboBox = new JComboBox<TaskDependency.Hardness>(model);
        comboBox.setSelectedIndex(0);
        comboBox.setEditable(false);
        hardnessColumn.setCellEditor(new DefaultCellEditor(comboBox));
    }

    public JTable getTable() {
        return this.predecessorsTable;
    }
}

