/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.io;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.transform.sax.TransformerHandler;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.calendar.GPCalendar;
import net.sourceforge.ganttproject.io.SaverBase;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class CalendarSaver
extends SaverBase {
    private SimpleDateFormat myShortFormat = new SimpleDateFormat("EEE", Locale.ENGLISH);
    private Calendar myCalendar = GregorianCalendar.getInstance(Locale.ENGLISH);

    void save(IGanttProject project, TransformerHandler handler) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        this.startElement("calendars", attrs, handler);
        this.startElement("day-types", attrs, handler);
        this.addAttribute("id", "0", attrs);
        this.emptyElement("day-type", attrs, handler);
        this.addAttribute("id", "1", attrs);
        this.emptyElement("day-type", attrs, handler);
        this.addAttribute("id", "1", attrs);
        this.addAttribute("name", "default", attrs);
        this.startElement("calendar", attrs, handler);
        for (int i = 1; i <= 7; ++i) {
            boolean holiday = project.getActiveCalendar().getWeekDayType(i) == GPCalendar.DayType.WEEKEND;
            this.addAttribute(this.getShortDayName(i), holiday ? "1" : "0", attrs);
        }
        this.emptyElement("default-week", attrs, handler);
        this.emptyElement("overriden-day-types", attrs, handler);
        this.emptyElement("days", attrs, handler);
        this.endElement("calendar", handler);
        this.endElement("day-types", handler);
        Collection publicHoliday = project.getActiveCalendar().getPublicHolidays();
        Iterator iter = publicHoliday.iterator();
        while (iter.hasNext()) {
            Date d = (Date)iter.next();
            if (d.getYear() == -1899) {
                this.addAttribute("year", "", attrs);
            } else {
                this.addAttribute("year", d.getYear() + 1900 + "", attrs);
            }
            this.addAttribute("month", d.getMonth() + 1 + "", attrs);
            this.addAttribute("date", d.getDate() + "", attrs);
            this.emptyElement("date", attrs, handler);
        }
        this.endElement("calendars", handler);
    }

    private String getShortDayName(int i) {
        this.myCalendar.set(7, i);
        return this.myShortFormat.format(this.myCalendar.getTime()).toLowerCase();
    }
}

