/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.parser;

import java.io.IOException;
import java.util.ArrayList;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.GanttPreviousState;
import net.sourceforge.ganttproject.GanttPreviousStateTask;
import net.sourceforge.ganttproject.parser.TagHandler;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class PreviousStateTasksTagHandler
extends DefaultHandler
implements TagHandler {
    private String myName = "";
    private StringBuffer myCharacterBuffer = new StringBuffer();
    private String indent = "";
    private GanttPreviousState previousState;
    private String s = "    ";
    private ArrayList myPreviousStates;
    private ArrayList tasks = new ArrayList();

    public PreviousStateTasksTagHandler(ArrayList previousStates) {
        this.myPreviousStates = previousStates;
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) {
        if (qName.equals("previous-tasks")) {
            this.setName(attrs.getValue("name"));
            this.tasks = new ArrayList();
            if (this.myPreviousStates != null) {
                try {
                    this.previousState = new GanttPreviousState(this.myName);
                    this.myPreviousStates.add(this.previousState);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (qName.equals("previous-task")) {
            this.writePreviousTask(attrs);
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) {
        if (qName.equals("previous-tasks") && this.myPreviousStates != null) {
            this.previousState.saveFilesFromLoaded(this.tasks);
        }
    }

    private void setName(String name) {
        this.myName = name;
    }

    private void writePreviousTask(Attributes attrs) {
        String id = attrs.getValue("id");
        String meetingAsString = attrs.getValue("meeting");
        boolean meeting = false;
        if (meetingAsString.equals("true")) {
            meeting = true;
        }
        String start = attrs.getValue("start");
        String duration = attrs.getValue("duration");
        String nestedAsString = attrs.getValue("super");
        boolean nested = false;
        if (nestedAsString.equals("true")) {
            nested = true;
        }
        GanttPreviousStateTask task = new GanttPreviousStateTask(new Integer(id), GanttCalendar.parseXMLDate(start), new Integer(duration), meeting, nested);
        this.tasks.add(task);
    }

    public String getName() {
        return this.myName;
    }

    public ArrayList getTasks() {
        return this.tasks;
    }
}

