/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.parser;

import net.sourceforge.ganttproject.parser.TagHandler;
import net.sourceforge.ganttproject.roles.Role;
import net.sourceforge.ganttproject.roles.RoleManager;
import net.sourceforge.ganttproject.roles.RolePersistentID;
import net.sourceforge.ganttproject.roles.RoleSet;
import org.xml.sax.Attributes;

public class RoleTagHandler
implements TagHandler {
    private RoleSet myRoleSet;
    private final RoleManager myRoleManager;

    public RoleTagHandler(RoleManager roleManager) {
        this.myRoleManager = roleManager;
        this.myRoleManager.clear();
    }

    public void endElement(String namespaceURI, String sName, String qName) {
        if (qName.equals("roles")) {
            this.clearRoleSet();
        }
    }

    private void clearRoleSet() {
        this.myRoleSet = null;
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) {
        if (qName.equals("roles")) {
            this.findRoleSet(attrs.getValue("roleset-name"));
        } else if (qName.equals("role")) {
            this.loadRoles(attrs);
        }
    }

    private void findRoleSet(String roleSetName) {
        if (roleSetName == null) {
            this.myRoleSet = this.myRoleManager.getProjectRoleSet();
        } else {
            this.myRoleSet = this.myRoleManager.getRoleSet(roleSetName);
            if (this.myRoleSet == null) {
                this.myRoleSet = this.myRoleManager.createRoleSet(roleSetName);
            }
            this.myRoleSet.setEnabled(true);
        }
    }

    private void loadRoles(Attributes atts) {
        String roleName = atts.getValue("name");
        RolePersistentID persistentID = new RolePersistentID(atts.getValue("id"));
        Role existingRole = this.myRoleSet.findRole(persistentID.getRoleID());
        if (existingRole == null) {
            this.myRoleSet.createRole(roleName, persistentID.getRoleID());
        }
    }

    private RoleManager getRoleManager() {
        return this.myRoleManager;
    }
}

