/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.parser;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.GanttTreeTable;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.parser.ParsingListener;
import net.sourceforge.ganttproject.parser.TagHandler;
import net.sourceforge.ganttproject.task.CustomColumn;
import org.w3c.util.DateParser;
import org.w3c.util.InvalidDateException;
import org.xml.sax.Attributes;

public class TaskPropertiesTagHandler
implements TagHandler,
ParsingListener {
    private List columns = null;
    private GanttTreeTable treeTable = null;

    public TaskPropertiesTagHandler(GanttTreeTable ganttTreeTable) {
        this.treeTable = ganttTreeTable;
        this.columns = new ArrayList();
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) {
        if (qName.equals("taskproperty")) {
            this.loadTaskProperty(attrs);
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) {
    }

    private void loadTaskProperty(Attributes atts) {
        String name = atts.getValue("name");
        String id = atts.getValue("id");
        String type = atts.getValue("valuetype");
        if (atts.getValue("type").equals("custom")) {
            String valueStr = atts.getValue("defaultvalue");
            Object defValue = null;
            Class clType = null;
            if (type.equals("text")) {
                clType = String.class;
                defValue = valueStr.toString();
            } else if (type.equals("boolean")) {
                clType = Boolean.class;
                defValue = Boolean.valueOf(valueStr);
            } else if (type.equals("int")) {
                clType = Integer.class;
                defValue = Integer.valueOf(valueStr);
            } else if (type.equals("double")) {
                clType = Double.class;
                defValue = Double.valueOf(valueStr);
            } else if (type.equals("date")) {
                clType = GregorianCalendar.class;
                try {
                    defValue = new GanttCalendar(DateParser.parse(valueStr));
                }
                catch (InvalidDateException e) {
                    e.printStackTrace();
                }
            } else {
                clType = String.class;
                defValue = "";
            }
            CustomColumn cc = new CustomColumn(name, clType, defValue);
            cc.setId(id);
            Mediator.getCustomColumnsManager().addNewCustomColumn(cc);
        }
    }

    public void parsingStarted() {
    }

    public void parsingFinished() {
    }
}

