/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.time;

import java.util.Date;
import net.sourceforge.ganttproject.time.TextFormatter;
import net.sourceforge.ganttproject.time.TimeUnit;
import net.sourceforge.ganttproject.time.TimeUnitGraph;
import net.sourceforge.ganttproject.time.TimeUnitText;

public class TimeUnitImpl
implements TimeUnit {
    private final String myName;
    private final TimeUnitGraph myGraph;
    private final TimeUnit myDirectAtomUnit;
    private TextFormatter myTextFormatter;

    public TimeUnitImpl(String name, TimeUnitGraph graph, TimeUnit directAtomUnit) {
        this.myName = name;
        this.myGraph = graph;
        this.myDirectAtomUnit = directAtomUnit;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isConstructedFrom(TimeUnit atomUnit) {
        return this.myGraph.getComposition(this, atomUnit) != null;
    }

    public int getAtomCount(TimeUnit atomUnit) {
        TimeUnitGraph.Composition composition = this.myGraph.getComposition(this, atomUnit);
        if (composition == null) {
            throw new RuntimeException("Failed to find a composition of time unit=" + this + " from time unit=" + atomUnit);
        }
        return composition.getAtomCount();
    }

    public TimeUnit getDirectAtomUnit() {
        return this.myDirectAtomUnit;
    }

    public String toString() {
        return this.getName() + " hash=" + this.hashCode();
    }

    public void setTextFormatter(TextFormatter formatter) {
        this.myTextFormatter = formatter;
    }

    public TimeUnitText format(Date baseDate) {
        return this.myTextFormatter == null ? new TimeUnitText("") : this.myTextFormatter.format(this, baseDate);
    }

    protected TextFormatter getTextFormatter() {
        return this.myTextFormatter;
    }

    public Date adjustRight(Date baseDate) {
        throw new UnsupportedOperationException("Time unit=" + this + " doesnt support this operation");
    }

    public Date adjustLeft(Date baseDate) {
        throw new UnsupportedOperationException("Time unit=" + this + " doesnt support this operation");
    }

    public Date jumpLeft(Date baseDate) {
        throw new UnsupportedOperationException("Time unit=" + this + " doesnt support this operation");
    }
}

