/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.junit;

import com.tapsterrock.mpp.MPPFile;
import com.tapsterrock.mpx.MPXCalendar;
import com.tapsterrock.mpx.MPXDuration;
import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.ProjectHeader;
import com.tapsterrock.mpx.Relation;
import com.tapsterrock.mpx.Resource;
import com.tapsterrock.mpx.ResourceAssignment;
import com.tapsterrock.mpx.Task;
import com.tapsterrock.mpx.TimeUnit;
import com.tapsterrock.mspdi.MSPDIFile;
import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import junit.framework.TestCase;

public class MPXJTest
extends TestCase {
    private String m_basedir = System.getProperty("mpxj.junit.datadir");

    public MPXJTest(String s) throws Exception {
        super(s);
        if (this.m_basedir == null || this.m_basedir.length() == 0) {
            throw new Exception("missing datadir property");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRewrite1() throws Exception {
        block3: {
            File out = null;
            boolean success = true;
            try {
                File in = new File(this.m_basedir + "/sample.mpx");
                MPXFile mpx = new MPXFile(in);
                out = File.createTempFile("junit", ".mpx");
                mpx.write(out);
                success = this.compareFiles(in, out);
                MPXJTest.assertTrue((String)"Files are not identical", (boolean)success);
                Object var6_5 = null;
                if (out == null || !success) break block3;
                out.delete();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (out != null && success) {
                    out.delete();
                }
                throw throwable;
            }
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRewrite2() throws Exception {
        block3: {
            File out = null;
            boolean success = true;
            try {
                File in = new File(this.m_basedir + "/sample1.xml");
                MSPDIFile xml = new MSPDIFile(in);
                out = File.createTempFile("junit", ".xml");
                xml.write(out);
                success = this.compareFiles(in, out);
                MPXJTest.assertTrue((String)"Files are not identical", (boolean)success);
                Object var6_5 = null;
                if (out == null || !success) break block3;
                out.delete();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (out != null && success) {
                    out.delete();
                }
                throw throwable;
            }
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRewrite3() throws Exception {
        block3: {
            File out = null;
            boolean success = true;
            try {
                File in = new File(this.m_basedir + "/sample1.mpx");
                MPXFile mpx = new MPXFile(in);
                out = File.createTempFile("junit", ".mpx");
                mpx.write(out);
                success = this.compareFiles(in, out);
                MPXJTest.assertTrue((String)"Files are not identical", (boolean)success);
                Object var6_5 = null;
                if (out == null || !success) break block3;
                out.delete();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (out != null && success) {
                    out.delete();
                }
                throw throwable;
            }
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRewrite4() throws Exception {
        block3: {
            File out = null;
            boolean success = true;
            try {
                File in = new File(this.m_basedir + "/sample.mpx");
                MPXFile mpx = new MPXFile(in);
                out = File.createTempFile("junit", ".mpx");
                mpx.setLocale(Locale.GERMAN);
                mpx.write(out);
                mpx = new MPXFile();
                mpx.setLocale(Locale.GERMAN);
                mpx.read(out);
                Object var6_5 = null;
                if (out == null || !success) break block3;
                out.delete();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (out != null && success) {
                    out.delete();
                }
                throw throwable;
            }
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRewrite5() throws Exception {
        block3: {
            File out = null;
            boolean success = true;
            try {
                Locale swedish = new Locale("sv");
                File in = new File(this.m_basedir + "/sample.mpx");
                MPXFile mpx = new MPXFile(in);
                out = File.createTempFile("junit", ".mpx");
                mpx.setLocale(swedish);
                mpx.write(out);
                mpx = new MPXFile();
                mpx.setLocale(swedish);
                mpx.read(out);
                Object var7_6 = null;
                if (out == null || !success) break block3;
                out.delete();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (out != null && success) {
                    out.delete();
                }
                throw throwable;
            }
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRewrite6() throws Exception {
        block3: {
            File out = null;
            boolean success = true;
            try {
                Locale portuguese = new Locale("pt");
                File in = new File(this.m_basedir + "/sample.mpx");
                MPXFile mpx = new MPXFile(in);
                out = File.createTempFile("junit", ".mpx");
                mpx.setLocale(portuguese);
                mpx.write(out);
                mpx = new MPXFile();
                mpx.setLocale(portuguese);
                mpx.read(out);
                Object var7_6 = null;
                if (out == null || !success) break block3;
                out.delete();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (out != null && success) {
                    out.delete();
                }
                throw throwable;
            }
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRewrite7() throws Exception {
        block3: {
            File out = null;
            boolean success = true;
            try {
                Locale french = new Locale("fr");
                File in = new File(this.m_basedir + "/sample.mpx");
                MPXFile mpx = new MPXFile(in);
                out = File.createTempFile("junit", ".mpx");
                mpx.setLocale(french);
                mpx.write(out);
                mpx = new MPXFile();
                mpx.setLocale(french);
                mpx.read(out);
                Object var7_6 = null;
                if (out == null || !success) break block3;
                out.delete();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (out != null && success) {
                    out.delete();
                }
                throw throwable;
            }
            {
            }
        }
    }

    public void testRead1() throws Exception {
        File in = new File(this.m_basedir + "/sample.de.mpx");
        MPXFile mpx = new MPXFile();
        mpx.setLocale(Locale.GERMAN);
        mpx.read(in);
    }

    public void testAutomaticGeneration() throws Exception {
        MPXFile file = new MPXFile();
        file.setAutoWBS(true);
        file.setAutoOutlineLevel(true);
        file.setAutoOutlineNumber(true);
        file.setAutoTaskID(true);
        file.setAutoTaskUniqueID(true);
        file.setAutoResourceID(true);
        file.setAutoResourceUniqueID(true);
        Resource resource1 = file.addResource();
        resource1.setName("R1");
        MPXJTest.assertEquals((int)resource1.getUniqueIDValue(), (int)1);
        MPXJTest.assertEquals((int)resource1.getIDValue(), (int)1);
        Resource resource2 = file.addResource();
        resource2.setName("R2");
        MPXJTest.assertEquals((int)resource2.getUniqueIDValue(), (int)2);
        MPXJTest.assertEquals((int)resource2.getIDValue(), (int)2);
        Task task1 = file.addTask();
        task1.setName("1.0");
        MPXJTest.assertEquals((String)task1.getWBS(), (String)"1.0");
        MPXJTest.assertEquals((int)task1.getOutlineLevelValue(), (int)1);
        MPXJTest.assertEquals((String)task1.getOutlineNumber(), (String)"1.0");
        MPXJTest.assertEquals((int)task1.getIDValue(), (int)1);
        MPXJTest.assertEquals((int)task1.getUniqueIDValue(), (int)1);
        MPXJTest.assertEquals((boolean)task1.getSummaryValue(), (boolean)false);
        task1 = file.addTask();
        task1.setName("2.0");
        MPXJTest.assertEquals((String)task1.getWBS(), (String)"2.0");
        MPXJTest.assertEquals((int)task1.getOutlineLevelValue(), (int)1);
        MPXJTest.assertEquals((String)task1.getOutlineNumber(), (String)"2.0");
        MPXJTest.assertEquals((int)task1.getIDValue(), (int)2);
        MPXJTest.assertEquals((int)task1.getUniqueIDValue(), (int)2);
        MPXJTest.assertEquals((boolean)task1.getSummaryValue(), (boolean)false);
        task1 = file.addTask();
        task1.setName("3.0");
        MPXJTest.assertEquals((String)task1.getWBS(), (String)"3.0");
        MPXJTest.assertEquals((int)task1.getOutlineLevelValue(), (int)1);
        MPXJTest.assertEquals((String)task1.getOutlineNumber(), (String)"3.0");
        MPXJTest.assertEquals((int)task1.getIDValue(), (int)3);
        MPXJTest.assertEquals((int)task1.getUniqueIDValue(), (int)3);
        MPXJTest.assertEquals((boolean)task1.getSummaryValue(), (boolean)false);
        Task task2 = task1.addTask();
        task2.setName("3.1");
        MPXJTest.assertEquals((String)task2.getWBS(), (String)"3.1");
        MPXJTest.assertEquals((int)task2.getOutlineLevelValue(), (int)2);
        MPXJTest.assertEquals((String)task2.getOutlineNumber(), (String)"3.1");
        MPXJTest.assertEquals((int)task2.getIDValue(), (int)4);
        MPXJTest.assertEquals((int)task2.getUniqueIDValue(), (int)4);
        MPXJTest.assertEquals((boolean)task1.getSummaryValue(), (boolean)true);
        MPXJTest.assertEquals((boolean)task2.getSummaryValue(), (boolean)false);
        task2 = task1.addTask();
        task2.setName("3.2");
        MPXJTest.assertEquals((String)task2.getWBS(), (String)"3.2");
        MPXJTest.assertEquals((int)task2.getOutlineLevelValue(), (int)2);
        MPXJTest.assertEquals((String)task2.getOutlineNumber(), (String)"3.2");
        MPXJTest.assertEquals((int)task2.getIDValue(), (int)5);
        MPXJTest.assertEquals((int)task2.getUniqueIDValue(), (int)5);
        MPXJTest.assertEquals((boolean)task1.getSummaryValue(), (boolean)true);
        MPXJTest.assertEquals((boolean)task2.getSummaryValue(), (boolean)false);
        Task task3 = task2.addTask();
        task3.setName("3.2.1");
        MPXJTest.assertEquals((String)task3.getWBS(), (String)"3.2.1");
        MPXJTest.assertEquals((int)task3.getOutlineLevelValue(), (int)3);
        MPXJTest.assertEquals((String)task3.getOutlineNumber(), (String)"3.2.1");
        MPXJTest.assertEquals((int)task3.getIDValue(), (int)6);
        MPXJTest.assertEquals((int)task3.getUniqueIDValue(), (int)6);
        MPXJTest.assertEquals((boolean)task1.getSummaryValue(), (boolean)true);
        MPXJTest.assertEquals((boolean)task2.getSummaryValue(), (boolean)true);
        MPXJTest.assertEquals((boolean)task3.getSummaryValue(), (boolean)false);
        task3 = task2.addTask();
        task3.setName("3.2.2");
        MPXJTest.assertEquals((String)task3.getWBS(), (String)"3.2.2");
        MPXJTest.assertEquals((int)task3.getOutlineLevelValue(), (int)3);
        MPXJTest.assertEquals((String)task3.getOutlineNumber(), (String)"3.2.2");
        MPXJTest.assertEquals((int)task3.getIDValue(), (int)7);
        MPXJTest.assertEquals((int)task3.getUniqueIDValue(), (int)7);
        MPXJTest.assertEquals((boolean)task1.getSummaryValue(), (boolean)true);
        MPXJTest.assertEquals((boolean)task2.getSummaryValue(), (boolean)true);
        MPXJTest.assertEquals((boolean)task3.getSummaryValue(), (boolean)false);
    }

    public void testStructure() throws Exception {
        MPXFile file = new MPXFile();
        file.setAutoWBS(true);
        file.setAutoOutlineLevel(true);
        file.setAutoTaskID(true);
        file.setAutoTaskUniqueID(true);
        Task task1 = file.addTask();
        MPXJTest.assertNull((Object)task1.getParentTask());
        Task task2 = task1.addTask();
        MPXJTest.assertEquals((Object)task2.getParentTask(), (Object)task1);
        task1.addTask();
        LinkedList children = task1.getChildTasks();
        MPXJTest.assertEquals((int)children.size(), (int)2);
        LinkedList toplevel = file.getChildTasks();
        MPXJTest.assertEquals((int)toplevel.size(), (int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConversion1() throws Exception {
        File out = null;
        try {
            File in = new File(this.m_basedir + "/sample98.mpp");
            MPPFile mpp = new MPPFile(in);
            out = File.createTempFile("junit", ".mpx");
            mpp.write(out);
            this.commonTests(mpp);
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConversion2() throws Exception {
        File out = null;
        try {
            File in = new File(this.m_basedir + "/sample.mpp");
            MPPFile mpp = new MPPFile(in);
            out = File.createTempFile("junit", ".mpx");
            mpp.write(out);
            this.commonTests(mpp);
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConversion3() throws Exception {
        File out = null;
        try {
            File in = new File(this.m_basedir + "/sample.xml");
            MSPDIFile xml = new MSPDIFile(in);
            out = File.createTempFile("junit", ".mpx");
            xml.write(out);
            this.commonTests(xml);
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    private void commonTests(MPXFile file) {
        Task task = file.getTaskByUniqueID(2);
        LinkedList assignments = task.getResourceAssignments();
        MPXJTest.assertEquals((int)2, (int)assignments.size());
        Iterator iter = assignments.iterator();
        block4: while (iter.hasNext()) {
            ResourceAssignment assignment = (ResourceAssignment)iter.next();
            switch (assignment.getResourceIDValue()) {
                case 1: {
                    MPXJTest.assertEquals((String)"200h", (String)assignment.getRemainingWork().toString());
                    continue block4;
                }
                case 2: {
                    MPXJTest.assertEquals((String)"300h", (String)assignment.getRemainingWork().toString());
                    continue block4;
                }
            }
            MPXJTest.assertTrue((String)"Unexpected resource", (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConversion4() throws Exception {
        File out = null;
        try {
            File in = new File(this.m_basedir + "/sample.mpp");
            MPPFile mpp = new MPPFile(in);
            out = File.createTempFile("junit", ".mpx");
            mpp.write(out);
            MPXFile mpx = new MPXFile(out);
            out.delete();
            MSPDIFile mspdi = new MSPDIFile(mpx);
            out = File.createTempFile("junit", ".xml");
            mspdi.write(out);
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    public void testRelationList() throws Exception {
        File in = new File(this.m_basedir + "/sample.mpx");
        MPXFile mpx = new MPXFile(in);
        LinkedList tasks = mpx.getAllTasks();
        Iterator taskIter = tasks.iterator();
        while (taskIter.hasNext()) {
            Task task = (Task)taskIter.next();
            List rels = task.getPredecessors();
            if (rels == null) continue;
            Iterator relIter = rels.iterator();
            while (relIter.hasNext()) {
                Relation rel = (Relation)relIter.next();
                mpx.getTaskByUniqueID(rel.getTaskIDValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTaskNotes() throws Exception {
        File out = null;
        try {
            String notes1 = "Notes, containing a comma. Done.";
            String notes2 = "Notes \"containing embedded quotes\" Done.";
            String notes3 = "Notes, \"containing embedded quotes, and comma's too.\" Done.";
            String notes4 = "\"Notes containing embedded quotes as first and last chars. Done.\"";
            String notes5 = "Normal unquoted notes. Done.";
            MPXFile file1 = new MPXFile();
            file1.setAutoWBS(true);
            file1.setAutoOutlineLevel(true);
            file1.setAutoTaskID(true);
            file1.setAutoTaskUniqueID(true);
            Task task1 = file1.addTask();
            task1.setName("Test Task 1");
            task1.setDuration(MPXDuration.getInstance(10, TimeUnit.DAYS));
            task1.setStart(new Date());
            task1.setNotes(notes1);
            Task task2 = file1.addTask();
            task2.setName("Test Task 2");
            task2.setDuration(MPXDuration.getInstance(10, TimeUnit.DAYS));
            task2.setStart(new Date());
            task2.setNotes(notes2);
            Task task3 = file1.addTask();
            task3.setName("Test Task 3");
            task3.setDuration(MPXDuration.getInstance(10, TimeUnit.DAYS));
            task3.setStart(new Date());
            task3.setNotes(notes3);
            Task task4 = file1.addTask();
            task4.setName("Test Task 4");
            task4.setDuration(MPXDuration.getInstance(10, TimeUnit.DAYS));
            task4.setStart(new Date());
            task4.setNotes(notes4);
            Task task5 = file1.addTask();
            task5.setName("Test Task 5");
            task5.setDuration(MPXDuration.getInstance(10, TimeUnit.DAYS));
            task5.setStart(new Date());
            task5.setNotes(notes5);
            out = File.createTempFile("junit", ".mpx");
            file1.write(out);
            MPXFile file2 = new MPXFile(out);
            Task task1a = file2.getTaskByUniqueID(task1.getUniqueIDValue());
            String notes = task1a.getNotes();
            MPXJTest.assertEquals((String)notes1, (String)notes);
            Task task2a = file2.getTaskByUniqueID(task2.getUniqueIDValue());
            notes = task2a.getNotes();
            MPXJTest.assertEquals((String)notes2, (String)notes);
            Task task3a = file2.getTaskByUniqueID(task3.getUniqueIDValue());
            notes = task3a.getNotes();
            MPXJTest.assertEquals((String)notes3, (String)notes);
            Task task4a = file2.getTaskByUniqueID(task4.getUniqueIDValue());
            notes = task4a.getNotes();
            MPXJTest.assertEquals((String)notes4, (String)notes);
            Task task5a = file2.getTaskByUniqueID(task5.getUniqueIDValue());
            notes = task5a.getNotes();
            MPXJTest.assertEquals((String)notes5, (String)notes);
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResourceNotes() throws Exception {
        File out = null;
        try {
            String notes1 = "Notes, containing a comma. Done.";
            String notes2 = "Notes \"containing embedded quotes\" Done.";
            String notes3 = "Notes, \"containing embedded quotes, and comma's too.\" Done.";
            String notes4 = "\"Notes containing embedded quotes as first and last chars. Done.\"";
            String notes5 = "Normal unquoted notes. Done.";
            MPXFile file1 = new MPXFile();
            file1.setAutoWBS(true);
            file1.setAutoOutlineLevel(true);
            file1.setAutoResourceID(true);
            file1.setAutoResourceUniqueID(true);
            Resource resource1 = file1.addResource();
            resource1.setName("Test Resource 1");
            resource1.setNotes(notes1);
            Resource resource2 = file1.addResource();
            resource2.setName("Test Resource 2");
            resource2.setNotes(notes2);
            Resource resource3 = file1.addResource();
            resource3.setName("Test Resource 3");
            resource3.setNotes(notes3);
            Resource resource4 = file1.addResource();
            resource4.setName("Test Resource 4");
            resource4.setNotes(notes4);
            Resource resource5 = file1.addResource();
            resource5.setName("Test Resource 5");
            resource5.setNotes(notes5);
            out = File.createTempFile("junit", ".mpx");
            file1.write(out);
            MPXFile file2 = new MPXFile(out);
            Resource resource1a = file2.getResourceByUniqueID(resource1.getUniqueIDValue());
            String notes = resource1a.getNotes();
            MPXJTest.assertEquals((String)notes1, (String)notes);
            Resource resource2a = file2.getResourceByUniqueID(resource2.getUniqueIDValue());
            notes = resource2a.getNotes();
            MPXJTest.assertEquals((String)notes2, (String)notes);
            Resource resource3a = file2.getResourceByUniqueID(resource3.getUniqueIDValue());
            notes = resource3a.getNotes();
            MPXJTest.assertEquals((String)notes3, (String)notes);
            Resource resource4a = file2.getResourceByUniqueID(resource4.getUniqueIDValue());
            notes = resource4a.getNotes();
            MPXJTest.assertEquals((String)notes4, (String)notes);
            Resource resource5a = file2.getResourceByUniqueID(resource5.getUniqueIDValue());
            notes = resource5a.getNotes();
            MPXJTest.assertEquals((String)notes5, (String)notes);
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug1() throws Exception {
        File out = null;
        try {
            File in = new File(this.m_basedir + "/bug1.mpp");
            MPPFile mpp = new MPPFile(in);
            out = File.createTempFile("junit", ".mpx");
            mpp.write(out);
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug2() throws Exception {
        File out = null;
        try {
            File in = new File(this.m_basedir + "/bug2.mpp");
            MPPFile mpp = new MPPFile(in);
            out = File.createTempFile("junit", ".mpx");
            mpp.write(out);
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug3() throws Exception {
        File out = null;
        try {
            File in = new File(this.m_basedir + "/bug3.mpp");
            MPPFile mpp = new MPPFile(in);
            LinkedList tasks = mpp.getAllTasks();
            Iterator iter = tasks.iterator();
            while (iter.hasNext()) {
                Task task = (Task)iter.next();
                MPXJTest.assertEquals((String)"Outline levels do not match", (int)task.getOutlineLevelValue(), (int)this.calculateOutlineLevel(task));
            }
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug4() throws Exception {
        File out = null;
        try {
            File in = new File(this.m_basedir + "/bug4.mpp");
            MPPFile mpp = new MPPFile(in);
            out = File.createTempFile("junit", ".mpx");
            mpp.write(out);
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    private int calculateOutlineLevel(Task task) {
        int level = 0;
        while (task != null) {
            task = task.getParentTask();
            ++level;
        }
        return level;
    }

    private boolean compareFiles(File file1, File file2) throws Exception {
        boolean result;
        if (file1.length() != file2.length()) {
            result = false;
        } else {
            int c1;
            result = true;
            FileInputStream input1 = new FileInputStream(file1);
            FileInputStream input2 = new FileInputStream(file2);
            do {
                int c2;
                if ((c1 = input1.read()) == (c2 = input2.read())) continue;
                result = false;
                break;
            } while (c1 != -1);
            input1.close();
            input2.close();
        }
        return result;
    }

    public void testBaseCalendarGetDate() throws Exception {
        MPXFile file = new MPXFile();
        MPXCalendar cal = file.addDefaultBaseCalendar();
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        Date startDate = df.parse("09/10/2003");
        MPXDuration duration = MPXDuration.getInstance(1, TimeUnit.DAYS);
        Date endDate = cal.getDate(startDate, duration);
        MPXJTest.assertEquals((long)endDate.getTime(), (long)df.parse("10/10/2003").getTime());
        duration = MPXDuration.getInstance(7, TimeUnit.DAYS);
        endDate = cal.getDate(startDate, duration);
        MPXJTest.assertEquals((long)endDate.getTime(), (long)df.parse("18/10/2003").getTime());
        duration = MPXDuration.getInstance(1, TimeUnit.WEEKS);
        endDate = cal.getDate(startDate, duration);
        MPXJTest.assertEquals((long)endDate.getTime(), (long)df.parse("18/10/2003").getTime());
        duration = MPXDuration.getInstance(-1, TimeUnit.DAYS);
        endDate = cal.getDate(startDate, duration);
        MPXJTest.assertEquals((long)endDate.getTime(), (long)df.parse("08/10/2003").getTime());
    }

    public void testMPP8Flags1() throws Exception {
        File in = new File(this.m_basedir + "/mpp8flags1.mpp");
        MPPFile mpp = new MPPFile(in);
        LinkedList tasks = mpp.getAllTasks();
        MPXJTest.assertTrue((String)"Not enough tasks", (tasks.size() > 0 ? 1 : 0) != 0);
        MPXJTest.assertTrue((String)"Not an even number of tasks", (tasks.size() % 2 == 0 ? 1 : 0) != 0);
        Iterator iter = tasks.iterator();
        while (iter.hasNext()) {
            Task task = (Task)iter.next();
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag1Value());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag2Value());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag3Value());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag4Value());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag5Value());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag6Value());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag7Value());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag8Value());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag9Value());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag10Value());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag11());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag12());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag13());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag14());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag15());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag16());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag17());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag18());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag19());
            task = (Task)iter.next();
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag1Value());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag2Value());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag3Value());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag4Value());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag5Value());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag6Value());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag7Value());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag8Value());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag9Value());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag10Value());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag11());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag12());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag13());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag14());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag15());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag16());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag17());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag18());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag19());
        }
    }

    public void testMPP8Flags2() throws Exception {
        File in = new File(this.m_basedir + "/mpp8flags2.mpp");
        MPPFile mpp = new MPPFile(in);
        LinkedList tasks = mpp.getAllTasks();
        Iterator iter = tasks.iterator();
        int index = 0;
        while (iter.hasNext()) {
            Task task = (Task)iter.next();
            if (task.getName().startsWith("Parent")) continue;
            boolean[] flags = this.getFlagArray(task);
            MPXJTest.assertTrue((String)("Incorrect flag set in task " + task.getName()), (boolean)this.testSingleFlagTrue(flags, index));
            if (++index != 20) continue;
            index = 0;
        }
    }

    public void testMPP9Flags1() throws Exception {
        File in = new File(this.m_basedir + "/mpp9flags1.mpp");
        MPPFile mpp = new MPPFile(in);
        LinkedList tasks = mpp.getAllTasks();
        MPXJTest.assertTrue((String)"Not enough tasks", (tasks.size() > 0 ? 1 : 0) != 0);
        MPXJTest.assertTrue((String)"Not an even number of tasks", (tasks.size() % 2 == 0 ? 1 : 0) != 0);
        Iterator iter = tasks.iterator();
        while (iter.hasNext()) {
            Task task = (Task)iter.next();
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag1Value());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag2Value());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag3Value());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag4Value());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag5Value());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag6Value());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag7Value());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag8Value());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag9Value());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag10Value());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag11());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag12());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag13());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag14());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag15());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag16());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag17());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag18());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag19());
            MPXJTest.assertFalse((String)task.getName(), (boolean)task.getFlag20());
            task = (Task)iter.next();
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag1Value());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag2Value());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag3Value());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag4Value());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag5Value());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag6Value());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag7Value());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag8Value());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag9Value());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag10Value());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag11());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag12());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag13());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag14());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag15());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag16());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag17());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag18());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag19());
            MPXJTest.assertTrue((String)task.getName(), (boolean)task.getFlag20());
        }
    }

    public void testMPP9Flags2() throws Exception {
        File in = new File(this.m_basedir + "/mpp8flags2.mpp");
        MPPFile mpp = new MPPFile(in);
        LinkedList tasks = mpp.getAllTasks();
        Iterator iter = tasks.iterator();
        int index = 0;
        while (iter.hasNext()) {
            Task task = (Task)iter.next();
            if (task.getName().startsWith("Parent")) continue;
            boolean[] flags = this.getFlagArray(task);
            MPXJTest.assertTrue((String)("Incorrect flag set in task " + task.getName()), (boolean)this.testSingleFlagTrue(flags, index));
            if (++index != 20) continue;
            index = 0;
        }
    }

    private boolean[] getFlagArray(Task task) {
        boolean[] flags = new boolean[]{task.getFlag1Value(), task.getFlag2Value(), task.getFlag3Value(), task.getFlag4Value(), task.getFlag5Value(), task.getFlag6Value(), task.getFlag7Value(), task.getFlag8Value(), task.getFlag9Value(), task.getFlag10Value(), task.getFlag11(), task.getFlag12(), task.getFlag13(), task.getFlag14(), task.getFlag15(), task.getFlag16(), task.getFlag17(), task.getFlag18(), task.getFlag19(), task.getFlag20()};
        return flags;
    }

    private boolean testSingleFlagTrue(boolean[] flags, int index) {
        boolean result = true;
        for (int loop = 0; loop < flags.length; ++loop) {
            if (!flags[loop] || loop == index) continue;
            result = false;
            break;
        }
        return result;
    }

    public void testViews() throws Exception {
        MPPFile mpp = new MPPFile(this.m_basedir + "/sample98.mpp");
        ArrayList views = mpp.getViews();
        MPXJTest.assertEquals((String)"Incorrect number of views", (int)1, (int)views.size());
        mpp = new MPPFile(this.m_basedir + "/sample.mpp");
        views = mpp.getViews();
        MPXJTest.assertEquals((String)"Incorrect number of views", (int)3, (int)views.size());
    }

    public void testTables() throws Exception {
        MPPFile mpp = new MPPFile(this.m_basedir + "/sample98.mpp");
        ArrayList tables = mpp.getTables();
        MPXJTest.assertEquals((String)"Incorrect number of tables", (int)1, (int)tables.size());
        mpp = new MPPFile(this.m_basedir + "/sample.mpp");
        tables = mpp.getTables();
        MPXJTest.assertEquals((String)"Incorrect number of tables", (int)2, (int)tables.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTaskCalendars() throws Exception {
        File out = null;
        try {
            MPXCalendar cal;
            Task task;
            File in = new File(this.m_basedir + "/sample1.mpp");
            MPPFile mpp = new MPPFile(in);
            Iterator iter = mpp.getAllTasks().iterator();
            while (iter.hasNext()) {
                task = (Task)iter.next();
                cal = task.getCalendar();
                if (cal == null) continue;
                MPXJTest.assertEquals((String)task.getName(), (String)cal.getName());
            }
            MSPDIFile mspdi = new MSPDIFile(mpp);
            out = File.createTempFile("junit", ".xml");
            mspdi.write(out);
            mspdi = new MSPDIFile(out.getCanonicalPath());
            iter = mspdi.getAllTasks().iterator();
            while (iter.hasNext()) {
                task = (Task)iter.next();
                cal = task.getCalendar();
                if (cal == null) continue;
                MPXJTest.assertEquals((String)task.getName(), (String)cal.getName());
            }
        }
        finally {
            if (out != null) {
                out.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMSPDIAliases() throws Exception {
        block3: {
            File out = null;
            boolean success = true;
            try {
                File in = new File(this.m_basedir + "/alias.xml");
                MSPDIFile xml = new MSPDIFile(in);
                this.validateAliases(xml);
                out = File.createTempFile("junit", ".xml");
                xml.write(out);
                xml = new MSPDIFile(out);
                this.validateAliases(xml);
                success = true;
                Object var6_5 = null;
                if (out == null || !success) break block3;
                out.delete();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (out != null && success) {
                    out.delete();
                }
                throw throwable;
            }
            {
            }
        }
    }

    public void testMPP9Aliases() throws Exception {
        File in = new File(this.m_basedir + "/alias.mpp");
        MPPFile mpp = new MPPFile(in);
        this.validateAliases(mpp);
    }

    private void validateAliases(MPXFile mpx) {
        MPXJTest.assertEquals((String)"Text1t", (String)mpx.getTaskFieldAlias(4));
        MPXJTest.assertEquals((String)"Text2t", (String)mpx.getTaskFieldAlias(5));
        MPXJTest.assertEquals((String)"Text3t", (String)mpx.getTaskFieldAlias(6));
        MPXJTest.assertEquals((String)"Text4t", (String)mpx.getTaskFieldAlias(7));
        MPXJTest.assertEquals((String)"Text5t", (String)mpx.getTaskFieldAlias(8));
        MPXJTest.assertEquals((String)"Text6t", (String)mpx.getTaskFieldAlias(9));
        MPXJTest.assertEquals((String)"Text7t", (String)mpx.getTaskFieldAlias(10));
        MPXJTest.assertEquals((String)"Text8t", (String)mpx.getTaskFieldAlias(11));
        MPXJTest.assertEquals((String)"Text9t", (String)mpx.getTaskFieldAlias(12));
        MPXJTest.assertEquals((String)"Text10t", (String)mpx.getTaskFieldAlias(13));
        MPXJTest.assertEquals((String)"Text11t", (String)mpx.getTaskFieldAlias(1000));
        MPXJTest.assertEquals((String)"Text12t", (String)mpx.getTaskFieldAlias(1001));
        MPXJTest.assertEquals((String)"Text13t", (String)mpx.getTaskFieldAlias(1002));
        MPXJTest.assertEquals((String)"Text14t", (String)mpx.getTaskFieldAlias(1003));
        MPXJTest.assertEquals((String)"Text15t", (String)mpx.getTaskFieldAlias(1004));
        MPXJTest.assertEquals((String)"Text16t", (String)mpx.getTaskFieldAlias(1005));
        MPXJTest.assertEquals((String)"Text17t", (String)mpx.getTaskFieldAlias(1006));
        MPXJTest.assertEquals((String)"Text18t", (String)mpx.getTaskFieldAlias(1007));
        MPXJTest.assertEquals((String)"Text19t", (String)mpx.getTaskFieldAlias(1008));
        MPXJTest.assertEquals((String)"Text20t", (String)mpx.getTaskFieldAlias(1009));
        MPXJTest.assertEquals((String)"Text21t", (String)mpx.getTaskFieldAlias(1010));
        MPXJTest.assertEquals((String)"Text22t", (String)mpx.getTaskFieldAlias(1011));
        MPXJTest.assertEquals((String)"Text23t", (String)mpx.getTaskFieldAlias(1012));
        MPXJTest.assertEquals((String)"Text24t", (String)mpx.getTaskFieldAlias(1013));
        MPXJTest.assertEquals((String)"Text25t", (String)mpx.getTaskFieldAlias(1014));
        MPXJTest.assertEquals((String)"Text26t", (String)mpx.getTaskFieldAlias(1015));
        MPXJTest.assertEquals((String)"Text27t", (String)mpx.getTaskFieldAlias(1016));
        MPXJTest.assertEquals((String)"Text28t", (String)mpx.getTaskFieldAlias(1017));
        MPXJTest.assertEquals((String)"Text29t", (String)mpx.getTaskFieldAlias(1018));
        MPXJTest.assertEquals((String)"Text30t", (String)mpx.getTaskFieldAlias(1019));
        MPXJTest.assertEquals((String)"Start1t", (String)mpx.getTaskFieldAlias(60));
        MPXJTest.assertEquals((String)"Start2t", (String)mpx.getTaskFieldAlias(62));
        MPXJTest.assertEquals((String)"Start3t", (String)mpx.getTaskFieldAlias(64));
        MPXJTest.assertEquals((String)"Start4t", (String)mpx.getTaskFieldAlias(126));
        MPXJTest.assertEquals((String)"Start5t", (String)mpx.getTaskFieldAlias(128));
        MPXJTest.assertEquals((String)"Start6t", (String)mpx.getTaskFieldAlias(1020));
        MPXJTest.assertEquals((String)"Start7t", (String)mpx.getTaskFieldAlias(1021));
        MPXJTest.assertEquals((String)"Start8t", (String)mpx.getTaskFieldAlias(1022));
        MPXJTest.assertEquals((String)"Start9t", (String)mpx.getTaskFieldAlias(1023));
        MPXJTest.assertEquals((String)"Start10t", (String)mpx.getTaskFieldAlias(1024));
        MPXJTest.assertEquals((String)"Finish1t", (String)mpx.getTaskFieldAlias(61));
        MPXJTest.assertEquals((String)"Finish2t", (String)mpx.getTaskFieldAlias(63));
        MPXJTest.assertEquals((String)"Finish3t", (String)mpx.getTaskFieldAlias(65));
        MPXJTest.assertEquals((String)"Finish4t", (String)mpx.getTaskFieldAlias(127));
        MPXJTest.assertEquals((String)"Finish5t", (String)mpx.getTaskFieldAlias(129));
        MPXJTest.assertEquals((String)"Finish6t", (String)mpx.getTaskFieldAlias(1025));
        MPXJTest.assertEquals((String)"Finish7t", (String)mpx.getTaskFieldAlias(1026));
        MPXJTest.assertEquals((String)"Finish8t", (String)mpx.getTaskFieldAlias(1027));
        MPXJTest.assertEquals((String)"Finish9t", (String)mpx.getTaskFieldAlias(1028));
        MPXJTest.assertEquals((String)"Finish10t", (String)mpx.getTaskFieldAlias(1029));
        MPXJTest.assertEquals((String)"Cost1t", (String)mpx.getTaskFieldAlias(36));
        MPXJTest.assertEquals((String)"Cost2t", (String)mpx.getTaskFieldAlias(37));
        MPXJTest.assertEquals((String)"Cost3t", (String)mpx.getTaskFieldAlias(38));
        MPXJTest.assertEquals((String)"Cost4t", (String)mpx.getTaskFieldAlias(1030));
        MPXJTest.assertEquals((String)"Cost5t", (String)mpx.getTaskFieldAlias(1031));
        MPXJTest.assertEquals((String)"Cost6t", (String)mpx.getTaskFieldAlias(1032));
        MPXJTest.assertEquals((String)"Cost7t", (String)mpx.getTaskFieldAlias(1033));
        MPXJTest.assertEquals((String)"Cost8t", (String)mpx.getTaskFieldAlias(1034));
        MPXJTest.assertEquals((String)"Cost9t", (String)mpx.getTaskFieldAlias(1035));
        MPXJTest.assertEquals((String)"Cost10t", (String)mpx.getTaskFieldAlias(1036));
        MPXJTest.assertEquals((String)"Date1t", (String)mpx.getTaskFieldAlias(1037));
        MPXJTest.assertEquals((String)"Date2t", (String)mpx.getTaskFieldAlias(1038));
        MPXJTest.assertEquals((String)"Date3t", (String)mpx.getTaskFieldAlias(1039));
        MPXJTest.assertEquals((String)"Date4t", (String)mpx.getTaskFieldAlias(1040));
        MPXJTest.assertEquals((String)"Date5t", (String)mpx.getTaskFieldAlias(1041));
        MPXJTest.assertEquals((String)"Date6t", (String)mpx.getTaskFieldAlias(1042));
        MPXJTest.assertEquals((String)"Date7t", (String)mpx.getTaskFieldAlias(1043));
        MPXJTest.assertEquals((String)"Date8t", (String)mpx.getTaskFieldAlias(1044));
        MPXJTest.assertEquals((String)"Date9t", (String)mpx.getTaskFieldAlias(1045));
        MPXJTest.assertEquals((String)"Date10t", (String)mpx.getTaskFieldAlias(1046));
        MPXJTest.assertEquals((String)"Flag1t", (String)mpx.getTaskFieldAlias(110));
        MPXJTest.assertEquals((String)"Flag2t", (String)mpx.getTaskFieldAlias(111));
        MPXJTest.assertEquals((String)"Flag3t", (String)mpx.getTaskFieldAlias(112));
        MPXJTest.assertEquals((String)"Flag4t", (String)mpx.getTaskFieldAlias(113));
        MPXJTest.assertEquals((String)"Flag5t", (String)mpx.getTaskFieldAlias(114));
        MPXJTest.assertEquals((String)"Flag6t", (String)mpx.getTaskFieldAlias(115));
        MPXJTest.assertEquals((String)"Flag7t", (String)mpx.getTaskFieldAlias(116));
        MPXJTest.assertEquals((String)"Flag8t", (String)mpx.getTaskFieldAlias(117));
        MPXJTest.assertEquals((String)"Flag9t", (String)mpx.getTaskFieldAlias(118));
        MPXJTest.assertEquals((String)"Flag10t", (String)mpx.getTaskFieldAlias(119));
        MPXJTest.assertEquals((String)"Flag11t", (String)mpx.getTaskFieldAlias(1047));
        MPXJTest.assertEquals((String)"Flag12t", (String)mpx.getTaskFieldAlias(1048));
        MPXJTest.assertEquals((String)"Flag13t", (String)mpx.getTaskFieldAlias(1049));
        MPXJTest.assertEquals((String)"Flag14t", (String)mpx.getTaskFieldAlias(1050));
        MPXJTest.assertEquals((String)"Flag15t", (String)mpx.getTaskFieldAlias(1051));
        MPXJTest.assertEquals((String)"Flag16t", (String)mpx.getTaskFieldAlias(1052));
        MPXJTest.assertEquals((String)"Flag17t", (String)mpx.getTaskFieldAlias(1053));
        MPXJTest.assertEquals((String)"Flag18t", (String)mpx.getTaskFieldAlias(1054));
        MPXJTest.assertEquals((String)"Flag19t", (String)mpx.getTaskFieldAlias(1055));
        MPXJTest.assertEquals((String)"Flag20t", (String)mpx.getTaskFieldAlias(1056));
        MPXJTest.assertEquals((String)"Number1t", (String)mpx.getTaskFieldAlias(140));
        MPXJTest.assertEquals((String)"Number2t", (String)mpx.getTaskFieldAlias(141));
        MPXJTest.assertEquals((String)"Number3t", (String)mpx.getTaskFieldAlias(142));
        MPXJTest.assertEquals((String)"Number4t", (String)mpx.getTaskFieldAlias(143));
        MPXJTest.assertEquals((String)"Number5t", (String)mpx.getTaskFieldAlias(144));
        MPXJTest.assertEquals((String)"Number6t", (String)mpx.getTaskFieldAlias(1057));
        MPXJTest.assertEquals((String)"Number7t", (String)mpx.getTaskFieldAlias(1058));
        MPXJTest.assertEquals((String)"Number8t", (String)mpx.getTaskFieldAlias(1059));
        MPXJTest.assertEquals((String)"Number9t", (String)mpx.getTaskFieldAlias(1060));
        MPXJTest.assertEquals((String)"Number10t", (String)mpx.getTaskFieldAlias(1061));
        MPXJTest.assertEquals((String)"Number11t", (String)mpx.getTaskFieldAlias(1062));
        MPXJTest.assertEquals((String)"Number12t", (String)mpx.getTaskFieldAlias(1063));
        MPXJTest.assertEquals((String)"Number13t", (String)mpx.getTaskFieldAlias(1064));
        MPXJTest.assertEquals((String)"Number14t", (String)mpx.getTaskFieldAlias(1065));
        MPXJTest.assertEquals((String)"Number15t", (String)mpx.getTaskFieldAlias(1066));
        MPXJTest.assertEquals((String)"Number16t", (String)mpx.getTaskFieldAlias(1067));
        MPXJTest.assertEquals((String)"Number17t", (String)mpx.getTaskFieldAlias(1068));
        MPXJTest.assertEquals((String)"Number18t", (String)mpx.getTaskFieldAlias(1069));
        MPXJTest.assertEquals((String)"Number19t", (String)mpx.getTaskFieldAlias(1070));
        MPXJTest.assertEquals((String)"Number20t", (String)mpx.getTaskFieldAlias(1071));
        MPXJTest.assertEquals((String)"Duration1t", (String)mpx.getTaskFieldAlias(46));
        MPXJTest.assertEquals((String)"Duration2t", (String)mpx.getTaskFieldAlias(47));
        MPXJTest.assertEquals((String)"Duration3t", (String)mpx.getTaskFieldAlias(48));
        MPXJTest.assertEquals((String)"Duration4t", (String)mpx.getTaskFieldAlias(1072));
        MPXJTest.assertEquals((String)"Duration5t", (String)mpx.getTaskFieldAlias(1073));
        MPXJTest.assertEquals((String)"Duration6t", (String)mpx.getTaskFieldAlias(1074));
        MPXJTest.assertEquals((String)"Duration7t", (String)mpx.getTaskFieldAlias(1075));
        MPXJTest.assertEquals((String)"Duration8t", (String)mpx.getTaskFieldAlias(1076));
        MPXJTest.assertEquals((String)"Duration9t", (String)mpx.getTaskFieldAlias(1077));
        MPXJTest.assertEquals((String)"Duration10t", (String)mpx.getTaskFieldAlias(1078));
        MPXJTest.assertEquals((String)"Outline Code1t", (String)mpx.getTaskFieldAlias(1079));
        MPXJTest.assertEquals((String)"Outline Code2t", (String)mpx.getTaskFieldAlias(1080));
        MPXJTest.assertEquals((String)"Outline Code3t", (String)mpx.getTaskFieldAlias(1081));
        MPXJTest.assertEquals((String)"Outline Code4t", (String)mpx.getTaskFieldAlias(1082));
        MPXJTest.assertEquals((String)"Outline Code5t", (String)mpx.getTaskFieldAlias(1083));
        MPXJTest.assertEquals((String)"Outline Code6t", (String)mpx.getTaskFieldAlias(1084));
        MPXJTest.assertEquals((String)"Outline Code7t", (String)mpx.getTaskFieldAlias(1085));
        MPXJTest.assertEquals((String)"Outline Code8t", (String)mpx.getTaskFieldAlias(1086));
        MPXJTest.assertEquals((String)"Outline Code9t", (String)mpx.getTaskFieldAlias(1087));
        MPXJTest.assertEquals((String)"Outline Code10t", (String)mpx.getTaskFieldAlias(1088));
        MPXJTest.assertEquals((String)"Text1r", (String)mpx.getResourceFieldAlias(5));
        MPXJTest.assertEquals((String)"Text2r", (String)mpx.getResourceFieldAlias(6));
        MPXJTest.assertEquals((String)"Text3r", (String)mpx.getResourceFieldAlias(7));
        MPXJTest.assertEquals((String)"Text4r", (String)mpx.getResourceFieldAlias(8));
        MPXJTest.assertEquals((String)"Text5r", (String)mpx.getResourceFieldAlias(9));
        MPXJTest.assertEquals((String)"Text6r", (String)mpx.getResourceFieldAlias(1000));
        MPXJTest.assertEquals((String)"Text7r", (String)mpx.getResourceFieldAlias(1001));
        MPXJTest.assertEquals((String)"Text8r", (String)mpx.getResourceFieldAlias(1002));
        MPXJTest.assertEquals((String)"Text9r", (String)mpx.getResourceFieldAlias(1003));
        MPXJTest.assertEquals((String)"Text10r", (String)mpx.getResourceFieldAlias(1004));
        MPXJTest.assertEquals((String)"Text11r", (String)mpx.getResourceFieldAlias(1005));
        MPXJTest.assertEquals((String)"Text12r", (String)mpx.getResourceFieldAlias(1006));
        MPXJTest.assertEquals((String)"Text13r", (String)mpx.getResourceFieldAlias(1007));
        MPXJTest.assertEquals((String)"Text14r", (String)mpx.getResourceFieldAlias(1008));
        MPXJTest.assertEquals((String)"Text15r", (String)mpx.getResourceFieldAlias(1009));
        MPXJTest.assertEquals((String)"Text16r", (String)mpx.getResourceFieldAlias(1010));
        MPXJTest.assertEquals((String)"Text17r", (String)mpx.getResourceFieldAlias(1011));
        MPXJTest.assertEquals((String)"Text18r", (String)mpx.getResourceFieldAlias(1012));
        MPXJTest.assertEquals((String)"Text19r", (String)mpx.getResourceFieldAlias(1013));
        MPXJTest.assertEquals((String)"Text20r", (String)mpx.getResourceFieldAlias(1014));
        MPXJTest.assertEquals((String)"Text21r", (String)mpx.getResourceFieldAlias(1015));
        MPXJTest.assertEquals((String)"Text22r", (String)mpx.getResourceFieldAlias(1016));
        MPXJTest.assertEquals((String)"Text23r", (String)mpx.getResourceFieldAlias(1017));
        MPXJTest.assertEquals((String)"Text24r", (String)mpx.getResourceFieldAlias(1018));
        MPXJTest.assertEquals((String)"Text25r", (String)mpx.getResourceFieldAlias(1019));
        MPXJTest.assertEquals((String)"Text26r", (String)mpx.getResourceFieldAlias(1020));
        MPXJTest.assertEquals((String)"Text27r", (String)mpx.getResourceFieldAlias(1021));
        MPXJTest.assertEquals((String)"Text28r", (String)mpx.getResourceFieldAlias(1022));
        MPXJTest.assertEquals((String)"Text29r", (String)mpx.getResourceFieldAlias(1023));
        MPXJTest.assertEquals((String)"Text30r", (String)mpx.getResourceFieldAlias(1024));
        MPXJTest.assertEquals((String)"Start1r", (String)mpx.getResourceFieldAlias(1025));
        MPXJTest.assertEquals((String)"Start2r", (String)mpx.getResourceFieldAlias(1026));
        MPXJTest.assertEquals((String)"Start3r", (String)mpx.getResourceFieldAlias(1027));
        MPXJTest.assertEquals((String)"Start4r", (String)mpx.getResourceFieldAlias(1028));
        MPXJTest.assertEquals((String)"Start5r", (String)mpx.getResourceFieldAlias(1029));
        MPXJTest.assertEquals((String)"Start6r", (String)mpx.getResourceFieldAlias(1030));
        MPXJTest.assertEquals((String)"Start7r", (String)mpx.getResourceFieldAlias(1031));
        MPXJTest.assertEquals((String)"Start8r", (String)mpx.getResourceFieldAlias(1032));
        MPXJTest.assertEquals((String)"Start9r", (String)mpx.getResourceFieldAlias(1033));
        MPXJTest.assertEquals((String)"Start10r", (String)mpx.getResourceFieldAlias(1034));
        MPXJTest.assertEquals((String)"Finish1r", (String)mpx.getResourceFieldAlias(1035));
        MPXJTest.assertEquals((String)"Finish2r", (String)mpx.getResourceFieldAlias(1036));
        MPXJTest.assertEquals((String)"Finish3r", (String)mpx.getResourceFieldAlias(1037));
        MPXJTest.assertEquals((String)"Finish4r", (String)mpx.getResourceFieldAlias(1038));
        MPXJTest.assertEquals((String)"Finish5r", (String)mpx.getResourceFieldAlias(1039));
        MPXJTest.assertEquals((String)"Finish6r", (String)mpx.getResourceFieldAlias(1040));
        MPXJTest.assertEquals((String)"Finish7r", (String)mpx.getResourceFieldAlias(1041));
        MPXJTest.assertEquals((String)"Finish8r", (String)mpx.getResourceFieldAlias(1042));
        MPXJTest.assertEquals((String)"Finish9r", (String)mpx.getResourceFieldAlias(1043));
        MPXJTest.assertEquals((String)"Finish10r", (String)mpx.getResourceFieldAlias(1044));
        MPXJTest.assertEquals((String)"Cost1r", (String)mpx.getResourceFieldAlias(1045));
        MPXJTest.assertEquals((String)"Cost2r", (String)mpx.getResourceFieldAlias(1046));
        MPXJTest.assertEquals((String)"Cost3r", (String)mpx.getResourceFieldAlias(1047));
        MPXJTest.assertEquals((String)"Cost4r", (String)mpx.getResourceFieldAlias(1048));
        MPXJTest.assertEquals((String)"Cost5r", (String)mpx.getResourceFieldAlias(1049));
        MPXJTest.assertEquals((String)"Cost6r", (String)mpx.getResourceFieldAlias(1050));
        MPXJTest.assertEquals((String)"Cost7r", (String)mpx.getResourceFieldAlias(1051));
        MPXJTest.assertEquals((String)"Cost8r", (String)mpx.getResourceFieldAlias(1052));
        MPXJTest.assertEquals((String)"Cost9r", (String)mpx.getResourceFieldAlias(1053));
        MPXJTest.assertEquals((String)"Cost10r", (String)mpx.getResourceFieldAlias(1054));
        MPXJTest.assertEquals((String)"Date1r", (String)mpx.getResourceFieldAlias(1055));
        MPXJTest.assertEquals((String)"Date2r", (String)mpx.getResourceFieldAlias(1056));
        MPXJTest.assertEquals((String)"Date3r", (String)mpx.getResourceFieldAlias(1057));
        MPXJTest.assertEquals((String)"Date4r", (String)mpx.getResourceFieldAlias(1058));
        MPXJTest.assertEquals((String)"Date5r", (String)mpx.getResourceFieldAlias(1059));
        MPXJTest.assertEquals((String)"Date6r", (String)mpx.getResourceFieldAlias(1060));
        MPXJTest.assertEquals((String)"Date7r", (String)mpx.getResourceFieldAlias(1061));
        MPXJTest.assertEquals((String)"Date8r", (String)mpx.getResourceFieldAlias(1062));
        MPXJTest.assertEquals((String)"Date9r", (String)mpx.getResourceFieldAlias(1063));
        MPXJTest.assertEquals((String)"Date10r", (String)mpx.getResourceFieldAlias(1064));
        MPXJTest.assertEquals((String)"Flag1r", (String)mpx.getResourceFieldAlias(1065));
        MPXJTest.assertEquals((String)"Flag2r", (String)mpx.getResourceFieldAlias(1066));
        MPXJTest.assertEquals((String)"Flag3r", (String)mpx.getResourceFieldAlias(1067));
        MPXJTest.assertEquals((String)"Flag4r", (String)mpx.getResourceFieldAlias(1068));
        MPXJTest.assertEquals((String)"Flag5r", (String)mpx.getResourceFieldAlias(1069));
        MPXJTest.assertEquals((String)"Flag6r", (String)mpx.getResourceFieldAlias(1070));
        MPXJTest.assertEquals((String)"Flag7r", (String)mpx.getResourceFieldAlias(1071));
        MPXJTest.assertEquals((String)"Flag8r", (String)mpx.getResourceFieldAlias(1072));
        MPXJTest.assertEquals((String)"Flag9r", (String)mpx.getResourceFieldAlias(1073));
        MPXJTest.assertEquals((String)"Flag10r", (String)mpx.getResourceFieldAlias(1074));
        MPXJTest.assertEquals((String)"Flag11r", (String)mpx.getResourceFieldAlias(1075));
        MPXJTest.assertEquals((String)"Flag12r", (String)mpx.getResourceFieldAlias(1076));
        MPXJTest.assertEquals((String)"Flag13r", (String)mpx.getResourceFieldAlias(1077));
        MPXJTest.assertEquals((String)"Flag14r", (String)mpx.getResourceFieldAlias(1078));
        MPXJTest.assertEquals((String)"Flag15r", (String)mpx.getResourceFieldAlias(1079));
        MPXJTest.assertEquals((String)"Flag16r", (String)mpx.getResourceFieldAlias(1080));
        MPXJTest.assertEquals((String)"Flag17r", (String)mpx.getResourceFieldAlias(1081));
        MPXJTest.assertEquals((String)"Flag18r", (String)mpx.getResourceFieldAlias(1082));
        MPXJTest.assertEquals((String)"Flag19r", (String)mpx.getResourceFieldAlias(1083));
        MPXJTest.assertEquals((String)"Flag20r", (String)mpx.getResourceFieldAlias(1084));
        MPXJTest.assertEquals((String)"Number1r", (String)mpx.getResourceFieldAlias(1085));
        MPXJTest.assertEquals((String)"Number2r", (String)mpx.getResourceFieldAlias(1086));
        MPXJTest.assertEquals((String)"Number3r", (String)mpx.getResourceFieldAlias(1087));
        MPXJTest.assertEquals((String)"Number4r", (String)mpx.getResourceFieldAlias(1088));
        MPXJTest.assertEquals((String)"Number5r", (String)mpx.getResourceFieldAlias(1089));
        MPXJTest.assertEquals((String)"Number6r", (String)mpx.getResourceFieldAlias(1090));
        MPXJTest.assertEquals((String)"Number7r", (String)mpx.getResourceFieldAlias(1091));
        MPXJTest.assertEquals((String)"Number8r", (String)mpx.getResourceFieldAlias(1092));
        MPXJTest.assertEquals((String)"Number9r", (String)mpx.getResourceFieldAlias(1093));
        MPXJTest.assertEquals((String)"Number10r", (String)mpx.getResourceFieldAlias(1094));
        MPXJTest.assertEquals((String)"Number11r", (String)mpx.getResourceFieldAlias(1095));
        MPXJTest.assertEquals((String)"Number12r", (String)mpx.getResourceFieldAlias(1096));
        MPXJTest.assertEquals((String)"Number13r", (String)mpx.getResourceFieldAlias(1097));
        MPXJTest.assertEquals((String)"Number14r", (String)mpx.getResourceFieldAlias(1098));
        MPXJTest.assertEquals((String)"Number15r", (String)mpx.getResourceFieldAlias(1099));
        MPXJTest.assertEquals((String)"Number16r", (String)mpx.getResourceFieldAlias(1100));
        MPXJTest.assertEquals((String)"Number17r", (String)mpx.getResourceFieldAlias(1101));
        MPXJTest.assertEquals((String)"Number18r", (String)mpx.getResourceFieldAlias(1102));
        MPXJTest.assertEquals((String)"Number19r", (String)mpx.getResourceFieldAlias(1103));
        MPXJTest.assertEquals((String)"Number20r", (String)mpx.getResourceFieldAlias(1104));
        MPXJTest.assertEquals((String)"Duration1r", (String)mpx.getResourceFieldAlias(1105));
        MPXJTest.assertEquals((String)"Duration2r", (String)mpx.getResourceFieldAlias(1106));
        MPXJTest.assertEquals((String)"Duration3r", (String)mpx.getResourceFieldAlias(1107));
        MPXJTest.assertEquals((String)"Duration4r", (String)mpx.getResourceFieldAlias(1108));
        MPXJTest.assertEquals((String)"Duration5r", (String)mpx.getResourceFieldAlias(1109));
        MPXJTest.assertEquals((String)"Duration6r", (String)mpx.getResourceFieldAlias(1110));
        MPXJTest.assertEquals((String)"Duration7r", (String)mpx.getResourceFieldAlias(1111));
        MPXJTest.assertEquals((String)"Duration8r", (String)mpx.getResourceFieldAlias(1112));
        MPXJTest.assertEquals((String)"Duration9r", (String)mpx.getResourceFieldAlias(1113));
        MPXJTest.assertEquals((String)"Duration10r", (String)mpx.getResourceFieldAlias(1114));
        MPXJTest.assertEquals((String)"Outline Code1r", (String)mpx.getResourceFieldAlias(1115));
        MPXJTest.assertEquals((String)"Outline Code2r", (String)mpx.getResourceFieldAlias(1116));
        MPXJTest.assertEquals((String)"Outline Code3r", (String)mpx.getResourceFieldAlias(1117));
        MPXJTest.assertEquals((String)"Outline Code4r", (String)mpx.getResourceFieldAlias(1118));
        MPXJTest.assertEquals((String)"Outline Code5r", (String)mpx.getResourceFieldAlias(1119));
        MPXJTest.assertEquals((String)"Outline Code6r", (String)mpx.getResourceFieldAlias(1120));
        MPXJTest.assertEquals((String)"Outline Code7r", (String)mpx.getResourceFieldAlias(1121));
        MPXJTest.assertEquals((String)"Outline Code8r", (String)mpx.getResourceFieldAlias(1122));
        MPXJTest.assertEquals((String)"Outline Code9r", (String)mpx.getResourceFieldAlias(1123));
        MPXJTest.assertEquals((String)"Outline Code10r", (String)mpx.getResourceFieldAlias(1124));
    }

    public void testCustomerData() throws Exception {
        File dir = new File("c:\\tapsterrock\\mpxj\\data");
        if (dir.exists() && dir.isDirectory()) {
            int failures = 0;
            File[] files = dir.listFiles();
            for (int loop = 0; loop < files.length; ++loop) {
                File file = files[loop];
                String name = file.getName().toUpperCase();
                try {
                    MPXFile mpxj;
                    if (name.endsWith(".MPP")) {
                        mpxj = new MPPFile(file);
                        continue;
                    }
                    if (name.endsWith(".MPX")) {
                        mpxj = new MPXFile();
                        if (name.indexOf(".DE.") != -1) {
                            mpxj.setLocale(Locale.GERMAN);
                        }
                        if (name.indexOf(".SV.") != -1) {
                            mpxj.setLocale(new Locale("sv"));
                        }
                        mpxj.read(file);
                        continue;
                    }
                    if (!name.endsWith(".XML")) continue;
                    mpxj = new MSPDIFile(file);
                    continue;
                }
                catch (Exception ex) {
                    System.out.println("Failed to read " + name);
                    ex.printStackTrace();
                    ++failures;
                }
            }
            MPXJTest.assertEquals((String)("Failed to read " + failures + " files"), (int)0, (int)failures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmbeddedLineBreaks() throws Exception {
        block3: {
            File out = null;
            boolean success = false;
            try {
                SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
                MPXFile file = new MPXFile();
                file.setAutoTaskID(true);
                file.setAutoTaskUniqueID(true);
                file.setAutoResourceID(true);
                file.setAutoResourceUniqueID(true);
                file.setAutoOutlineLevel(true);
                file.setAutoOutlineNumber(true);
                file.setAutoWBS(true);
                file.setAutoCalendarUniqueID(true);
                file.addDefaultBaseCalendar();
                ProjectHeader header = file.getProjectHeader();
                header.setComments("Project Header Comments: Some\rExample\nText\r\nWith\n\rBreaks");
                header.setStartDate(df.parse("01/01/2003"));
                Resource resource1 = file.addResource();
                resource1.setName("Resource1: Some\rExample\nText\r\nWith\n\rBreaks");
                resource1.setNotes("Resource1 Notes: Some\rExample\nText\r\nWith\n\rBreaks");
                Task task1 = file.addTask();
                task1.setName("Task1: Some\rExample\nText\r\nWith\n\rBreaks");
                task1.setNotes("Task1 Notes: Some\rExample\nText\r\nWith\n\rBreaks");
                out = File.createTempFile("junit", ".mpx");
                file.write(out);
                file = new MPXFile(out);
                MPXJTest.assertEquals((int)1, (int)file.getAllTasks().size());
                MPXJTest.assertEquals((int)1, (int)file.getAllResources().size());
                header = file.getProjectHeader();
                MPXJTest.assertEquals((String)"Project Header Comments: Some\nExample\nText\nWith\nBreaks", (String)header.getComments());
                task1 = file.getTaskByUniqueID(1);
                MPXJTest.assertEquals((String)"Task1: Some\nExample\nText\nWith\nBreaks", (String)task1.getName());
                MPXJTest.assertEquals((String)"Task1 Notes: Some\nExample\nText\nWith\nBreaks", (String)task1.getNotes());
                resource1 = file.getResourceByUniqueID(1);
                MPXJTest.assertEquals((String)"Resource1: Some\nExample\nText\nWith\nBreaks", (String)resource1.getName());
                MPXJTest.assertEquals((String)"Resource1 Notes: Some\nExample\nText\nWith\nBreaks", (String)resource1.getNotes());
                success = true;
                Object var9_8 = null;
                if (!success || out == null) break block3;
                out.delete();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (success && out != null) {
                    out.delete();
                }
                throw throwable;
            }
            {
            }
        }
    }

    public void testPasswordProtection() throws Exception {
        MPPFile mpp;
        File in;
        try {
            in = new File(this.m_basedir + "/readpassword9.mpp");
            mpp = new MPPFile(in);
            MPXJTest.assertTrue((boolean)false);
        }
        catch (MPXException ex) {
            MPXJTest.assertEquals((String)"File is password protected", (String)ex.getMessage());
        }
        in = new File(this.m_basedir + "/writepassword9.mpp");
        mpp = new MPPFile(in);
        try {
            in = new File(this.m_basedir + "/bothpassword9.mpp");
            mpp = new MPPFile(in);
            MPXJTest.assertTrue((boolean)false);
        }
        catch (MPXException ex) {
            MPXJTest.assertEquals((String)"File is password protected", (String)ex.getMessage());
        }
    }

    public void testMspdiExtendedAttributes() throws Exception {
        MSPDIFile xml = new MSPDIFile(this.m_basedir + "/mspextattr.xml");
        this.commonMspdiExtendedAttributeTests(xml);
        File out = File.createTempFile("junit", ".xml");
        xml.write(out);
        xml = new MSPDIFile(out);
        this.commonMspdiExtendedAttributeTests(xml);
        out.delete();
    }

    private void commonMspdiExtendedAttributeTests(MSPDIFile xml) {
        LinkedList tasks = xml.getAllTasks();
        MPXJTest.assertEquals((int)2, (int)tasks.size());
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        Task task = (Task)tasks.get(1);
        MPXJTest.assertEquals((String)"Task Text One", (String)task.getText1());
        MPXJTest.assertEquals((String)"01/01/2004", (String)df.format(task.getStart1()));
        MPXJTest.assertEquals((String)"31/12/2004", (String)df.format(task.getFinish1()));
        MPXJTest.assertEquals((double)99.95, (double)task.getCost1().doubleValue(), (double)0.0);
        MPXJTest.assertEquals((String)"18/07/2004", (String)df.format(task.getDate1()));
        MPXJTest.assertTrue((boolean)task.getFlag1Value());
        MPXJTest.assertEquals((double)55.56, (double)task.getNumber1Value(), (double)0.0);
        MPXJTest.assertEquals((double)13.0, (double)task.getDuration1().getDuration(), (double)0.0);
        MPXJTest.assertEquals((Object)TimeUnit.DAYS, (Object)task.getDuration1().getUnits());
        LinkedList resources = xml.getAllResources();
        MPXJTest.assertEquals((int)2, (int)resources.size());
        Resource resource = (Resource)resources.get(1);
        MPXJTest.assertEquals((String)"Resource Text One", (String)resource.getText1());
        MPXJTest.assertEquals((String)"01/01/2003", (String)df.format(resource.getStart1()));
        MPXJTest.assertEquals((String)"31/12/2003", (String)df.format(resource.getFinish1()));
        MPXJTest.assertEquals((double)29.99, (double)resource.getCost1().doubleValue(), (double)0.0);
        MPXJTest.assertEquals((String)"18/07/2003", (String)df.format(resource.getDate1()));
        MPXJTest.assertTrue((boolean)resource.getFlag1());
        MPXJTest.assertEquals((double)5.99, (double)resource.getNumber1Value(), (double)0.0);
        MPXJTest.assertEquals((double)22.0, (double)resource.getDuration1().getDuration(), (double)0.0);
        MPXJTest.assertEquals((Object)TimeUnit.DAYS, (Object)resource.getDuration1().getUnits());
    }

    public void testProjectHeader() throws Exception {
        block2: {
            File out = null;
            try {
                MPXFile mpx = new MPXFile(this.m_basedir + "/headertest.mpx");
                this.testHeaderFields(mpx);
                out = File.createTempFile("junit", ".mpx");
                mpx.write(out);
                mpx = new MPXFile(out);
                this.testHeaderFields(mpx);
                out.delete();
                out = null;
                mpx = new MPPFile(this.m_basedir + "/headertest8.mpp");
                this.testHeaderFields(mpx);
                mpx = new MPPFile(this.m_basedir + "/headertest9.mpp");
                this.testHeaderFields(mpx);
                mpx = new MSPDIFile(this.m_basedir + "/headertest.xml");
                this.testHeaderFields(mpx);
                out = File.createTempFile("junit", ".xml");
                mpx.write(out);
                mpx = new MSPDIFile(out);
                this.testHeaderFields(mpx);
                out.delete();
                out = null;
            }
            catch (Exception ex) {
                if (out == null) break block2;
                out.delete();
            }
        }
    }

    private void testHeaderFields(MPXFile file) {
        ProjectHeader header = file.getProjectHeader();
        MPXJTest.assertEquals((String)"Project Title Text", (String)header.getProjectTitle());
        MPXJTest.assertEquals((String)"Author Text", (String)header.getAuthor());
        MPXJTest.assertEquals((String)"Comments Text", (String)header.getComments());
        MPXJTest.assertEquals((String)"Company Text", (String)header.getCompany());
        MPXJTest.assertEquals((String)"Keywords Text", (String)header.getKeywords());
        MPXJTest.assertEquals((String)"Manager Text", (String)header.getManager());
        MPXJTest.assertEquals((String)"Subject Text", (String)header.getSubject());
    }

    public void testWBS() throws Exception {
        MPPFile mpp = new MPPFile(this.m_basedir + "/sample98.mpp");
        Task task = mpp.getTaskByUniqueID(2);
        MPXJTest.assertEquals((String)"Second Task", (String)task.getName());
        MPXJTest.assertEquals((String)"1.1", (String)task.getWBS());
        mpp = new MPPFile(this.m_basedir + "/sample.mpp");
        task = mpp.getTaskByUniqueID(2);
        MPXJTest.assertEquals((String)"Second Task", (String)task.getName());
        MPXJTest.assertEquals((String)"1.1", (String)task.getWBS());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPriority() throws Exception {
        block7: {
            boolean success;
            File out;
            MPXFile mpx;
            block6: {
                mpx = new MPXFile(this.m_basedir + "/mpxpriority.mpx");
                this.validatePriority(mpx);
                MPPFile mpp8 = new MPPFile(this.m_basedir + "/mpp8priority.mpp");
                this.validatePriority(mpp8);
                MPPFile mpp9 = new MPPFile(this.m_basedir + "/mpp9priority.mpp");
                this.validatePriority(mpp9);
                MSPDIFile xml = new MSPDIFile(this.m_basedir + "/mspdipriority.xml");
                this.validatePriority(xml);
                out = null;
                success = false;
                try {
                    out = File.createTempFile("junit", ".mpx");
                    mpx.write(out);
                    MPXFile mpx2 = new MPXFile(out);
                    this.validatePriority(mpx2);
                    success = true;
                    Object var9_8 = null;
                    if (out == null || !success) break block6;
                    out.delete();
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (out != null && success) {
                        out.delete();
                    }
                    throw throwable;
                }
                {
                }
            }
            out = null;
            success = false;
            try {
                out = File.createTempFile("junit", ".xml");
                MSPDIFile xml2 = new MSPDIFile(mpx);
                xml2.write(out);
                MSPDIFile xml3 = new MSPDIFile(out);
                this.validatePriority(xml3);
                success = true;
                Object var11_12 = null;
                if (out == null || !success) break block7;
                out.delete();
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (out != null && success) {
                    out.delete();
                }
                throw throwable;
            }
            {
            }
        }
    }

    private void validatePriority(MPXFile file) {
        MPXJTest.assertEquals((int)1000, (int)file.getTaskByUniqueID(1).getPriority().getValue());
        MPXJTest.assertEquals((int)900, (int)file.getTaskByUniqueID(2).getPriority().getValue());
        MPXJTest.assertEquals((int)800, (int)file.getTaskByUniqueID(3).getPriority().getValue());
        MPXJTest.assertEquals((int)700, (int)file.getTaskByUniqueID(4).getPriority().getValue());
        MPXJTest.assertEquals((int)600, (int)file.getTaskByUniqueID(5).getPriority().getValue());
        MPXJTest.assertEquals((int)500, (int)file.getTaskByUniqueID(6).getPriority().getValue());
        MPXJTest.assertEquals((int)400, (int)file.getTaskByUniqueID(7).getPriority().getValue());
        MPXJTest.assertEquals((int)300, (int)file.getTaskByUniqueID(8).getPriority().getValue());
        MPXJTest.assertEquals((int)200, (int)file.getTaskByUniqueID(9).getPriority().getValue());
        MPXJTest.assertEquals((int)100, (int)file.getTaskByUniqueID(10).getPriority().getValue());
    }
}

