/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.Comments;
import com.tapsterrock.mpx.Day;
import com.tapsterrock.mpx.DdeOleClientLinks;
import com.tapsterrock.mpx.FileCreationRecord;
import com.tapsterrock.mpx.InputStreamTokenizer;
import com.tapsterrock.mpx.LocaleData;
import com.tapsterrock.mpx.MPXCalendar;
import com.tapsterrock.mpx.MPXCurrency;
import com.tapsterrock.mpx.MPXDateFormat;
import com.tapsterrock.mpx.MPXDuration;
import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXNumberFormat;
import com.tapsterrock.mpx.MPXRecord;
import com.tapsterrock.mpx.MPXTimeFormat;
import com.tapsterrock.mpx.ProjectHeader;
import com.tapsterrock.mpx.ProjectNames;
import com.tapsterrock.mpx.ReaderTokenizer;
import com.tapsterrock.mpx.Record;
import com.tapsterrock.mpx.Resource;
import com.tapsterrock.mpx.ResourceAssignment;
import com.tapsterrock.mpx.ResourceModel;
import com.tapsterrock.mpx.Task;
import com.tapsterrock.mpx.TaskModel;
import com.tapsterrock.mpx.Tokenizer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;

public class MPXFile {
    private Locale m_locale = Locale.ENGLISH;
    static final String EOL = "\r\n";
    private int m_taskUniqueID;
    private int m_calendarUniqueID;
    private int m_taskID;
    private int m_resourceUniqueID;
    private int m_resourceID;
    private LinkedList m_records = new LinkedList();
    private LinkedList m_allResources = new LinkedList();
    private LinkedList m_allTasks = new LinkedList();
    private LinkedList m_childTasks = new LinkedList();
    private LinkedList m_allResourceAssignments = new LinkedList();
    private LinkedList m_baseCalendars = new LinkedList();
    private MPXDateFormat m_dateTimeFormat = new MPXDateFormat();
    private MPXDateFormat m_dateFormat = new MPXDateFormat();
    private MPXTimeFormat m_timeFormat = new MPXTimeFormat();
    private MPXNumberFormat m_currencyFormat = new MPXNumberFormat();
    private FileCreationRecord m_fileCreationRecord = new FileCreationRecord(this);
    private ProjectHeader m_projectHeader = new ProjectHeader(this);
    private TaskModel m_taskModel = new TaskModel(this);
    private ResourceModel m_resourceModel = new ResourceModel(this);
    private Task m_lastTask;
    private Resource m_lastResource;
    private MPXCalendar m_lastResourceCalendar;
    private ResourceAssignment m_lastResourceAssignment;
    private MPXCalendar m_lastBaseCalendar;
    private boolean m_resourceTableDefinition;
    private boolean m_taskTableDefinition;
    private int m_projectNames;
    private int m_ddeOleClientLinks;
    private char m_delimiter = LocaleData.getChar(this.m_locale, "FILE_DELIMITER");
    private boolean m_autoWBS;
    private boolean m_autoOutlineLevel;
    private boolean m_autoOutlineNumber;
    private boolean m_autoTaskUniqueID;
    private boolean m_autoCalendarUniqueID;
    private boolean m_autoTaskID;
    private boolean m_autoResourceUniqueID;
    private boolean m_autoResourceID;
    private boolean m_ignoreTextModels = true;
    private int m_baseOutlineLevel = -1;
    private char m_thousandsSeparator = LocaleData.getChar(this.m_locale, "CURRENCY_THOUSANDS_SEPARATOR");
    private char m_decimalSeparator = LocaleData.getChar(this.m_locale, "CURRENCY_DECIMAL_SEPARATOR");
    private MPXNumberFormat m_decimalFormat;
    private MPXNumberFormat m_durationDecimalFormat;
    private MPXNumberFormat m_percentageDecimalFormat;
    private MPXNumberFormat m_unitsDecimalFormat;
    private HashMap m_taskFieldAlias = new HashMap();
    private HashMap m_aliasTaskField = new HashMap();
    private HashMap m_resourceFieldAlias = new HashMap();
    private HashMap m_aliasResourceField = new HashMap();
    private HashMap m_taskUniqueIDMap = new HashMap();
    private HashMap m_taskIDMap = new HashMap();
    private HashMap m_resourceUniqueIDMap = new HashMap();
    private HashMap m_resourceIDMap = new HashMap();
    private MPXCurrency m_zeroCurrency;

    public MPXFile() {
        this.configure();
    }

    public MPXFile(MPXFile file) {
        this.m_allResourceAssignments = file.m_allResourceAssignments;
        this.m_allResources = file.m_allResources;
        this.m_allTasks = file.m_allTasks;
        this.m_autoOutlineLevel = file.m_autoOutlineLevel;
        this.m_autoOutlineNumber = file.m_autoOutlineNumber;
        this.m_autoResourceID = file.m_autoResourceID;
        this.m_autoResourceUniqueID = file.m_autoResourceUniqueID;
        this.m_autoTaskID = file.m_autoTaskID;
        this.m_autoTaskUniqueID = file.m_autoTaskUniqueID;
        this.m_autoCalendarUniqueID = file.m_autoCalendarUniqueID;
        this.m_autoWBS = file.m_autoWBS;
        this.m_baseCalendars = file.m_baseCalendars;
        this.m_baseOutlineLevel = file.m_baseOutlineLevel;
        this.m_childTasks = file.m_childTasks;
        this.m_currencyFormat = file.m_currencyFormat;
        this.m_dateTimeFormat = file.m_dateTimeFormat;
        this.m_dateFormat = file.m_dateFormat;
        this.m_ddeOleClientLinks = file.m_ddeOleClientLinks;
        this.m_delimiter = file.m_delimiter;
        this.m_fileCreationRecord = file.m_fileCreationRecord;
        this.m_lastBaseCalendar = file.m_lastBaseCalendar;
        this.m_lastResource = file.m_lastResource;
        this.m_lastResourceAssignment = file.m_lastResourceAssignment;
        this.m_lastResourceCalendar = file.m_lastResourceCalendar;
        this.m_lastTask = file.m_lastTask;
        this.m_projectHeader = file.m_projectHeader;
        this.m_projectNames = file.m_projectNames;
        this.m_records = file.m_records;
        this.m_resourceID = file.m_resourceID;
        this.m_resourceModel = file.m_resourceModel;
        this.m_resourceTableDefinition = file.m_resourceTableDefinition;
        this.m_resourceUniqueID = file.m_resourceUniqueID;
        this.m_taskID = file.m_taskID;
        this.m_taskModel = file.m_taskModel;
        this.m_taskTableDefinition = file.m_taskTableDefinition;
        this.m_taskUniqueID = file.m_taskUniqueID;
        this.m_calendarUniqueID = file.m_calendarUniqueID;
        this.m_timeFormat = file.m_timeFormat;
        this.m_locale = file.m_locale;
        this.m_taskFieldAlias = file.m_taskFieldAlias;
        this.m_aliasTaskField = file.m_aliasTaskField;
        this.m_resourceFieldAlias = file.m_resourceFieldAlias;
        this.m_aliasResourceField = file.m_aliasResourceField;
        this.m_taskUniqueIDMap = file.m_taskUniqueIDMap;
        this.m_taskIDMap = file.m_taskIDMap;
        this.m_resourceUniqueIDMap = file.m_resourceUniqueIDMap;
        this.m_resourceIDMap = file.m_resourceIDMap;
        this.m_zeroCurrency = file.m_zeroCurrency;
    }

    public MPXFile(InputStream stream) throws MPXException {
        this.configure();
        this.read(stream);
    }

    public MPXFile(String path) throws MPXException {
        this.configure();
        this.read(new File(path));
    }

    public MPXFile(File file) throws MPXException {
        this.configure();
        this.read(file);
    }

    protected void configure() {
        this.setLocale(Locale.ENGLISH);
        this.m_records.add(this.m_fileCreationRecord);
        this.m_records.add(this.m_projectHeader);
    }

    public char getDelimiter() {
        return this.m_delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.m_delimiter = delimiter;
    }

    public void read(InputStream is) throws MPXException {
        int line = 1;
        try {
            BufferedInputStream bis = new BufferedInputStream(is);
            byte[] data = new byte[4];
            data[0] = (byte)bis.read();
            bis.mark(1024);
            data[1] = (byte)bis.read();
            data[2] = (byte)bis.read();
            data[3] = (byte)bis.read();
            if (data[0] != 77 || data[1] != 80 || data[2] != 88) {
                throw new MPXException("Invalid file format");
            }
            this.setDelimiter((char)data[3]);
            bis.reset();
            Tokenizer tk = new InputStreamTokenizer(bis);
            tk.setDelimiter(this.m_delimiter);
            this.add(Integer.toString(999), new Record(this, tk));
            ++line;
            InputStreamReader reader = new InputStreamReader((InputStream)bis, this.getFileCreationRecord().getCodePage().getCharset());
            tk = new ReaderTokenizer(reader);
            tk.setDelimiter(this.m_delimiter);
            while (tk.getType() != -1) {
                Record record = new Record(this, tk);
                String number = record.getRecordNumber();
                if (number != null) {
                    this.add(number, record);
                }
                ++line;
            }
            this.updateUniqueIdentifiers();
            this.updateStructure();
        }
        catch (Exception ex) {
            throw new MPXException("Error reading file (failed at line " + line + ")", ex);
        }
    }

    private void updateUniqueIdentifiers() {
        Iterator iter = this.m_allTasks.iterator();
        while (iter.hasNext()) {
            Task task = (Task)iter.next();
            if (task.getUniqueID() != null) continue;
            task.setUniqueID(task.getID());
        }
        iter = this.m_allResources.iterator();
        while (iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            if (resource.getUniqueID() != null) continue;
            resource.setUniqueID(resource.getID());
        }
    }

    public void read(String file) throws MPXException {
        try {
            FileInputStream fis = new FileInputStream(file);
            this.read(fis);
            fis.close();
        }
        catch (IOException ex) {
            throw new MPXException("Error reading file", ex);
        }
    }

    public void read(File file) throws MPXException {
        try {
            FileInputStream fis = new FileInputStream(file);
            this.read(fis);
            fis.close();
        }
        catch (IOException ex) {
            throw new MPXException("Error reading file", ex);
        }
    }

    private MPXRecord add(int recordNumber) throws MPXException {
        return this.add(String.valueOf(recordNumber), Record.EMPTY_RECORD);
    }

    private MPXRecord add(String recordNumber, Record record) throws MPXException {
        MPXRecord current = null;
        switch (Integer.parseInt(recordNumber)) {
            case 0: {
                current = new Comments(this, record);
                this.m_records.add(current);
                break;
            }
            case 10: {
                this.m_projectHeader.updateCurrencySettings(record);
                this.updateFormats();
                current = this.m_projectHeader;
                break;
            }
            case 11: {
                this.m_projectHeader.updateDefaultSettings(record);
                current = this.m_projectHeader;
                break;
            }
            case 12: {
                this.m_projectHeader.updateDateTimeSettings(record);
                current = this.m_projectHeader;
                break;
            }
            case 20: {
                this.m_lastBaseCalendar = new MPXCalendar(this, record, true);
                current = this.m_lastBaseCalendar;
                this.m_records.add(current);
                this.m_baseCalendars.add(current);
                break;
            }
            case 25: {
                if (this.m_lastBaseCalendar == null) break;
                current = this.m_lastBaseCalendar.addCalendarHours(record);
                break;
            }
            case 26: {
                if (this.m_lastBaseCalendar == null) break;
                current = this.m_lastBaseCalendar.addCalendarException(record);
                break;
            }
            case 30: {
                this.m_projectHeader.updateProjectHeader(record);
                current = this.m_projectHeader;
                break;
            }
            case 40: {
                if (this.m_resourceTableDefinition || this.m_ignoreTextModels) break;
                current = this.m_resourceModel;
                this.m_resourceModel.update(record, true);
                this.m_resourceTableDefinition = true;
                break;
            }
            case 41: {
                if (this.m_resourceTableDefinition) break;
                current = this.m_resourceModel;
                this.m_resourceModel.update(record, false);
                this.m_resourceTableDefinition = true;
                break;
            }
            case 50: {
                this.m_lastResource = new Resource(this, record);
                current = this.m_lastResource;
                this.m_records.add(current);
                this.m_allResources.add(current);
                break;
            }
            case 51: {
                if (this.m_lastResource == null) break;
                current = this.m_lastResource.addResourceNotes(record);
                break;
            }
            case 55: {
                if (this.m_lastResource == null) break;
                this.m_lastResourceCalendar = this.m_lastResource.addResourceCalendar(record);
                current = this.m_lastResourceCalendar;
                break;
            }
            case 56: {
                if (this.m_lastResourceCalendar == null) break;
                current = this.m_lastResourceCalendar.addCalendarHours(record);
                break;
            }
            case 57: {
                if (this.m_lastResourceCalendar == null) break;
                current = this.m_lastResourceCalendar.addCalendarException(record);
                break;
            }
            case 60: {
                if (this.m_taskTableDefinition || this.m_ignoreTextModels) break;
                current = this.m_taskModel;
                this.m_taskModel.update(record, true);
                this.m_taskTableDefinition = true;
                break;
            }
            case 61: {
                if (this.m_taskTableDefinition) break;
                current = this.m_taskModel;
                this.m_taskModel.update(record, false);
                this.m_taskTableDefinition = true;
                break;
            }
            case 70: {
                this.m_lastTask = new Task(this, record);
                current = this.m_lastTask;
                this.m_records.add(current);
                this.m_allTasks.add(current);
                int outlineLevel = this.m_lastTask.getOutlineLevelValue();
                if (this.m_baseOutlineLevel == -1) {
                    this.m_baseOutlineLevel = outlineLevel;
                }
                if (outlineLevel == this.m_baseOutlineLevel) {
                    this.m_childTasks.add(this.m_lastTask);
                    break;
                }
                if (this.m_childTasks.isEmpty()) {
                    throw new MPXException("Invalid outline level");
                }
                ((Task)this.m_childTasks.getLast()).addChildTask(this.m_lastTask, outlineLevel);
                break;
            }
            case 71: {
                if (this.m_lastTask == null) break;
                current = this.m_lastTask.addTaskNotes(record);
                break;
            }
            case 72: {
                if (this.m_lastTask == null) break;
                current = this.m_lastTask.addRecurringTask(record);
                break;
            }
            case 75: {
                if (this.m_lastTask == null) break;
                this.m_lastResourceAssignment = this.m_lastTask.addResourceAssignment(record);
                current = this.m_lastResourceAssignment;
                this.m_allResourceAssignments.add(this.m_lastResourceAssignment);
                break;
            }
            case 76: {
                if (this.m_lastResourceAssignment == null) break;
                current = this.m_lastResourceAssignment.addWorkgroupAssignment(record);
                break;
            }
            case 80: {
                current = new ProjectNames(this, record);
                this.m_records.add(current);
                ++this.m_projectNames;
                break;
            }
            case 81: {
                current = new DdeOleClientLinks(this, record);
                this.m_records.add(current);
                ++this.m_ddeOleClientLinks;
                break;
            }
            case 999: {
                current = this.getFileCreationRecord();
                current.setValues(record);
                break;
            }
            default: {
                throw new MPXException("Invalid record");
            }
        }
        return current;
    }

    void addTask(Task task) {
        this.m_records.add(task);
        this.m_allTasks.add(task);
    }

    public Task addTask() throws MPXException {
        return (Task)this.add(70);
    }

    public LinkedList getChildTasks() {
        return this.m_childTasks;
    }

    public LinkedList getAllTasks() {
        return this.m_allTasks;
    }

    TaskModel getTaskModel() {
        return this.m_taskModel;
    }

    ResourceModel getResourceModel() {
        return this.m_resourceModel;
    }

    public void setAutoWBS(boolean flag) {
        this.m_autoWBS = flag;
    }

    public void setAutoOutlineLevel(boolean flag) {
        this.m_autoOutlineLevel = flag;
    }

    public void setAutoOutlineNumber(boolean flag) {
        this.m_autoOutlineNumber = flag;
    }

    public void setAutoTaskUniqueID(boolean flag) {
        this.m_autoTaskUniqueID = flag;
    }

    public void setAutoCalendarUniqueID(boolean flag) {
        this.m_autoCalendarUniqueID = flag;
    }

    public void setAutoTaskID(boolean flag) {
        this.m_autoTaskID = flag;
    }

    public boolean getAutoWBS() {
        return this.m_autoWBS;
    }

    public boolean getAutoOutlineLevel() {
        return this.m_autoOutlineLevel;
    }

    public boolean getAutoOutlineNumber() {
        return this.m_autoOutlineNumber;
    }

    public boolean getAutoTaskUniqueID() {
        return this.m_autoTaskUniqueID;
    }

    public boolean getAutoCalendarUniqueID() {
        return this.m_autoCalendarUniqueID;
    }

    public boolean getAutoTaskID() {
        return this.m_autoTaskID;
    }

    int getTaskUniqueID() {
        return ++this.m_taskUniqueID;
    }

    int getCalendarUniqueID() {
        return ++this.m_calendarUniqueID;
    }

    int getTaskID() {
        return ++this.m_taskID;
    }

    public void setAutoResourceUniqueID(boolean flag) {
        this.m_autoResourceUniqueID = flag;
    }

    public void setAutoResourceID(boolean flag) {
        this.m_autoResourceID = flag;
    }

    public boolean getAutoResourceUniqueID() {
        return this.m_autoResourceUniqueID;
    }

    public void setIgnoreTextModels(boolean flag) {
        this.m_ignoreTextModels = flag;
    }

    public boolean getIgnoreTextModels() {
        return this.m_ignoreTextModels;
    }

    public boolean getAutoResourceID() {
        return this.m_autoResourceID;
    }

    int getResourceUniqueID() {
        return ++this.m_resourceUniqueID;
    }

    int getResourceID() {
        return ++this.m_resourceID;
    }

    public Comments addComments() throws MPXException {
        return (Comments)this.add(0);
    }

    public FileCreationRecord getFileCreationRecord() {
        return this.m_fileCreationRecord;
    }

    protected MPXCalendar addResourceCalendar() {
        return new MPXCalendar(this, false);
    }

    public MPXCalendar addBaseCalendar() throws MPXException {
        return (MPXCalendar)this.add(20);
    }

    public MPXCalendar addDefaultBaseCalendar() throws MPXException {
        MPXCalendar calendar = (MPXCalendar)this.add(20);
        calendar.setName("Standard");
        calendar.setWorkingDay(Day.SUNDAY, false);
        calendar.setWorkingDay(Day.MONDAY, true);
        calendar.setWorkingDay(Day.TUESDAY, true);
        calendar.setWorkingDay(Day.WEDNESDAY, true);
        calendar.setWorkingDay(Day.THURSDAY, true);
        calendar.setWorkingDay(Day.FRIDAY, true);
        calendar.setWorkingDay(Day.SATURDAY, false);
        calendar.addDefaultCalendarHours();
        return calendar;
    }

    protected MPXCalendar addDefaultResourceCalendar() {
        MPXCalendar calendar = new MPXCalendar(this, false);
        calendar.setWorkingDay(Day.SUNDAY, 2);
        calendar.setWorkingDay(Day.MONDAY, 2);
        calendar.setWorkingDay(Day.TUESDAY, 2);
        calendar.setWorkingDay(Day.WEDNESDAY, 2);
        calendar.setWorkingDay(Day.THURSDAY, 2);
        calendar.setWorkingDay(Day.FRIDAY, 2);
        calendar.setWorkingDay(Day.SATURDAY, 2);
        return calendar;
    }

    protected void attachResourceCalendar(Resource resource, MPXCalendar calendar) {
        resource.attachResourceCalendar(calendar);
    }

    public LinkedList getBaseCalendars() {
        return this.m_baseCalendars;
    }

    public ProjectHeader getProjectHeader() {
        return this.m_projectHeader;
    }

    public Resource addResource() throws MPXException {
        return (Resource)this.add(50);
    }

    public LinkedList getAllResources() {
        return this.m_allResources;
    }

    public LinkedList getAllResourceAssignments() {
        return this.m_allResourceAssignments;
    }

    void addResourceAssignment(ResourceAssignment assignment) {
        this.m_allResourceAssignments.add(assignment);
    }

    public ProjectNames addProjectNames() throws MPXException {
        return (ProjectNames)this.add(80);
    }

    public DdeOleClientLinks addDdeOleClientLinks() throws MPXException {
        return (DdeOleClientLinks)this.add(81);
    }

    public MPXCalendar getBaseCalendar(String calendarName) {
        String name;
        MPXCalendar calendar = null;
        Iterator iter = this.m_baseCalendars.iterator();
        while (iter.hasNext() && ((name = (calendar = (MPXCalendar)iter.next()).getName()) == null || !name.equalsIgnoreCase(calendarName))) {
            calendar = null;
        }
        return calendar;
    }

    public MPXCalendar getBaseCalendarByUniqueID(int calendarID) {
        MPXCalendar calendar = null;
        Iterator iter = this.m_baseCalendars.iterator();
        while (iter.hasNext() && (calendar = (MPXCalendar)iter.next()).getUniqueID() != calendarID) {
            calendar = null;
        }
        return calendar;
    }

    public void write(OutputStreamWriter w) throws IOException {
        this.updateFormats();
        Iterator iter = this.m_records.iterator();
        while (iter.hasNext()) {
            w.write(iter.next().toString());
        }
        w.flush();
        this.m_taskModel.setWritten(false);
        this.m_resourceModel.setWritten(false);
    }

    public void write(OutputStream out) throws IOException {
        this.write(new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), this.getFileCreationRecord().getCodePage().getCharset()));
    }

    public void write(File out) throws IOException {
        FileOutputStream fos = new FileOutputStream(out);
        this.write(fos);
        fos.flush();
        fos.close();
    }

    public void write(String file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        this.write(fos);
        fos.flush();
        fos.close();
    }

    MPXTimeFormat getTimeFormat() {
        return this.m_timeFormat;
    }

    MPXDateFormat getDateTimeFormat() {
        return this.m_dateTimeFormat;
    }

    MPXDateFormat getDateFormat() {
        return this.m_dateFormat;
    }

    MPXNumberFormat getCurrencyFormat() {
        return this.m_currencyFormat;
    }

    void setCurrencyFormat(String primaryPattern, String[] alternativePatterns, char decimalSeparator, char groupingSeparator) {
        this.m_currencyFormat.applyPattern(primaryPattern, alternativePatterns, this.getDecimalSeparator(), this.getThousandsSeparator());
        this.m_zeroCurrency = new MPXCurrency(this.m_currencyFormat, 0.0);
    }

    MPXCurrency getZeroCurrency() {
        return this.m_zeroCurrency;
    }

    int getChildTaskCount() {
        return this.m_childTasks.size();
    }

    public MPXDuration getDuration(Date startDate, Date endDate) throws MPXException {
        return this.getDuration("Standard", startDate, endDate);
    }

    public MPXDuration getDuration(String calendarName, Date startDate, Date endDate) throws MPXException {
        MPXCalendar calendar = this.getBaseCalendar(calendarName);
        if (calendar == null) {
            throw new MPXException("Invalid calendar: " + calendarName);
        }
        return calendar.getDuration(startDate, endDate);
    }

    public Task getTaskByID(int id) {
        return (Task)this.m_taskIDMap.get(new Integer(id));
    }

    public Task getTaskByUniqueID(int id) {
        return (Task)this.m_taskUniqueIDMap.get(new Integer(id));
    }

    public Resource getResourceByID(int id) {
        return (Resource)this.m_resourceIDMap.get(new Integer(id));
    }

    public Resource getResourceByUniqueID(int id) {
        return (Resource)this.m_resourceUniqueIDMap.get(new Integer(id));
    }

    protected void updateStructure() {
        if (this.m_allTasks.size() > 1) {
            Collections.sort(this.m_allTasks);
            this.m_childTasks.clear();
            Task lastTask = null;
            int lastLevel = -1;
            Iterator iter = this.m_allTasks.iterator();
            while (iter.hasNext()) {
                Task task = (Task)iter.next();
                task.clearChildTasks();
                int level = task.getOutlineLevelValue();
                Task parent = null;
                if (lastTask != null) {
                    if (level == lastLevel) {
                        parent = lastTask.getParentTask();
                    } else if (level > lastLevel) {
                        parent = lastTask;
                    } else {
                        while (level <= lastLevel && (parent = lastTask.getParentTask()) != null) {
                            lastLevel = parent.getOutlineLevelValue();
                            lastTask = parent;
                        }
                    }
                }
                lastTask = task;
                lastLevel = level;
                if (this.getAutoWBS()) {
                    task.generateWBS(parent);
                }
                if (this.getAutoOutlineNumber()) {
                    task.generateOutlineNumber(parent);
                }
                if (parent == null) {
                    this.m_childTasks.add(task);
                    continue;
                }
                parent.addChildTask(task);
            }
        }
    }

    public char getDecimalSeparator() {
        return this.m_decimalSeparator;
    }

    public void setDecimalSeparator(char separator) {
        this.m_decimalSeparator = separator;
        if (this.m_projectHeader != null && this.m_projectHeader.getDecimalSeparator() != separator) {
            this.m_projectHeader.setDecimalSeparator(separator);
        }
    }

    public char getThousandsSeparator() {
        return this.m_thousandsSeparator;
    }

    public void setThousandsSeparator(char separator) {
        this.m_thousandsSeparator = separator;
        if (this.m_projectHeader != null && this.m_projectHeader.getThousandsSeparator() != separator) {
            this.m_projectHeader.setThousandsSeparator(separator);
        }
    }

    public Date getStartDate() {
        Date startDate = null;
        Iterator iter = this.m_allTasks.iterator();
        while (iter.hasNext()) {
            Task task = (Task)iter.next();
            if (task.getUniqueIDValue() == 0) continue;
            Date taskStartDate = task.getActualStart();
            if (taskStartDate == null) {
                taskStartDate = task.getStart();
            }
            if (taskStartDate == null) continue;
            if (startDate == null) {
                startDate = taskStartDate;
                continue;
            }
            if (taskStartDate.getTime() >= startDate.getTime()) continue;
            startDate = taskStartDate;
        }
        return startDate;
    }

    public Date getFinishDate() {
        Date finishDate = null;
        Iterator iter = this.m_allTasks.iterator();
        while (iter.hasNext()) {
            Task task = (Task)iter.next();
            if (task.getUniqueIDValue() == 0) continue;
            Date taskFinishDate = task.getActualFinish();
            if (taskFinishDate == null) {
                taskFinishDate = task.getFinish();
            }
            if (taskFinishDate == null) continue;
            if (finishDate == null) {
                finishDate = taskFinishDate;
                continue;
            }
            if (taskFinishDate.getTime() <= finishDate.getTime()) continue;
            finishDate = taskFinishDate;
        }
        return finishDate;
    }

    private void updateFormats() {
        this.m_decimalFormat = new MPXNumberFormat("0.00#", this.m_decimalSeparator, this.m_thousandsSeparator);
        this.m_durationDecimalFormat = new MPXNumberFormat("#.#", this.m_decimalSeparator, this.m_thousandsSeparator);
        this.m_percentageDecimalFormat = new MPXNumberFormat("##0.##", this.m_decimalSeparator, this.m_thousandsSeparator);
        this.m_unitsDecimalFormat = new MPXNumberFormat("#.##", this.m_decimalSeparator, this.m_thousandsSeparator);
    }

    MPXNumberFormat getDecimalFormat() {
        return new MPXNumberFormat("0.00#", this.m_decimalSeparator, this.m_thousandsSeparator);
    }

    MPXNumberFormat getDurationDecimalFormat() {
        return new MPXNumberFormat("#.#", this.m_decimalSeparator, this.m_thousandsSeparator);
    }

    MPXNumberFormat getPercentageDecimalFormat() {
        return new MPXNumberFormat("##0.##", this.m_decimalSeparator, this.m_thousandsSeparator);
    }

    MPXNumberFormat getUnitsDecimalFormat() {
        return new MPXNumberFormat("#.##", this.m_decimalSeparator, this.m_thousandsSeparator);
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
        this.m_delimiter = LocaleData.getChar(this.m_locale, "FILE_DELIMITER");
        this.m_thousandsSeparator = LocaleData.getChar(this.m_locale, "CURRENCY_THOUSANDS_SEPARATOR");
        this.m_decimalSeparator = LocaleData.getChar(this.m_locale, "CURRENCY_DECIMAL_SEPARATOR");
        this.m_fileCreationRecord.setLocale(locale);
        this.m_projectHeader.setLocale(locale);
        this.m_dateTimeFormat.setLocale(locale);
        this.m_dateFormat.setLocale(locale);
        this.m_timeFormat.setLocale(locale);
        this.m_taskModel.setLocale(locale);
        this.m_resourceModel.setLocale(locale);
    }

    public void setTaskFieldAlias(int field, String alias) {
        if (alias != null && alias.length() != 0) {
            Integer id = new Integer(field);
            this.m_taskFieldAlias.put(id, alias);
            this.m_aliasTaskField.put(alias, id);
        }
    }

    public String getTaskFieldAlias(int field) {
        return (String)this.m_taskFieldAlias.get(new Integer(field));
    }

    public int getAliasTaskField(String alias) {
        Integer result = (Integer)this.m_aliasTaskField.get(alias);
        int field = result == null ? -1 : result;
        return field;
    }

    public void setResourceFieldAlias(int field, String alias) {
        if (alias != null && alias.length() != 0) {
            Integer id = new Integer(field);
            this.m_resourceFieldAlias.put(id, alias);
            this.m_aliasResourceField.put(alias, id);
        }
    }

    public String getResourceFieldAlias(int field) {
        return (String)this.m_resourceFieldAlias.get(new Integer(field));
    }

    public int getAliasResourceField(String alias) {
        Integer result = (Integer)this.m_aliasResourceField.get(alias);
        int field = result == null ? -1 : result;
        return field;
    }

    protected boolean taskFieldAliasesDefined() {
        return !this.m_taskFieldAlias.isEmpty();
    }

    protected boolean resourceFieldAliasesDefined() {
        return !this.m_resourceFieldAlias.isEmpty();
    }

    protected HashMap getTaskFieldAliasMap() {
        return this.m_taskFieldAlias;
    }

    protected HashMap getResourceFieldAliasMap() {
        return this.m_resourceFieldAlias;
    }

    void unmapTaskUniqueID(Integer id) {
        this.m_taskUniqueIDMap.remove(id);
    }

    void mapTaskUniqueID(Integer id, Task task) {
        this.m_taskUniqueIDMap.put(id, task);
    }

    void unmapTaskID(Integer id) {
        this.m_taskIDMap.remove(id);
    }

    void mapTaskID(Integer id, Task task) {
        this.m_taskIDMap.put(id, task);
    }

    void unmapResourceUniqueID(Integer id) {
        this.m_resourceUniqueIDMap.remove(id);
    }

    void mapResourceUniqueID(Integer id, Resource resource) {
        this.m_resourceUniqueIDMap.put(id, resource);
    }

    void unmapResourceID(Integer id) {
        this.m_resourceIDMap.remove(id);
    }

    void mapResourceID(Integer id, Resource resource) {
        this.m_resourceIDMap.put(id, resource);
    }
}

