/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.MPXRecord;
import com.tapsterrock.mpx.Record;

public final class ResourceNotes
extends MPXRecord {
    private String m_note;
    static final int RECORD_NUMBER = 51;

    ResourceNotes(MPXFile file) {
        this(file, Record.EMPTY_RECORD);
    }

    ResourceNotes(MPXFile file, Record record) {
        super(file, 0);
        this.m_note = record.getString(0);
    }

    public String getNotes() {
        return this.m_note;
    }

    public void setNotes(String notes) {
        this.m_note = notes;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        char delimiter = this.getParentFile().getDelimiter();
        buffer.append(51);
        buffer.append(delimiter);
        if (this.m_note != null) {
            String note = this.stripLineBreaks(this.m_note, EOL_PLACEHOLDER_STRING);
            boolean quote = note.indexOf(delimiter) != -1 || note.indexOf(34) != -1;
            int length = note.length();
            if (quote) {
                buffer.append('\"');
            }
            block3: for (int loop = 0; loop < length; ++loop) {
                char c = note.charAt(loop);
                switch (c) {
                    case '\"': {
                        buffer.append("\"\"");
                        continue block3;
                    }
                    default: {
                        buffer.append(c);
                    }
                }
            }
            if (quote) {
                buffer.append('\"');
            }
        }
        buffer.append("\r\n");
        return buffer.toString();
    }
}

