/*
 * Decompiled with CFR 0.152.
 */
package org.cyberneko.html.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.html.HTMLDocument;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMFragmentParser
implements XMLDocumentHandler {
    protected static final String DOCUMENT_FRAGMENT = "http://cyberneko.org/html/features/document-fragment";
    protected XMLParserConfiguration fParserConfiguration = new HTMLConfiguration();
    protected XMLDocumentSource fDocumentSource;
    protected DocumentFragment fDocumentFragment;
    protected HTMLDocument fHTMLDocument;
    protected Node fCurrentNode;
    protected boolean fInCDATASection;

    public DOMFragmentParser() {
        this.fParserConfiguration.setFeature(DOCUMENT_FRAGMENT, true);
        this.fParserConfiguration.setDocumentHandler((XMLDocumentHandler)this);
    }

    public void parse(String string, DocumentFragment documentFragment) throws SAXException, IOException {
        this.parse(new InputSource(string), documentFragment);
    }

    public void parse(InputSource inputSource, DocumentFragment documentFragment) throws SAXException, IOException {
        this.fDocumentFragment = documentFragment;
        this.fHTMLDocument = (HTMLDocument)this.fDocumentFragment.getOwnerDocument();
        this.fCurrentNode = this.fDocumentFragment;
        try {
            String string = inputSource.getPublicId();
            String string2 = inputSource.getSystemId();
            String string3 = inputSource.getEncoding();
            InputStream inputStream = inputSource.getByteStream();
            Reader reader = inputSource.getCharacterStream();
            XMLInputSource xMLInputSource = new XMLInputSource(string, string2, string2);
            xMLInputSource.setEncoding(string3);
            xMLInputSource.setByteStream(inputStream);
            xMLInputSource.setCharacterStream(reader);
            this.fParserConfiguration.parse(xMLInputSource);
        }
        catch (XMLParseException xMLParseException) {
            Exception exception = xMLParseException.getException();
            if (exception != null) {
                throw new SAXParseException(xMLParseException.getMessage(), null, exception);
            }
            throw new SAXParseException(xMLParseException.getMessage(), null);
        }
    }

    public void setDocumentSource(XMLDocumentSource xMLDocumentSource) {
        this.fDocumentSource = xMLDocumentSource;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.fDocumentSource;
    }

    public void startDocument(XMLLocator xMLLocator, String string, Augmentations augmentations) throws XNIException {
        this.startDocument(xMLLocator, string, null, augmentations);
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fInCDATASection = false;
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        ProcessingInstruction processingInstruction = this.fHTMLDocument.createProcessingInstruction(string, xMLString.toString());
        this.fCurrentNode.appendChild(processingInstruction);
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        Comment comment = this.fHTMLDocument.createComment(xMLString.toString());
        this.fCurrentNode.appendChild(comment);
    }

    public void startPrefixMapping(String string, String string2, Augmentations augmentations) throws XNIException {
    }

    public void endPrefixMapping(String string, Augmentations augmentations) throws XNIException {
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        Element element = this.fHTMLDocument.createElement(qName.rawname);
        int n = xMLAttributes != null ? xMLAttributes.getLength() : 0;
        int n2 = 0;
        while (n2 < n) {
            String string = xMLAttributes.getQName(n2);
            String string2 = xMLAttributes.getValue(n2);
            element.setAttribute(string, string2);
            ++n2;
        }
        this.fCurrentNode.appendChild(element);
        this.fCurrentNode = element;
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.startElement(qName, xMLAttributes, augmentations);
        this.endElement(qName, augmentations);
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fInCDATASection) {
            Node node = this.fCurrentNode.getLastChild();
            if (node != null && node.getNodeType() == 4) {
                CDATASection cDATASection = (CDATASection)node;
                cDATASection.appendData(xMLString.toString());
            } else {
                CDATASection cDATASection = this.fHTMLDocument.createCDATASection(xMLString.toString());
                this.fCurrentNode.appendChild(cDATASection);
            }
        } else {
            Node node = this.fCurrentNode.getLastChild();
            if (node != null && node.getNodeType() == 3) {
                Text text = (Text)node;
                text.appendData(xMLString.toString());
            } else {
                Text text = this.fHTMLDocument.createTextNode(xMLString.toString());
                this.fCurrentNode.appendChild(text);
            }
        }
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.characters(xMLString, augmentations);
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        EntityReference entityReference = this.fHTMLDocument.createEntityReference(string);
        this.fCurrentNode.appendChild(entityReference);
        this.fCurrentNode = entityReference;
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
        this.fCurrentNode = this.fCurrentNode.getParentNode();
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        this.fInCDATASection = true;
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        this.fInCDATASection = false;
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        this.fCurrentNode = this.fCurrentNode.getParentNode();
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
    }
}

