/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda;

import net.sf.memoranda.Project;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.date.CurrentDate;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;

public class ProjectImpl
implements Project {
    private Element _root = null;

    public ProjectImpl(Element element) {
        this._root = element;
    }

    public String getID() {
        return this._root.getAttribute("id").getValue();
    }

    public CalendarDate getStartDate() {
        Attribute attribute = this._root.getAttribute("startDate");
        if (attribute == null) {
            return null;
        }
        return new CalendarDate(attribute.getValue());
    }

    public void setStartDate(CalendarDate calendarDate) {
        if (calendarDate != null) {
            this.setAttr("startDate", calendarDate.toString());
        }
    }

    public CalendarDate getEndDate() {
        Attribute attribute = this._root.getAttribute("endDate");
        if (attribute == null) {
            return null;
        }
        return new CalendarDate(attribute.getValue());
    }

    public void setEndDate(CalendarDate calendarDate) {
        if (calendarDate != null) {
            this.setAttr("endDate", calendarDate.toString());
        } else if (this._root.getAttribute("endDate") != null) {
            this.setAttr("endDate", null);
        }
    }

    public int getStatus() {
        if (this.isFrozen()) {
            return 4;
        }
        CalendarDate calendarDate = CurrentDate.get();
        CalendarDate calendarDate2 = this.getStartDate();
        CalendarDate calendarDate3 = this.getEndDate();
        if (calendarDate3 == null) {
            if (calendarDate.before(calendarDate2)) {
                return 0;
            }
            return 1;
        }
        if (calendarDate.inPeriod(calendarDate2, calendarDate3)) {
            return 1;
        }
        if (calendarDate.after(calendarDate3)) {
            return 2;
        }
        return 0;
    }

    private boolean isFrozen() {
        return this._root.getAttribute("frozen") != null;
    }

    public void freeze() {
        this._root.addAttribute(new Attribute("frozen", "yes"));
    }

    public void unfreeze() {
        if (this.isFrozen()) {
            this._root.removeAttribute(new Attribute("frozen", "yes"));
        }
    }

    public String getTitle() {
        Attribute attribute = this._root.getAttribute("title");
        if (attribute != null) {
            return attribute.getValue();
        }
        return "";
    }

    public void setTitle(String string) {
        this.setAttr("title", string);
    }

    private void setAttr(String string, String string2) {
        Attribute attribute = this._root.getAttribute(string);
        if (attribute == null) {
            if (string2 != null) {
                this._root.addAttribute(new Attribute(string, string2));
            }
        } else if (string2 != null) {
            attribute.setValue(string2);
        } else {
            this._root.removeAttribute(attribute);
        }
    }

    public String getDescription() {
        Element element = this._root.getFirstChildElement("description");
        if (element == null) {
            return null;
        }
        return element.getValue();
    }

    public void setDescription(String string) {
        Element element = this._root.getFirstChildElement("description");
        if (element == null) {
            element = new Element("description");
            element.appendChild(string);
            this._root.appendChild((Node)element);
        } else {
            element.removeChildren();
            element.appendChild(string);
        }
    }
}

