/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import net.sf.memoranda.CurrentNote;
import net.sf.memoranda.CurrentProject;
import net.sf.memoranda.Event;
import net.sf.memoranda.EventNotificationListener;
import net.sf.memoranda.EventsScheduler;
import net.sf.memoranda.History;
import net.sf.memoranda.HistoryItem;
import net.sf.memoranda.HistoryListener;
import net.sf.memoranda.Note;
import net.sf.memoranda.NoteList;
import net.sf.memoranda.NoteListener;
import net.sf.memoranda.Project;
import net.sf.memoranda.ProjectListener;
import net.sf.memoranda.ResourcesList;
import net.sf.memoranda.Task;
import net.sf.memoranda.TaskList;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.date.CurrentDate;
import net.sf.memoranda.date.DateListener;
import net.sf.memoranda.ui.AgendaPanel;
import net.sf.memoranda.ui.App;
import net.sf.memoranda.ui.AppFrame;
import net.sf.memoranda.ui.EditorPanel;
import net.sf.memoranda.ui.EventsPanel;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.ui.JNCalendarPanel;
import net.sf.memoranda.ui.NotesControlPanel;
import net.sf.memoranda.ui.TaskPanel;
import net.sf.memoranda.ui.WorkPanel;
import net.sf.memoranda.util.CurrentStorage;
import net.sf.memoranda.util.Local;
import net.sf.memoranda.util.Util;

public class DailyItemsPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    JSplitPane splitPane = new JSplitPane();
    JPanel controlPanel = new JPanel();
    JPanel mainPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel statusPanel = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel editorsPanel = new JPanel();
    CardLayout cardLayout1 = new CardLayout();
    public EditorPanel editorPanel = new EditorPanel(this);
    JLabel currentDateLabel = new JLabel();
    BorderLayout borderLayout4 = new BorderLayout();
    TaskPanel tasksPanel = new TaskPanel(this);
    EventsPanel eventsPanel = new EventsPanel(this);
    AgendaPanel agendaPanel = new AgendaPanel(this);
    ImageIcon expIcon = new ImageIcon(AppFrame.class.getResource("resources/icons/exp_right.png"));
    ImageIcon collIcon = new ImageIcon(AppFrame.class.getResource("resources/icons/exp_left.png"));
    ImageIcon bookmarkIcon = new ImageIcon(AppFrame.class.getResource("resources/icons/star8.png"));
    boolean expanded = true;
    Note currentNote;
    CalendarDate currentDate;
    boolean calendarIgnoreChange = false;
    boolean dateChangedByCalendar = false;
    boolean changedByHistory = false;
    JPanel cmainPanel = new JPanel();
    JNCalendarPanel calendar = new JNCalendarPanel();
    JToolBar toggleToolBar = new JToolBar();
    BorderLayout borderLayout5 = new BorderLayout();
    Border border1;
    JButton toggleButton = new JButton();
    WorkPanel parentPanel = null;
    boolean addedToHistory = false;
    JPanel indicatorsPanel = new JPanel();
    JButton alarmB = new JButton();
    FlowLayout flowLayout1 = new FlowLayout();
    JButton taskB = new JButton();
    JPanel mainTabsPanel = new JPanel();
    NotesControlPanel notesControlPane = new NotesControlPanel();
    CardLayout cardLayout2 = new CardLayout();
    JTabbedPane tasksTabbedPane = new JTabbedPane();
    JTabbedPane eventsTabbedPane = new JTabbedPane();
    JTabbedPane agendaTabbedPane = new JTabbedPane();
    Border border2;
    String CurrentPanel;
    Cursor waitCursor = new Cursor(3);

    public DailyItemsPanel(WorkPanel workPanel) {
        try {
            this.parentPanel = workPanel;
            this.jbInit();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception);
        }
    }

    void jbInit() throws Exception {
        this.border1 = BorderFactory.createEtchedBorder(Color.white, Color.gray);
        this.border2 = BorderFactory.createEtchedBorder(Color.white, new Color(161, 161, 161));
        this.setLayout(this.borderLayout1);
        this.splitPane.setOrientation(1);
        this.splitPane.setBorder(null);
        this.splitPane.setDividerSize(2);
        this.controlPanel.setLayout(this.borderLayout2);
        this.mainPanel.setLayout(this.borderLayout3);
        this.editorsPanel.setLayout(this.cardLayout1);
        this.statusPanel.setBackground(Color.black);
        this.statusPanel.setForeground(Color.white);
        this.statusPanel.setMinimumSize(new Dimension(14, 24));
        this.statusPanel.setPreferredSize(new Dimension(14, 24));
        this.statusPanel.setLayout(this.borderLayout4);
        this.currentDateLabel.setFont(new Font("Dialog", 0, 16));
        this.currentDateLabel.setForeground(Color.white);
        this.currentDateLabel.setText(CurrentDate.get().getFullDateString());
        this.borderLayout4.setHgap(4);
        this.controlPanel.setBackground(new Color(230, 230, 230));
        this.controlPanel.setBorder(this.border2);
        this.controlPanel.setMinimumSize(new Dimension(20, 170));
        this.controlPanel.setPreferredSize(new Dimension(205, 170));
        this.calendar.setFont(new Font("Dialog", 0, 11));
        this.calendar.setMinimumSize(new Dimension(0, 168));
        this.toggleToolBar.setBackground(new Color(215, 225, 250));
        this.toggleToolBar.setRequestFocusEnabled(false);
        this.toggleToolBar.setFloatable(false);
        this.cmainPanel.setLayout(this.borderLayout5);
        this.cmainPanel.setBackground(SystemColor.desktop);
        this.cmainPanel.setMinimumSize(new Dimension(0, 168));
        this.cmainPanel.setOpaque(false);
        this.toggleButton.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.toggleButton.setMinimumSize(new Dimension(16, 16));
        this.toggleButton.setOpaque(false);
        this.toggleButton.setPreferredSize(new Dimension(16, 16));
        this.toggleButton.setBorderPainted(false);
        this.toggleButton.setContentAreaFilled(false);
        this.toggleButton.setFocusPainted(false);
        this.toggleButton.setMargin(new Insets(0, 0, 0, 0));
        this.toggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DailyItemsPanel.this.toggleButton_actionPerformed(actionEvent);
            }
        });
        this.toggleButton.setIcon(this.collIcon);
        this.indicatorsPanel.setOpaque(false);
        this.indicatorsPanel.setLayout(this.flowLayout1);
        this.alarmB.setMaximumSize(new Dimension(24, 24));
        this.alarmB.setOpaque(false);
        this.alarmB.setPreferredSize(new Dimension(24, 24));
        this.alarmB.setToolTipText(Local.getString("Active events"));
        this.alarmB.setBorderPainted(false);
        this.alarmB.setMargin(new Insets(0, 0, 0, 0));
        this.alarmB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DailyItemsPanel.this.alarmB_actionPerformed(actionEvent);
            }
        });
        this.alarmB.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/alarm.png")));
        this.flowLayout1.setAlignment(2);
        this.flowLayout1.setVgap(0);
        this.taskB.setMargin(new Insets(0, 0, 0, 0));
        this.taskB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DailyItemsPanel.this.taskB_actionPerformed(actionEvent);
            }
        });
        this.taskB.setPreferredSize(new Dimension(24, 24));
        this.taskB.setToolTipText(Local.getString("Active to-do tasks"));
        this.taskB.setBorderPainted(false);
        this.taskB.setMaximumSize(new Dimension(24, 24));
        this.taskB.setOpaque(false);
        this.taskB.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/task.png")));
        this.notesControlPane.setFont(new Font("Dialog", 1, 10));
        this.mainTabsPanel.setLayout(this.cardLayout2);
        this.add((Component)this.splitPane, "Center");
        this.controlPanel.add((Component)this.cmainPanel, "Center");
        this.cmainPanel.add((Component)this.calendar, "North");
        this.mainPanel.add((Component)this.statusPanel, "North");
        this.statusPanel.add((Component)this.currentDateLabel, "Center");
        this.statusPanel.add((Component)this.indicatorsPanel, "East");
        this.mainPanel.add((Component)this.editorsPanel, "Center");
        this.editorsPanel.add((Component)this.agendaPanel, "AGENDA");
        this.editorsPanel.add((Component)this.eventsPanel, "EVENTS");
        this.editorsPanel.add((Component)this.tasksPanel, "TASKS");
        this.editorsPanel.add((Component)this.editorPanel, "NOTES");
        this.splitPane.add((Component)this.mainPanel, "right");
        this.splitPane.add((Component)this.controlPanel, "left");
        this.controlPanel.add((Component)this.toggleToolBar, "South");
        this.toggleToolBar.add((Component)this.toggleButton, null);
        this.splitPane.setDividerLocation((int)this.controlPanel.getPreferredSize().getWidth());
        CurrentDate.addDateListener(new DateListener(){

            public void dateChange(CalendarDate calendarDate) {
                DailyItemsPanel.this.currentDateChanged(calendarDate);
            }
        });
        CurrentProject.addProjectListener(new ProjectListener(){

            public void projectChange(Project project, NoteList noteList, TaskList taskList, ResourcesList resourcesList) {
                DailyItemsPanel.this.currentProjectChanged(project, noteList, taskList, resourcesList);
            }

            public void projectWasChanged() {
                DailyItemsPanel.this.currentNote = CurrentProject.getNoteList().getNoteForDate(CurrentDate.get());
                CurrentNote.set(DailyItemsPanel.this.currentNote, false);
                DailyItemsPanel.this.editorPanel.setDocument(DailyItemsPanel.this.currentNote);
            }
        });
        CurrentNote.addNoteListener(new NoteListener(){

            public void noteChange(Note note, boolean bl) {
                DailyItemsPanel.this.currentNoteChanged(note, bl);
            }
        });
        this.calendar.addSelectionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DailyItemsPanel.this.calendarIgnoreChange) {
                    return;
                }
                DailyItemsPanel.this.dateChangedByCalendar = true;
                CurrentDate.set(DailyItemsPanel.this.calendar.get());
                DailyItemsPanel.this.dateChangedByCalendar = false;
            }
        });
        AppFrame.addExitListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DailyItemsPanel.this.editorPanel.isDocumentChanged()) {
                    DailyItemsPanel.this.saveNote();
                    CurrentStorage.get().storeNoteList(CurrentProject.getNoteList(), CurrentProject.get());
                }
            }
        });
        History.addHistoryListener(new HistoryListener(){

            public void historyWasRolledTo(HistoryItem historyItem) {
                DailyItemsPanel.this.historyChanged(historyItem);
            }
        });
        EventsScheduler.addListener(new EventNotificationListener(){

            public void eventIsOccured(Event event) {
                System.out.println(event.getTimeString() + " " + event.getText());
                DailyItemsPanel.this.updateIndicators();
            }

            public void eventsChanged() {
                DailyItemsPanel.this.updateIndicators();
            }
        });
        this.currentDate = CurrentDate.get();
        this.currentNote = CurrentProject.getNoteList().getNoteForDate(CurrentDate.get());
        CurrentNote.set(this.currentNote, true);
        this.editorPanel.setDocument(this.currentNote);
        History.add(new HistoryItem(CurrentDate.get(), CurrentProject.get()));
        this.cmainPanel.add((Component)this.mainTabsPanel, "Center");
        this.mainTabsPanel.add((Component)this.eventsTabbedPane, "EVENTSTAB");
        this.mainTabsPanel.add((Component)this.tasksTabbedPane, "TASKSTAB");
        this.mainTabsPanel.add((Component)this.notesControlPane, "NOTESTAB");
        this.mainTabsPanel.add((Component)this.agendaTabbedPane, "AGENDATAB");
        this.updateIndicators(CurrentDate.get(), CurrentProject.getTaskList());
        this.mainPanel.setBorder(null);
    }

    void currentDateChanged(CalendarDate calendarDate) {
        Cursor cursor = App.getFrame().getCursor();
        App.getFrame().setCursor(this.waitCursor);
        if (!this.changedByHistory) {
            History.add(new HistoryItem(calendarDate, CurrentProject.get()));
        }
        if (!this.dateChangedByCalendar) {
            this.calendarIgnoreChange = true;
            this.calendar.set(calendarDate);
            this.calendarIgnoreChange = false;
        }
        this.currentNoteChanged(this.currentNote, true);
        this.currentNote = CurrentProject.getNoteList().getNoteForDate(calendarDate);
        CurrentNote.set(this.currentNote, true);
        this.currentDate = CurrentDate.get();
        this.currentDateLabel.setText(calendarDate.getFullDateString());
        if (this.currentNote != null && this.currentNote.isMarked()) {
            this.currentDateLabel.setIcon(this.bookmarkIcon);
            this.currentDateLabel.setHorizontalTextPosition(2);
        } else {
            this.currentDateLabel.setIcon(null);
        }
        this.updateIndicators(calendarDate, CurrentProject.getTaskList());
        App.getFrame().setCursor(cursor);
    }

    void currentNoteChanged(Note note, boolean bl) {
        if (this.editorPanel.isDocumentChanged()) {
            if (bl) {
                this.saveNote();
            }
            this.notesControlPane.refresh();
        }
        this.currentNote = note;
        this.editorPanel.setDocument(this.currentNote);
        this.calendar.set(CurrentDate.get());
        this.editorPanel.editor.requestFocus();
    }

    void currentProjectChanged(Project project, NoteList noteList, TaskList taskList, ResourcesList resourcesList) {
        Cursor cursor = App.getFrame().getCursor();
        App.getFrame().setCursor(this.waitCursor);
        if (!this.changedByHistory) {
            History.add(new HistoryItem(CurrentDate.get(), project));
        }
        if (this.editorPanel.isDocumentChanged()) {
            this.saveNote();
        }
        CurrentProject.save();
        this.updateIndicators(CurrentDate.get(), taskList);
        App.getFrame().setCursor(cursor);
    }

    void historyChanged(HistoryItem historyItem) {
        this.changedByHistory = true;
        CurrentProject.set(historyItem.getProject());
        CurrentDate.set(historyItem.getDate());
        this.changedByHistory = false;
    }

    public void saveNote() {
        if (this.currentNote == null) {
            this.currentNote = CurrentProject.getNoteList().createNoteForDate(this.currentDate);
        }
        this.currentNote.setTitle(this.editorPanel.titleField.getText());
        this.currentNote.setId(Util.generateId());
        CurrentStorage.get().storeNote(this.currentNote, this.editorPanel.getDocument());
    }

    void toggleButton_actionPerformed(ActionEvent actionEvent) {
        if (this.expanded) {
            this.expanded = false;
            this.toggleButton.setIcon(this.expIcon);
            this.controlPanel.remove(this.toggleToolBar);
            this.controlPanel.add((Component)this.toggleToolBar, "East");
            this.splitPane.setDividerLocation((int)this.controlPanel.getMinimumSize().getWidth());
        } else {
            this.expanded = true;
            this.toggleButton.setIcon(this.collIcon);
            this.controlPanel.remove(this.toggleToolBar);
            this.controlPanel.add((Component)this.toggleToolBar, "South");
            this.splitPane.setDividerLocation((int)this.controlPanel.getPreferredSize().getWidth());
        }
    }

    public void updateIndicators(CalendarDate calendarDate, TaskList taskList) {
        this.indicatorsPanel.removeAll();
        if (calendarDate.equals(CalendarDate.today())) {
            if (taskList.getActiveSubTasks(null, calendarDate).size() > 0) {
                this.indicatorsPanel.add((Component)this.taskB, null);
            }
            if (EventsScheduler.isEventScheduled()) {
                Event event = EventsScheduler.getFirstScheduledEvent();
                this.alarmB.setToolTipText(event.getTimeString() + " - " + event.getText());
                this.indicatorsPanel.add((Component)this.alarmB, null);
            }
        }
        this.indicatorsPanel.updateUI();
    }

    public void updateIndicators() {
        this.updateIndicators(CurrentDate.get(), CurrentProject.getTaskList());
    }

    public void selectPanel(String string) {
        if (this.calendar.jnCalendar.renderer.getTask() != null) {
            this.calendar.jnCalendar.renderer.setTask(null);
        }
        if (string.equals("TASKS") && this.tasksPanel.taskTable.getSelectedRow() > -1) {
            Task task = CurrentProject.getTaskList().getTask(this.tasksPanel.taskTable.getModel().getValueAt(this.tasksPanel.taskTable.getSelectedRow(), 100).toString());
            this.calendar.jnCalendar.renderer.setTask(task);
        }
        boolean bl = string.equals("AGENDA");
        this.agendaPanel.setActive(bl);
        if (bl) {
            this.agendaPanel.refresh(CurrentDate.get());
        }
        this.cardLayout1.show(this.editorsPanel, string);
        this.cardLayout2.show(this.mainTabsPanel, string + "TAB");
        this.calendar.jnCalendar.updateUI();
        this.CurrentPanel = string;
    }

    public String getCurrentPanel() {
        return this.CurrentPanel;
    }

    void taskB_actionPerformed(ActionEvent actionEvent) {
        this.parentPanel.tasksB_actionPerformed(null);
    }

    void alarmB_actionPerformed(ActionEvent actionEvent) {
        this.parentPanel.eventsB_actionPerformed(null);
    }
}

